/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import com.android.internal.util.Predicate;
import java.util.Arrays;

public class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... components) {
        return Predicates.and(Arrays.asList(components));
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> components) {
        return new AndPredicate(components);
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        return Predicates.or(Arrays.asList(components));
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> components) {
        return new OrPredicate(components);
    }

    public static <T> Predicate<T> not(Predicate<? super T> predicate) {
        return new NotPredicate(predicate);
    }

    private static class NotPredicate<T>
    implements Predicate<T> {
        private final Predicate<? super T> predicate;

        private NotPredicate(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean apply(T t) {
            return !this.predicate.apply(t);
        }
    }

    private static class OrPredicate<T>
    implements Predicate<T> {
        private final Iterable<? extends Predicate<? super T>> components;

        private OrPredicate(Iterable<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (!predicate.apply(t)) continue;
                return true;
            }
            return false;
        }
    }

    private static class AndPredicate<T>
    implements Predicate<T> {
        private final Iterable<? extends Predicate<? super T>> components;

        private AndPredicate(Iterable<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (predicate.apply(t)) continue;
                return false;
            }
            return true;
        }
    }
}

