/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.util.ArrayMap;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;

public class WakelockPowerCalculator
extends PowerCalculator {
    private static final String TAG = "WakelockPowerCalculator";
    private static final boolean DEBUG = false;
    private final double mPowerWakelock;
    private long mTotalAppWakelockTimeMs = 0L;

    public WakelockPowerCalculator(PowerProfile profile) {
        this.mPowerWakelock = profile.getAveragePower("cpu.awake");
    }

    @Override
    public void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        long wakeLockTimeUs = 0L;
        ArrayMap<String, ? extends BatteryStats.Uid.Wakelock> wakelockStats = u.getWakelockStats();
        int wakelockStatsCount = wakelockStats.size();
        for (int i = 0; i < wakelockStatsCount; ++i) {
            BatteryStats.Uid.Wakelock wakelock = wakelockStats.valueAt(i);
            BatteryStats.Timer timer = wakelock.getWakeTime(0);
            if (timer == null) continue;
            wakeLockTimeUs += timer.getTotalTimeLocked(rawRealtimeUs, statsType);
        }
        app.wakeLockTimeMs = wakeLockTimeUs / 1000L;
        this.mTotalAppWakelockTimeMs += app.wakeLockTimeMs;
        app.wakeLockPowerMah = (double)app.wakeLockTimeMs * this.mPowerWakelock / 3600000.0;
    }

    @Override
    public void calculateRemaining(BatterySipper app, BatteryStats stats, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        long wakeTimeMillis = stats.getBatteryUptime(rawUptimeUs) / 1000L;
        if ((wakeTimeMillis -= this.mTotalAppWakelockTimeMs + stats.getScreenOnTime(rawRealtimeUs, statsType) / 1000L) > 0L) {
            double power = (double)wakeTimeMillis * this.mPowerWakelock / 3600000.0;
            app.wakeLockTimeMs += wakeTimeMillis;
            app.wakeLockPowerMah += power;
        }
    }

    @Override
    public void reset() {
        this.mTotalAppWakelockTimeMs = 0L;
    }
}

