/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.DayPickerPagerAdapter;
import android.widget.SimpleMonthView;
import com.android.internal.util.Predicate;
import com.android.internal.widget.ViewPager;
import java.util.ArrayList;

class DayPickerViewPager
extends ViewPager {
    private final ArrayList<View> mMatchParentChildren = new ArrayList(1);

    public DayPickerViewPager(Context context) {
        this(context, null);
    }

    public DayPickerViewPager(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DayPickerViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public DayPickerViewPager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.populate();
        int count = this.getChildCount();
        boolean measureMatchParentChildren = View.MeasureSpec.getMode(widthMeasureSpec) != 0x40000000 || View.MeasureSpec.getMode(heightMeasureSpec) != 0x40000000;
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            ViewPager.LayoutParams lp = (ViewPager.LayoutParams)child.getLayoutParams();
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            childState = DayPickerViewPager.combineMeasuredStates(childState, child.getMeasuredState());
            if (!measureMatchParentChildren || lp.width != -1 && lp.height != -1) continue;
            this.mMatchParentChildren.add(child);
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        Drawable drawable2 = this.getForeground();
        if (drawable2 != null) {
            maxHeight = Math.max(maxHeight, drawable2.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable2.getMinimumWidth());
        }
        this.setMeasuredDimension(DayPickerViewPager.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), DayPickerViewPager.resolveSizeAndState(maxHeight, heightMeasureSpec, childState << 16));
        count = this.mMatchParentChildren.size();
        if (count > 1) {
            for (int i = 0; i < count; ++i) {
                View child = this.mMatchParentChildren.get(i);
                ViewPager.LayoutParams lp = (ViewPager.LayoutParams)child.getLayoutParams();
                int childWidthMeasureSpec = lp.width == -1 ? View.MeasureSpec.makeMeasureSpec(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight(), 0x40000000) : DayPickerViewPager.getChildMeasureSpec(widthMeasureSpec, this.getPaddingLeft() + this.getPaddingRight(), lp.width);
                int childHeightMeasureSpec = lp.height == -1 ? View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom(), 0x40000000) : DayPickerViewPager.getChildMeasureSpec(heightMeasureSpec, this.getPaddingTop() + this.getPaddingBottom(), lp.height);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
        this.mMatchParentChildren.clear();
    }

    @Override
    protected View findViewByPredicateTraversal(Predicate<View> predicate, View childToSkip) {
        View v;
        if (predicate.apply(this)) {
            return this;
        }
        DayPickerPagerAdapter adapter = (DayPickerPagerAdapter)this.getAdapter();
        SimpleMonthView current = adapter.getView(this.getCurrent());
        if (current != childToSkip && current != null && (v = current.findViewByPredicate(predicate)) != null) {
            return v;
        }
        int len = this.getChildCount();
        for (int i = 0; i < len; ++i) {
            View v2;
            View child = this.getChildAt(i);
            if (child == childToSkip || child == current || (v2 = child.findViewByPredicate(predicate)) == null) continue;
            return v2;
        }
        return null;
    }
}

