/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.android.internal.util.FastPrintWriter;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class TransactionTracker {
    private Map<String, Long> mTraces;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTraces() {
        TransactionTracker transactionTracker = this;
        synchronized (transactionTracker) {
            this.mTraces = new HashMap<String, Long>();
        }
    }

    TransactionTracker() {
        this.resetTraces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrace() {
        String trace = Log.getStackTraceString(new Throwable());
        TransactionTracker transactionTracker = this;
        synchronized (transactionTracker) {
            if (this.mTraces.containsKey(trace)) {
                this.mTraces.put(trace, this.mTraces.get(trace) + 1L);
            } else {
                this.mTraces.put(trace, 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTracesToFile(ParcelFileDescriptor fd) {
        if (this.mTraces.isEmpty()) {
            return;
        }
        FastPrintWriter pw = new FastPrintWriter(new FileOutputStream(fd.getFileDescriptor()));
        TransactionTracker transactionTracker = this;
        synchronized (transactionTracker) {
            for (String trace : this.mTraces.keySet()) {
                pw.println("Count: " + this.mTraces.get(trace));
                pw.println("Trace: " + trace);
                ((PrintWriter)pw).println();
            }
        }
        ((PrintWriter)pw).flush();
    }

    public void clearTraces() {
        this.resetTraces();
    }
}

