/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.UCaseProps;
import android.icu.lang.UCharacter;
import android.icu.text.Replaceable;
import android.icu.text.ReplaceableContextIterator;
import android.icu.text.SourceTargetUtility;
import android.icu.text.Transform;
import android.icu.text.Transliterator;
import android.icu.text.UTF16;
import android.icu.text.UnicodeSet;
import android.icu.util.ULocale;

class TitlecaseTransliterator
extends Transliterator {
    static final String _ID = "Any-Title";
    private ULocale locale;
    private UCaseProps csp;
    private ReplaceableContextIterator iter;
    private StringBuilder result;
    private int[] locCache;
    SourceTargetUtility sourceTargetUtility = null;

    static void register() {
        Transliterator.registerFactory(_ID, new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String ID) {
                return new TitlecaseTransliterator(ULocale.US);
            }
        });
        TitlecaseTransliterator.registerSpecialInverse("Title", "Lower", false);
    }

    public TitlecaseTransliterator(ULocale loc) {
        super(_ID, null);
        this.locale = loc;
        this.setMaximumContextLength(2);
        this.csp = UCaseProps.INSTANCE;
        this.iter = new ReplaceableContextIterator();
        this.result = new StringBuilder();
        this.locCache = new int[1];
        this.locCache[0] = 0;
    }

    @Override
    protected synchronized void handleTransliterate(Replaceable text, Transliterator.Position offsets, boolean isIncremental) {
        int type;
        int c;
        if (offsets.start >= offsets.limit) {
            return;
        }
        boolean doTitle = true;
        for (int start = offsets.start - 1; start >= offsets.contextStart; start -= UTF16.getCharCount(c)) {
            c = text.char32At(start);
            type = this.csp.getTypeOrIgnorable(c);
            if (type > 0) {
                doTitle = false;
                break;
            }
            if (type == 0) break;
        }
        this.iter.setText(text);
        this.iter.setIndex(offsets.start);
        this.iter.setLimit(offsets.limit);
        this.iter.setContextLimits(offsets.contextStart, offsets.contextLimit);
        this.result.setLength(0);
        while ((c = this.iter.nextCaseMapCP()) >= 0) {
            int delta;
            type = this.csp.getTypeOrIgnorable(c);
            if (type < 0) continue;
            c = doTitle ? this.csp.toFullTitle(c, this.iter, this.result, this.locale, this.locCache) : this.csp.toFullLower(c, this.iter, this.result, this.locale, this.locCache);
            boolean bl = doTitle = type == 0;
            if (this.iter.didReachLimit() && isIncremental) {
                offsets.start = this.iter.getCaseMapCPStart();
                return;
            }
            if (c < 0) continue;
            if (c <= 31) {
                delta = this.iter.replace(this.result.toString());
                this.result.setLength(0);
            } else {
                delta = this.iter.replace(UTF16.valueOf(c));
            }
            if (delta == 0) continue;
            offsets.limit += delta;
            offsets.contextLimit += delta;
        }
        offsets.start = offsets.limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSourceTargetSet(UnicodeSet inputFilter, UnicodeSet sourceSet, UnicodeSet targetSet) {
        TitlecaseTransliterator titlecaseTransliterator = this;
        synchronized (titlecaseTransliterator) {
            if (this.sourceTargetUtility == null) {
                this.sourceTargetUtility = new SourceTargetUtility(new Transform<String, String>(){

                    @Override
                    public String transform(String source) {
                        return UCharacter.toTitleCase(TitlecaseTransliterator.this.locale, source, null);
                    }
                });
            }
        }
        this.sourceTargetUtility.addSourceTargetSet(this, inputFilter, sourceSet, targetSet);
    }
}

