/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.nio.ByteBuffer;

public class UsbRequest {
    private static final String TAG = "UsbRequest";
    private long mNativeContext;
    private UsbEndpoint mEndpoint;
    private ByteBuffer mBuffer;
    private int mLength;
    private Object mClientData;

    public boolean initialize(UsbDeviceConnection connection, UsbEndpoint endpoint) {
        this.mEndpoint = endpoint;
        return this.native_init(connection, endpoint.getAddress(), endpoint.getAttributes(), endpoint.getMaxPacketSize(), endpoint.getInterval());
    }

    public void close() {
        this.mEndpoint = null;
        this.native_close();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mEndpoint != null) {
                Log.v(TAG, "endpoint still open in finalize(): " + this);
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public UsbEndpoint getEndpoint() {
        return this.mEndpoint;
    }

    public Object getClientData() {
        return this.mClientData;
    }

    public void setClientData(Object data) {
        this.mClientData = data;
    }

    public boolean queue(ByteBuffer buffer, int length) {
        boolean result;
        boolean out;
        boolean bl = out = this.mEndpoint.getDirection() == 0;
        if (buffer.isDirect()) {
            result = this.native_queue_direct(buffer, length, out);
        } else if (buffer.hasArray()) {
            result = this.native_queue_array(buffer.array(), length, out);
        } else {
            throw new IllegalArgumentException("buffer is not direct and has no array");
        }
        if (result) {
            this.mBuffer = buffer;
            this.mLength = length;
        }
        return result;
    }

    void dequeue() {
        boolean out = this.mEndpoint.getDirection() == 0;
        int bytesRead = this.mBuffer.isDirect() ? this.native_dequeue_direct() : this.native_dequeue_array(this.mBuffer.array(), this.mLength, out);
        if (bytesRead >= 0) {
            this.mBuffer.position(Math.min(bytesRead, this.mLength));
        }
        this.mBuffer = null;
        this.mLength = 0;
    }

    public boolean cancel() {
        return this.native_cancel();
    }

    private boolean native_init(UsbDeviceConnection usbDeviceConnection, int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_init(Landroid/hardware/usb/UsbDeviceConnection;IIII)Z", true, this) != 0;
    }

    private void native_close() {
        OverrideMethod.invokeV("android.hardware.usb.UsbRequest#native_close()V", true, this);
    }

    private boolean native_queue_array(byte[] byArray, int n, boolean bl) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_queue_array([BIZ)Z", true, this) != 0;
    }

    private int native_dequeue_array(byte[] byArray, int n, boolean bl) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_dequeue_array([BIZ)I", true, this);
    }

    private boolean native_queue_direct(ByteBuffer byteBuffer, int n, boolean bl) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_queue_direct(Ljava/nio/ByteBuffer;IZ)Z", true, this) != 0;
    }

    private int native_dequeue_direct() {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_dequeue_direct()I", true, this);
    }

    private boolean native_cancel() {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_cancel()Z", true, this) != 0;
    }
}

