/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter_Delegate;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class ColorMatrixColorFilter
extends ColorFilter {
    private final ColorMatrix mMatrix = new ColorMatrix();

    public ColorMatrixColorFilter(ColorMatrix matrix) {
        this.mMatrix.set(matrix);
        this.update();
    }

    public ColorMatrixColorFilter(float[] array2) {
        if (array2.length < 20) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mMatrix.set(array2);
        this.update();
    }

    public ColorMatrix getColorMatrix() {
        return this.mMatrix;
    }

    public void setColorMatrix(ColorMatrix matrix) {
        if (matrix == null) {
            this.mMatrix.reset();
        } else if (matrix != this.mMatrix) {
            this.mMatrix.set(matrix);
        }
        this.update();
    }

    public void setColorMatrix(float[] array2) {
        if (array2 == null) {
            this.mMatrix.reset();
        } else {
            if (array2.length < 20) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.mMatrix.set(array2);
        }
        this.update();
    }

    private void update() {
        float[] colorMatrix = this.mMatrix.getArray();
        ColorMatrixColorFilter.destroyFilter(this.native_instance);
        this.native_instance = ColorMatrixColorFilter.nativeColorMatrixFilter(colorMatrix);
    }

    @LayoutlibDelegate
    private static long nativeColorMatrixFilter(float[] fArray) {
        return ColorMatrixColorFilter_Delegate.nativeColorMatrixFilter(fArray);
    }
}

