/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.NativeAllocatorTag;
import android.graphics.SurfaceTexture;
import android.media.MediaRecorder;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import com.android.tools.layoutlib.create.OverrideMethod;

public class GLEnvironment {
    private int glEnvId;
    private boolean mManageContext = true;

    public GLEnvironment() {
        this.nativeAllocate();
    }

    private GLEnvironment(NativeAllocatorTag tag) {
    }

    public synchronized void tearDown() {
        if (this.glEnvId != -1) {
            this.nativeDeallocate();
            this.glEnvId = -1;
        }
    }

    protected void finalize() throws Throwable {
        this.tearDown();
    }

    public void initWithNewContext() {
        this.mManageContext = true;
        if (!this.nativeInitWithNewContext()) {
            throw new RuntimeException("Could not initialize GLEnvironment with new context!");
        }
    }

    public void initWithCurrentContext() {
        this.mManageContext = false;
        if (!this.nativeInitWithCurrentContext()) {
            throw new RuntimeException("Could not initialize GLEnvironment with current context!");
        }
    }

    public boolean isActive() {
        return this.nativeIsActive();
    }

    public boolean isContextActive() {
        return this.nativeIsContextActive();
    }

    public static boolean isAnyContextActive() {
        return GLEnvironment.nativeIsAnyContextActive();
    }

    public void activate() {
        if (Looper.myLooper() != null && Looper.myLooper().equals(Looper.getMainLooper())) {
            Log.e("FilterFramework", "Activating GL context in UI thread!");
        }
        if (this.mManageContext && !this.nativeActivate()) {
            throw new RuntimeException("Could not activate GLEnvironment!");
        }
    }

    public void deactivate() {
        if (this.mManageContext && !this.nativeDeactivate()) {
            throw new RuntimeException("Could not deactivate GLEnvironment!");
        }
    }

    public void swapBuffers() {
        if (!this.nativeSwapBuffers()) {
            throw new RuntimeException("Error swapping EGL buffers!");
        }
    }

    public int registerSurface(Surface surface) {
        int result = this.nativeAddSurface(surface);
        if (result < 0) {
            throw new RuntimeException("Error registering surface " + surface + "!");
        }
        return result;
    }

    public int registerSurfaceTexture(SurfaceTexture surfaceTexture, int width, int height) {
        Surface surface = new Surface(surfaceTexture);
        int result = this.nativeAddSurfaceWidthHeight(surface, width, height);
        surface.release();
        if (result < 0) {
            throw new RuntimeException("Error registering surfaceTexture " + surfaceTexture + "!");
        }
        return result;
    }

    public int registerSurfaceFromMediaRecorder(MediaRecorder mediaRecorder) {
        int result = this.nativeAddSurfaceFromMediaRecorder(mediaRecorder);
        if (result < 0) {
            throw new RuntimeException("Error registering surface from MediaRecorder" + mediaRecorder + "!");
        }
        return result;
    }

    public void activateSurfaceWithId(int surfaceId) {
        if (!this.nativeActivateSurfaceId(surfaceId)) {
            throw new RuntimeException("Could not activate surface " + surfaceId + "!");
        }
    }

    public void unregisterSurfaceId(int surfaceId) {
        if (!this.nativeRemoveSurfaceId(surfaceId)) {
            throw new RuntimeException("Could not unregister surface " + surfaceId + "!");
        }
    }

    public void setSurfaceTimestamp(long timestamp) {
        if (!this.nativeSetSurfaceTimestamp(timestamp)) {
            throw new RuntimeException("Could not set timestamp for current surface!");
        }
    }

    private boolean nativeInitWithNewContext() {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeInitWithNewContext()Z", true, this) != 0;
    }

    private boolean nativeInitWithCurrentContext() {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeInitWithCurrentContext()Z", true, this) != 0;
    }

    private boolean nativeIsActive() {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeIsActive()Z", true, this) != 0;
    }

    private boolean nativeIsContextActive() {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeIsContextActive()Z", true, this) != 0;
    }

    private static boolean nativeIsAnyContextActive() {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeIsAnyContextActive()Z", true, null) != 0;
    }

    private boolean nativeActivate() {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeActivate()Z", true, this) != 0;
    }

    private boolean nativeDeactivate() {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeDeactivate()Z", true, this) != 0;
    }

    private boolean nativeSwapBuffers() {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeSwapBuffers()Z", true, this) != 0;
    }

    private boolean nativeAllocate() {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeAllocate()Z", true, this) != 0;
    }

    private boolean nativeDeallocate() {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeDeallocate()Z", true, this) != 0;
    }

    private int nativeAddSurface(Surface surface) {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeAddSurface(Landroid/view/Surface;)I", true, this);
    }

    private int nativeAddSurfaceWidthHeight(Surface surface, int n, int n2) {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeAddSurfaceWidthHeight(Landroid/view/Surface;II)I", true, this);
    }

    private int nativeAddSurfaceFromMediaRecorder(MediaRecorder mediaRecorder) {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeAddSurfaceFromMediaRecorder(Landroid/media/MediaRecorder;)I", true, this);
    }

    private boolean nativeDisconnectSurfaceMediaSource(MediaRecorder mediaRecorder) {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeDisconnectSurfaceMediaSource(Landroid/media/MediaRecorder;)Z", true, this) != 0;
    }

    private boolean nativeActivateSurfaceId(int n) {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeActivateSurfaceId(I)Z", true, this) != 0;
    }

    private boolean nativeRemoveSurfaceId(int n) {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeRemoveSurfaceId(I)Z", true, this) != 0;
    }

    private boolean nativeSetSurfaceTimestamp(long l) {
        return OverrideMethod.invokeI("android.filterfw.core.GLEnvironment#nativeSetSurfaceTimestamp(J)Z", true, this) != 0;
    }

    static {
        System.loadLibrary("filterfw");
    }
}

