/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.IPackageInstaller;
import android.content.pm.IPackageInstallerCallback;
import android.content.pm.IPackageInstallerSession;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.FileBridge;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.ExceptionUtils;
import com.android.internal.util.IndentingPrintWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PackageInstaller {
    private static final String TAG = "PackageInstaller";
    public static final String ACTION_SESSION_DETAILS = "android.content.pm.action.SESSION_DETAILS";
    public static final String ACTION_CONFIRM_PERMISSIONS = "android.content.pm.action.CONFIRM_PERMISSIONS";
    public static final String EXTRA_SESSION_ID = "android.content.pm.extra.SESSION_ID";
    public static final String EXTRA_PACKAGE_NAME = "android.content.pm.extra.PACKAGE_NAME";
    public static final String EXTRA_STATUS = "android.content.pm.extra.STATUS";
    public static final String EXTRA_STATUS_MESSAGE = "android.content.pm.extra.STATUS_MESSAGE";
    public static final String EXTRA_OTHER_PACKAGE_NAME = "android.content.pm.extra.OTHER_PACKAGE_NAME";
    public static final String EXTRA_STORAGE_PATH = "android.content.pm.extra.STORAGE_PATH";
    @Deprecated
    public static final String EXTRA_PACKAGE_NAMES = "android.content.pm.extra.PACKAGE_NAMES";
    public static final String EXTRA_LEGACY_STATUS = "android.content.pm.extra.LEGACY_STATUS";
    public static final String EXTRA_LEGACY_BUNDLE = "android.content.pm.extra.LEGACY_BUNDLE";
    public static final String EXTRA_CALLBACK = "android.content.pm.extra.CALLBACK";
    public static final int STATUS_PENDING_USER_ACTION = -1;
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_FAILURE_BLOCKED = 2;
    public static final int STATUS_FAILURE_ABORTED = 3;
    public static final int STATUS_FAILURE_INVALID = 4;
    public static final int STATUS_FAILURE_CONFLICT = 5;
    public static final int STATUS_FAILURE_STORAGE = 6;
    public static final int STATUS_FAILURE_INCOMPATIBLE = 7;
    private final Context mContext;
    private final PackageManager mPm;
    private final IPackageInstaller mInstaller;
    private final int mUserId;
    private final String mInstallerPackageName;
    private final ArrayList<SessionCallbackDelegate> mDelegates = new ArrayList();

    public PackageInstaller(Context context, PackageManager pm, IPackageInstaller installer, String installerPackageName, int userId) {
        this.mContext = context;
        this.mPm = pm;
        this.mInstaller = installer;
        this.mInstallerPackageName = installerPackageName;
        this.mUserId = userId;
    }

    public int createSession(SessionParams params) throws IOException {
        try {
            return this.mInstaller.createSession(params, this.mInstallerPackageName, this.mUserId);
        }
        catch (RuntimeException e) {
            ExceptionUtils.maybeUnwrapIOException(e);
            throw e;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Session openSession(int sessionId) throws IOException {
        try {
            return new Session(this.mInstaller.openSession(sessionId));
        }
        catch (RuntimeException e) {
            ExceptionUtils.maybeUnwrapIOException(e);
            throw e;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void updateSessionAppIcon(int sessionId, Bitmap appIcon) {
        try {
            this.mInstaller.updateSessionAppIcon(sessionId, appIcon);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void updateSessionAppLabel(int sessionId, CharSequence appLabel) {
        try {
            String val = appLabel != null ? appLabel.toString() : null;
            this.mInstaller.updateSessionAppLabel(sessionId, val);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void abandonSession(int sessionId) {
        try {
            this.mInstaller.abandonSession(sessionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public SessionInfo getSessionInfo(int sessionId) {
        try {
            return this.mInstaller.getSessionInfo(sessionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<SessionInfo> getAllSessions() {
        try {
            return this.mInstaller.getAllSessions(this.mUserId).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<SessionInfo> getMySessions() {
        try {
            return this.mInstaller.getMySessions(this.mInstallerPackageName, this.mUserId).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void uninstall(String packageName, IntentSender statusReceiver) {
        try {
            this.mInstaller.uninstall(packageName, this.mInstallerPackageName, 0, statusReceiver, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setPermissionsResult(int sessionId, boolean accepted) {
        try {
            this.mInstaller.setPermissionsResult(sessionId, accepted);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void addSessionCallback(SessionCallback callback) {
        this.registerSessionCallback(callback);
    }

    public void registerSessionCallback(SessionCallback callback) {
        this.registerSessionCallback(callback, new Handler());
    }

    @Deprecated
    public void addSessionCallback(SessionCallback callback, Handler handler) {
        this.registerSessionCallback(callback, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSessionCallback(SessionCallback callback, Handler handler) {
        ArrayList<SessionCallbackDelegate> arrayList = this.mDelegates;
        synchronized (arrayList) {
            SessionCallbackDelegate delegate = new SessionCallbackDelegate(callback, handler.getLooper());
            try {
                this.mInstaller.registerCallback(delegate, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mDelegates.add(delegate);
        }
    }

    @Deprecated
    public void removeSessionCallback(SessionCallback callback) {
        this.unregisterSessionCallback(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSessionCallback(SessionCallback callback) {
        ArrayList<SessionCallbackDelegate> arrayList = this.mDelegates;
        synchronized (arrayList) {
            Iterator<SessionCallbackDelegate> i = this.mDelegates.iterator();
            while (i.hasNext()) {
                SessionCallbackDelegate delegate = i.next();
                if (delegate.mCallback != callback) continue;
                try {
                    this.mInstaller.unregisterCallback(delegate);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                i.remove();
            }
        }
    }

    public static class SessionInfo
    implements Parcelable {
        public int sessionId;
        public String installerPackageName;
        public String resolvedBaseCodePath;
        public float progress;
        public boolean sealed;
        public boolean active;
        public int mode;
        public long sizeBytes;
        public String appPackageName;
        public Bitmap appIcon;
        public CharSequence appLabel;
        public static final Parcelable.Creator<SessionInfo> CREATOR = new Parcelable.Creator<SessionInfo>(){

            @Override
            public SessionInfo createFromParcel(Parcel p) {
                return new SessionInfo(p);
            }

            public SessionInfo[] newArray(int size) {
                return new SessionInfo[size];
            }
        };

        public SessionInfo() {
        }

        public SessionInfo(Parcel source) {
            this.sessionId = source.readInt();
            this.installerPackageName = source.readString();
            this.resolvedBaseCodePath = source.readString();
            this.progress = source.readFloat();
            this.sealed = source.readInt() != 0;
            this.active = source.readInt() != 0;
            this.mode = source.readInt();
            this.sizeBytes = source.readLong();
            this.appPackageName = source.readString();
            this.appIcon = (Bitmap)source.readParcelable(null);
            this.appLabel = source.readString();
        }

        public int getSessionId() {
            return this.sessionId;
        }

        public String getInstallerPackageName() {
            return this.installerPackageName;
        }

        public float getProgress() {
            return this.progress;
        }

        public boolean isActive() {
            return this.active;
        }

        @Deprecated
        public boolean isOpen() {
            return this.isActive();
        }

        public String getAppPackageName() {
            return this.appPackageName;
        }

        public Bitmap getAppIcon() {
            return this.appIcon;
        }

        public CharSequence getAppLabel() {
            return this.appLabel;
        }

        public Intent createDetailsIntent() {
            Intent intent = new Intent(PackageInstaller.ACTION_SESSION_DETAILS);
            intent.putExtra(PackageInstaller.EXTRA_SESSION_ID, this.sessionId);
            intent.setPackage(this.installerPackageName);
            intent.setFlags(0x10000000);
            return intent;
        }

        @Deprecated
        public Intent getDetailsIntent() {
            return this.createDetailsIntent();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.sessionId);
            dest.writeString(this.installerPackageName);
            dest.writeString(this.resolvedBaseCodePath);
            dest.writeFloat(this.progress);
            dest.writeInt(this.sealed ? 1 : 0);
            dest.writeInt(this.active ? 1 : 0);
            dest.writeInt(this.mode);
            dest.writeLong(this.sizeBytes);
            dest.writeString(this.appPackageName);
            dest.writeParcelable(this.appIcon, flags);
            dest.writeString(this.appLabel != null ? this.appLabel.toString() : null);
        }
    }

    public static class SessionParams
    implements Parcelable {
        public static final int MODE_INVALID = -1;
        public static final int MODE_FULL_INSTALL = 1;
        public static final int MODE_INHERIT_EXISTING = 2;
        public static final int UID_UNKNOWN = -1;
        public int mode = -1;
        public int installFlags;
        public int installLocation = 1;
        public long sizeBytes = -1L;
        public String appPackageName;
        public Bitmap appIcon;
        public String appLabel;
        public long appIconLastModified = -1L;
        public Uri originatingUri;
        public int originatingUid = -1;
        public Uri referrerUri;
        public String abiOverride;
        public String volumeUuid;
        public String[] grantedRuntimePermissions;
        public static final Parcelable.Creator<SessionParams> CREATOR = new Parcelable.Creator<SessionParams>(){

            @Override
            public SessionParams createFromParcel(Parcel p) {
                return new SessionParams(p);
            }

            public SessionParams[] newArray(int size) {
                return new SessionParams[size];
            }
        };

        public SessionParams(int mode) {
            this.mode = mode;
        }

        public SessionParams(Parcel source) {
            this.mode = source.readInt();
            this.installFlags = source.readInt();
            this.installLocation = source.readInt();
            this.sizeBytes = source.readLong();
            this.appPackageName = source.readString();
            this.appIcon = (Bitmap)source.readParcelable(null);
            this.appLabel = source.readString();
            this.originatingUri = (Uri)source.readParcelable(null);
            this.originatingUid = source.readInt();
            this.referrerUri = (Uri)source.readParcelable(null);
            this.abiOverride = source.readString();
            this.volumeUuid = source.readString();
            this.grantedRuntimePermissions = source.readStringArray();
        }

        public void setInstallLocation(int installLocation) {
            this.installLocation = installLocation;
        }

        public void setSize(long sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        public void setAppPackageName(String appPackageName) {
            this.appPackageName = appPackageName;
        }

        public void setAppIcon(Bitmap appIcon) {
            this.appIcon = appIcon;
        }

        public void setAppLabel(CharSequence appLabel) {
            this.appLabel = appLabel != null ? appLabel.toString() : null;
        }

        public void setOriginatingUri(Uri originatingUri) {
            this.originatingUri = originatingUri;
        }

        public void setOriginatingUid(int originatingUid) {
            this.originatingUid = originatingUid;
        }

        public void setReferrerUri(Uri referrerUri) {
            this.referrerUri = referrerUri;
        }

        public void setGrantedRuntimePermissions(String[] permissions) {
            this.installFlags |= 0x100;
            this.grantedRuntimePermissions = permissions;
        }

        public void setInstallFlagsInternal() {
            this.installFlags |= 0x10;
            this.installFlags &= 0xFFFFFFF7;
        }

        public void setAllowDowngrade(boolean allowDowngrade) {
            this.installFlags = allowDowngrade ? (this.installFlags |= 0x80) : (this.installFlags &= 0xFFFFFF7F);
        }

        public void setInstallFlagsExternal() {
            this.installFlags |= 8;
            this.installFlags &= 0xFFFFFFEF;
        }

        public void setInstallFlagsForcePermissionPrompt() {
            this.installFlags |= 0x400;
        }

        public void setDontKillApp(boolean dontKillApp) {
            this.installFlags = dontKillApp ? (this.installFlags |= 0x1000) : (this.installFlags &= 0xFFFFEFFF);
        }

        public void dump(IndentingPrintWriter pw) {
            pw.printPair("mode", this.mode);
            pw.printHexPair("installFlags", this.installFlags);
            pw.printPair("installLocation", this.installLocation);
            pw.printPair("sizeBytes", this.sizeBytes);
            pw.printPair("appPackageName", this.appPackageName);
            pw.printPair("appIcon", this.appIcon != null);
            pw.printPair("appLabel", this.appLabel);
            pw.printPair("originatingUri", this.originatingUri);
            pw.printPair("originatingUid", this.originatingUid);
            pw.printPair("referrerUri", this.referrerUri);
            pw.printPair("abiOverride", this.abiOverride);
            pw.printPair("volumeUuid", this.volumeUuid);
            pw.printPair("grantedRuntimePermissions", this.grantedRuntimePermissions);
            pw.println();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mode);
            dest.writeInt(this.installFlags);
            dest.writeInt(this.installLocation);
            dest.writeLong(this.sizeBytes);
            dest.writeString(this.appPackageName);
            dest.writeParcelable(this.appIcon, flags);
            dest.writeString(this.appLabel);
            dest.writeParcelable(this.originatingUri, flags);
            dest.writeInt(this.originatingUid);
            dest.writeParcelable(this.referrerUri, flags);
            dest.writeString(this.abiOverride);
            dest.writeString(this.volumeUuid);
            dest.writeStringArray(this.grantedRuntimePermissions);
        }
    }

    public static class Session
    implements Closeable {
        private IPackageInstallerSession mSession;

        public Session(IPackageInstallerSession session) {
            this.mSession = session;
        }

        @Deprecated
        public void setProgress(float progress) {
            this.setStagingProgress(progress);
        }

        public void setStagingProgress(float progress) {
            try {
                this.mSession.setClientProgress(progress);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void addProgress(float progress) {
            try {
                this.mSession.addClientProgress(progress);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public OutputStream openWrite(String name, long offsetBytes, long lengthBytes) throws IOException {
            try {
                ParcelFileDescriptor clientSocket = this.mSession.openWrite(name, offsetBytes, lengthBytes);
                return new FileBridge.FileBridgeOutputStream(clientSocket);
            }
            catch (RuntimeException e) {
                ExceptionUtils.maybeUnwrapIOException(e);
                throw e;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void fsync(OutputStream out) throws IOException {
            if (!(out instanceof FileBridge.FileBridgeOutputStream)) {
                throw new IllegalArgumentException("Unrecognized stream");
            }
            ((FileBridge.FileBridgeOutputStream)out).fsync();
        }

        public String[] getNames() throws IOException {
            try {
                return this.mSession.getNames();
            }
            catch (RuntimeException e) {
                ExceptionUtils.maybeUnwrapIOException(e);
                throw e;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public InputStream openRead(String name) throws IOException {
            try {
                ParcelFileDescriptor pfd = this.mSession.openRead(name);
                return new ParcelFileDescriptor.AutoCloseInputStream(pfd);
            }
            catch (RuntimeException e) {
                ExceptionUtils.maybeUnwrapIOException(e);
                throw e;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void removeSplit(String splitName) throws IOException {
            try {
                this.mSession.removeSplit(splitName);
            }
            catch (RuntimeException e) {
                ExceptionUtils.maybeUnwrapIOException(e);
                throw e;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void commit(IntentSender statusReceiver) {
            try {
                this.mSession.commit(statusReceiver);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @Override
        public void close() {
            try {
                this.mSession.close();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public void abandon() {
            try {
                this.mSession.abandon();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private static class SessionCallbackDelegate
    extends IPackageInstallerCallback.Stub
    implements Handler.Callback {
        private static final int MSG_SESSION_CREATED = 1;
        private static final int MSG_SESSION_BADGING_CHANGED = 2;
        private static final int MSG_SESSION_ACTIVE_CHANGED = 3;
        private static final int MSG_SESSION_PROGRESS_CHANGED = 4;
        private static final int MSG_SESSION_FINISHED = 5;
        final SessionCallback mCallback;
        final Handler mHandler;

        public SessionCallbackDelegate(SessionCallback callback, Looper looper) {
            this.mCallback = callback;
            this.mHandler = new Handler(looper, this);
        }

        @Override
        public boolean handleMessage(Message msg) {
            int sessionId = msg.arg1;
            switch (msg.what) {
                case 1: {
                    this.mCallback.onCreated(sessionId);
                    return true;
                }
                case 2: {
                    this.mCallback.onBadgingChanged(sessionId);
                    return true;
                }
                case 3: {
                    boolean active = msg.arg2 != 0;
                    this.mCallback.onActiveChanged(sessionId, active);
                    return true;
                }
                case 4: {
                    this.mCallback.onProgressChanged(sessionId, ((Float)msg.obj).floatValue());
                    return true;
                }
                case 5: {
                    this.mCallback.onFinished(sessionId, msg.arg2 != 0);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onSessionCreated(int sessionId) {
            this.mHandler.obtainMessage(1, sessionId, 0).sendToTarget();
        }

        @Override
        public void onSessionBadgingChanged(int sessionId) {
            this.mHandler.obtainMessage(2, sessionId, 0).sendToTarget();
        }

        @Override
        public void onSessionActiveChanged(int sessionId, boolean active) {
            this.mHandler.obtainMessage(3, sessionId, active ? 1 : 0).sendToTarget();
        }

        @Override
        public void onSessionProgressChanged(int sessionId, float progress) {
            this.mHandler.obtainMessage(4, sessionId, 0, Float.valueOf(progress)).sendToTarget();
        }

        @Override
        public void onSessionFinished(int sessionId, boolean success) {
            this.mHandler.obtainMessage(5, sessionId, success ? 1 : 0).sendToTarget();
        }
    }

    public static abstract class SessionCallback {
        public abstract void onCreated(int var1);

        public abstract void onBadgingChanged(int var1);

        public abstract void onActiveChanged(int var1, boolean var2);

        public abstract void onProgressChanged(int var1, float var2);

        public abstract void onFinished(int var1, boolean var2);
    }
}

