/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentInsertHandler;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.net.Uri;
import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DefaultDataHandler
implements ContentInsertHandler {
    private static final String ROW = "row";
    private static final String COL = "col";
    private static final String URI_STR = "uri";
    private static final String POSTFIX = "postfix";
    private static final String DEL = "del";
    private static final String SELECT = "select";
    private static final String ARG = "arg";
    private Stack<Uri> mUris = new Stack();
    private ContentValues mValues;
    private ContentResolver mContentResolver;

    @Override
    public void insert(ContentResolver contentResolver, InputStream in) throws IOException, SAXException {
        this.mContentResolver = contentResolver;
        Xml.parse(in, Xml.Encoding.UTF_8, this);
    }

    @Override
    public void insert(ContentResolver contentResolver, String in) throws SAXException {
        this.mContentResolver = contentResolver;
        Xml.parse(in, (ContentHandler)this);
    }

    private void parseRow(Attributes atts) throws SAXException {
        Uri uri;
        String uriStr = atts.getValue(URI_STR);
        if (uriStr != null) {
            uri = Uri.parse(uriStr);
            if (uri == null) {
                throw new SAXException("attribute " + atts.getValue(URI_STR) + " parsing failure");
            }
        } else if (this.mUris.size() > 0) {
            String postfix = atts.getValue(POSTFIX);
            uri = postfix != null ? Uri.withAppendedPath((Uri)this.mUris.lastElement(), postfix) : (Uri)this.mUris.lastElement();
        } else {
            throw new SAXException("attribute parsing failure");
        }
        this.mUris.push(uri);
    }

    private Uri insertRow() {
        Uri u = this.mContentResolver.insert((Uri)this.mUris.lastElement(), this.mValues);
        this.mValues = null;
        return u;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (ROW.equals(localName)) {
            if (this.mValues != null) {
                if (this.mUris.empty()) {
                    throw new SAXException("uri is empty");
                }
                Uri nextUri = this.insertRow();
                if (nextUri == null) {
                    throw new SAXException("insert to uri " + ((Uri)this.mUris.lastElement()).toString() + " failure");
                }
                this.mUris.pop();
                this.mUris.push(nextUri);
                this.parseRow(atts);
                return;
            } else {
                int attrLen = atts.getLength();
                if (attrLen == 0) {
                    this.mUris.push((Uri)this.mUris.lastElement());
                    return;
                } else {
                    this.parseRow(atts);
                }
            }
            return;
        } else if (COL.equals(localName)) {
            int attrLen = atts.getLength();
            if (attrLen != 2) {
                throw new SAXException("illegal attributes number " + attrLen);
            }
            String key = atts.getValue(0);
            String value = atts.getValue(1);
            if (key == null || key.length() <= 0 || value == null || value.length() <= 0) throw new SAXException("illegal attributes value");
            if (this.mValues == null) {
                this.mValues = new ContentValues();
            }
            this.mValues.put(key, value);
            return;
        } else {
            if (!DEL.equals(localName)) throw new SAXException("unknown element: " + localName);
            Uri u = Uri.parse(atts.getValue(URI_STR));
            if (u == null) {
                throw new SAXException("attribute " + atts.getValue(URI_STR) + " parsing failure");
            }
            int attrLen = atts.getLength() - 2;
            if (attrLen > 0) {
                String[] selectionArgs = new String[attrLen];
                for (int i = 0; i < attrLen; ++i) {
                    selectionArgs[i] = atts.getValue(i + 2);
                }
                this.mContentResolver.delete(u, atts.getValue(1), selectionArgs);
                return;
            } else if (attrLen == 0) {
                this.mContentResolver.delete(u, atts.getValue(1), null);
                return;
            } else {
                this.mContentResolver.delete(u, null, null);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (ROW.equals(localName)) {
            if (this.mUris.empty()) {
                throw new SAXException("uri mismatch");
            }
            if (this.mValues != null) {
                this.insertRow();
            }
            this.mUris.pop();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

