/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothGattCallbackWrapper;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class BluetoothLeAdvertiser {
    private static final String TAG = "BluetoothLeAdvertiser";
    private static final int MAX_ADVERTISING_DATA_BYTES = 31;
    private static final int OVERHEAD_BYTES_PER_FIELD = 2;
    private static final int FLAGS_FIELD_BYTES = 3;
    private static final int MANUFACTURER_SPECIFIC_DATA_LENGTH = 2;
    private static final int SERVICE_DATA_UUID_LENGTH = 2;
    private final IBluetoothManager mBluetoothManager;
    private final Handler mHandler;
    private BluetoothAdapter mBluetoothAdapter;
    private final Map<AdvertiseCallback, AdvertiseCallbackWrapper> mLeAdvertisers = new HashMap<AdvertiseCallback, AdvertiseCallbackWrapper>();

    public BluetoothLeAdvertiser(IBluetoothManager bluetoothManager) {
        this.mBluetoothManager = bluetoothManager;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public void startAdvertising(AdvertiseSettings settings, AdvertiseData advertiseData, AdvertiseCallback callback) {
        this.startAdvertising(settings, advertiseData, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAdvertising(AdvertiseSettings settings, AdvertiseData advertiseData, AdvertiseData scanResponse, AdvertiseCallback callback) {
        Map<AdvertiseCallback, AdvertiseCallbackWrapper> map = this.mLeAdvertisers;
        synchronized (map) {
            IBluetoothGatt gatt;
            BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
            if (callback == null) {
                throw new IllegalArgumentException("callback cannot be null");
            }
            if (!this.mBluetoothAdapter.isMultipleAdvertisementSupported() && !this.mBluetoothAdapter.isPeripheralModeSupported()) {
                this.postStartFailure(callback, 5);
                return;
            }
            boolean isConnectable = settings.isConnectable();
            if (this.totalBytes(advertiseData, isConnectable) > 31 || this.totalBytes(scanResponse, false) > 31) {
                this.postStartFailure(callback, 1);
                return;
            }
            if (this.mLeAdvertisers.containsKey(callback)) {
                this.postStartFailure(callback, 3);
                return;
            }
            try {
                gatt = this.mBluetoothManager.getBluetoothGatt();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to get Bluetooth gatt - ", e);
                this.postStartFailure(callback, 4);
                return;
            }
            AdvertiseCallbackWrapper wrapper = new AdvertiseCallbackWrapper(callback, advertiseData, scanResponse, settings, gatt);
            wrapper.startRegisteration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAdvertising(AdvertiseCallback callback) {
        Map<AdvertiseCallback, AdvertiseCallbackWrapper> map = this.mLeAdvertisers;
        synchronized (map) {
            if (callback == null) {
                throw new IllegalArgumentException("callback cannot be null");
            }
            AdvertiseCallbackWrapper wrapper = this.mLeAdvertisers.get(callback);
            if (wrapper == null) {
                return;
            }
            wrapper.stopAdvertising();
        }
    }

    public void cleanup() {
        this.mLeAdvertisers.clear();
    }

    private int totalBytes(AdvertiseData data, boolean isFlagsIncluded) {
        int size;
        if (data == null) {
            return 0;
        }
        int n = size = isFlagsIncluded ? 3 : 0;
        if (data.getServiceUuids() != null) {
            int num16BitUuids = 0;
            int num32BitUuids = 0;
            int num128BitUuids = 0;
            for (ParcelUuid uuid : data.getServiceUuids()) {
                if (BluetoothUuid.is16BitUuid(uuid)) {
                    ++num16BitUuids;
                    continue;
                }
                if (BluetoothUuid.is32BitUuid(uuid)) {
                    ++num32BitUuids;
                    continue;
                }
                ++num128BitUuids;
            }
            if (num16BitUuids != 0) {
                size += 2 + num16BitUuids * 2;
            }
            if (num32BitUuids != 0) {
                size += 2 + num32BitUuids * 4;
            }
            if (num128BitUuids != 0) {
                size += 2 + num128BitUuids * 16;
            }
        }
        for (ParcelUuid uuid : data.getServiceData().keySet()) {
            size += 4 + this.byteLength(data.getServiceData().get(uuid));
        }
        for (int i = 0; i < data.getManufacturerSpecificData().size(); ++i) {
            size += 4 + this.byteLength(data.getManufacturerSpecificData().valueAt(i));
        }
        if (data.getIncludeTxPowerLevel()) {
            size += 3;
        }
        if (data.getIncludeDeviceName() && this.mBluetoothAdapter.getName() != null) {
            size += 2 + this.mBluetoothAdapter.getName().length();
        }
        return size;
    }

    private int byteLength(byte[] array2) {
        return array2 == null ? 0 : array2.length;
    }

    private void postStartFailure(final AdvertiseCallback callback, final int error) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                callback.onStartFailure(error);
            }
        });
    }

    private void postStartSuccess(final AdvertiseCallback callback, final AdvertiseSettings settings) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                callback.onStartSuccess(settings);
            }
        });
    }

    private class AdvertiseCallbackWrapper
    extends BluetoothGattCallbackWrapper {
        private static final int LE_CALLBACK_TIMEOUT_MILLIS = 2000;
        private final AdvertiseCallback mAdvertiseCallback;
        private final AdvertiseData mAdvertisement;
        private final AdvertiseData mScanResponse;
        private final AdvertiseSettings mSettings;
        private final IBluetoothGatt mBluetoothGatt;
        private int mClientIf;
        private boolean mIsAdvertising = false;

        public AdvertiseCallbackWrapper(AdvertiseCallback advertiseCallback, AdvertiseData advertiseData, AdvertiseData scanResponse, AdvertiseSettings settings, IBluetoothGatt bluetoothGatt) {
            this.mAdvertiseCallback = advertiseCallback;
            this.mAdvertisement = advertiseData;
            this.mScanResponse = scanResponse;
            this.mSettings = settings;
            this.mBluetoothGatt = bluetoothGatt;
            this.mClientIf = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startRegisteration() {
            AdvertiseCallbackWrapper advertiseCallbackWrapper = this;
            synchronized (advertiseCallbackWrapper) {
                if (this.mClientIf == -1) {
                    return;
                }
                try {
                    UUID uuid = UUID.randomUUID();
                    this.mBluetoothGatt.registerClient(new ParcelUuid(uuid), this);
                    this.wait(2000L);
                }
                catch (RemoteException | InterruptedException e) {
                    Log.e(BluetoothLeAdvertiser.TAG, "Failed to start registeration", e);
                }
                if (this.mClientIf > 0 && this.mIsAdvertising) {
                    BluetoothLeAdvertiser.this.mLeAdvertisers.put(this.mAdvertiseCallback, this);
                } else if (this.mClientIf <= 0) {
                    if (this.mClientIf == 0) {
                        this.mClientIf = -1;
                    }
                    BluetoothLeAdvertiser.this.postStartFailure(this.mAdvertiseCallback, 4);
                } else {
                    try {
                        this.mBluetoothGatt.unregisterClient(this.mClientIf);
                        this.mClientIf = -1;
                    }
                    catch (RemoteException e) {
                        Log.e(BluetoothLeAdvertiser.TAG, "remote exception when unregistering", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopAdvertising() {
            AdvertiseCallbackWrapper advertiseCallbackWrapper = this;
            synchronized (advertiseCallbackWrapper) {
                try {
                    this.mBluetoothGatt.stopMultiAdvertising(this.mClientIf);
                    this.wait(2000L);
                }
                catch (RemoteException | InterruptedException e) {
                    Log.e(BluetoothLeAdvertiser.TAG, "Failed to stop advertising", e);
                }
                if (BluetoothLeAdvertiser.this.mLeAdvertisers.containsKey(this.mAdvertiseCallback)) {
                    BluetoothLeAdvertiser.this.mLeAdvertisers.remove(this.mAdvertiseCallback);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClientRegistered(int status, int clientIf) {
            Log.d(BluetoothLeAdvertiser.TAG, "onClientRegistered() - status=" + status + " clientIf=" + clientIf);
            AdvertiseCallbackWrapper advertiseCallbackWrapper = this;
            synchronized (advertiseCallbackWrapper) {
                if (status == 0) {
                    try {
                        if (this.mClientIf == -1) {
                            this.mBluetoothGatt.unregisterClient(clientIf);
                        } else {
                            this.mClientIf = clientIf;
                            this.mBluetoothGatt.startMultiAdvertising(this.mClientIf, this.mAdvertisement, this.mScanResponse, this.mSettings);
                        }
                        return;
                    }
                    catch (RemoteException e) {
                        Log.e(BluetoothLeAdvertiser.TAG, "failed to start advertising", e);
                    }
                }
                this.mClientIf = -1;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMultiAdvertiseCallback(int status, boolean isStart, AdvertiseSettings settings) {
            AdvertiseCallbackWrapper advertiseCallbackWrapper = this;
            synchronized (advertiseCallbackWrapper) {
                if (isStart) {
                    if (status == 0) {
                        this.mIsAdvertising = true;
                        BluetoothLeAdvertiser.this.postStartSuccess(this.mAdvertiseCallback, settings);
                    } else {
                        BluetoothLeAdvertiser.this.postStartFailure(this.mAdvertiseCallback, status);
                    }
                } else {
                    try {
                        this.mBluetoothGatt.unregisterClient(this.mClientIf);
                        this.mClientIf = -1;
                        this.mIsAdvertising = false;
                        BluetoothLeAdvertiser.this.mLeAdvertisers.remove(this.mAdvertiseCallback);
                    }
                    catch (RemoteException e) {
                        Log.e(BluetoothLeAdvertiser.TAG, "remote exception when unregistering", e);
                    }
                }
                this.notifyAll();
            }
        }
    }
}

