/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accounts.AccountManager;
import android.accounts.IAccountManager;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.AppOpsManager;
import android.app.ContextImpl;
import android.app.DownloadManager;
import android.app.IAlarmManager;
import android.app.JobSchedulerImpl;
import android.app.KeyguardManager;
import android.app.NotificationManager;
import android.app.SearchManager;
import android.app.StatusBarManager;
import android.app.UiModeManager;
import android.app.WallpaperManager;
import android.app.admin.DevicePolicyManager;
import android.app.job.IJobScheduler;
import android.app.job.JobScheduler;
import android.app.trust.TrustManager;
import android.app.usage.IUsageStatsManager;
import android.app.usage.NetworkStatsManager;
import android.app.usage.UsageStatsManager;
import android.appwidget.AppWidgetManager;
import android.bluetooth.BluetoothManager;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.IRestrictionsManager;
import android.content.RestrictionsManager;
import android.content.pm.LauncherApps;
import android.content.pm.ShortcutManager;
import android.content.res.Resources;
import android.hardware.ConsumerIrManager;
import android.hardware.ISerialManager;
import android.hardware.SensorManager;
import android.hardware.SerialManager;
import android.hardware.SystemSensorManager;
import android.hardware.camera2.CameraManager;
import android.hardware.display.DisplayManager;
import android.hardware.fingerprint.FingerprintManager;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.input.InputManager;
import android.hardware.location.ContextHubManager;
import android.hardware.radio.RadioManager;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.UsbManager;
import android.location.CountryDetector;
import android.location.ICountryDetector;
import android.location.ILocationManager;
import android.location.LocationManager;
import android.media.AudioManager;
import android.media.MediaRouter;
import android.media.midi.IMidiManager;
import android.media.midi.MidiManager;
import android.media.projection.MediaProjectionManager;
import android.media.session.MediaSessionManager;
import android.media.soundtrigger.SoundTriggerManager;
import android.media.tv.ITvInputManager;
import android.media.tv.TvInputManager;
import android.net.ConnectivityManager;
import android.net.ConnectivityThread;
import android.net.EthernetManager;
import android.net.IConnectivityManager;
import android.net.IEthernetManager;
import android.net.INetworkPolicyManager;
import android.net.NetworkPolicyManager;
import android.net.NetworkScoreManager;
import android.net.nsd.INsdManager;
import android.net.nsd.NsdManager;
import android.net.wifi.IRttManager;
import android.net.wifi.IWifiManager;
import android.net.wifi.IWifiScanner;
import android.net.wifi.RttManager;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiScanner;
import android.net.wifi.nan.IWifiNanManager;
import android.net.wifi.nan.WifiNanManager;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.p2p.WifiP2pManager;
import android.nfc.NfcManager;
import android.os.BatteryManager;
import android.os.DropBoxManager;
import android.os.HardwarePropertiesManager;
import android.os.IBinder;
import android.os.IHardwarePropertiesManager;
import android.os.IPowerManager;
import android.os.IRecoverySystem;
import android.os.IUserManager;
import android.os.PowerManager;
import android.os.Process;
import android.os.RecoverySystem;
import android.os.ServiceManager;
import android.os.SystemVibrator;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.Vibrator;
import android.os.health.SystemHealthManager;
import android.os.storage.StorageManager;
import android.print.IPrintManager;
import android.print.PrintManager;
import android.service.persistentdata.IPersistentDataBlockService;
import android.service.persistentdata.PersistentDataBlockManager;
import android.telecom.TelecomManager;
import android.telephony.CarrierConfigManager;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.CaptioningManager;
import android.view.inputmethod.InputMethodManager;
import android.view.textservice.TextServicesManager;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.ISoundTriggerService;
import com.android.internal.appwidget.IAppWidgetService;
import com.android.internal.os.IDropBoxManagerService;
import com.android.internal.policy.PhoneLayoutInflater;
import java.util.HashMap;

class SystemServiceRegistry {
    private static final String TAG = "SystemServiceRegistry";
    private static final HashMap<Class<?>, String> SYSTEM_SERVICE_NAMES = new HashMap();
    private static final HashMap<String, ServiceFetcher<?>> SYSTEM_SERVICE_FETCHERS = new HashMap();
    private static int sServiceCacheSize;

    private SystemServiceRegistry() {
    }

    public static Object[] createServiceCache() {
        return new Object[sServiceCacheSize];
    }

    public static Object getSystemService(ContextImpl ctx, String name) {
        ServiceFetcher<?> fetcher = SYSTEM_SERVICE_FETCHERS.get(name);
        return fetcher != null ? fetcher.getService(ctx) : null;
    }

    public static String getSystemServiceName(Class<?> serviceClass) {
        return SYSTEM_SERVICE_NAMES.get(serviceClass);
    }

    private static <T> void registerService(String serviceName, Class<T> serviceClass, ServiceFetcher<T> serviceFetcher) {
        SYSTEM_SERVICE_NAMES.put(serviceClass, serviceName);
        SYSTEM_SERVICE_FETCHERS.put(serviceName, serviceFetcher);
    }

    static /* synthetic */ int access$008() {
        return sServiceCacheSize++;
    }

    static {
        SystemServiceRegistry.registerService("accessibility", AccessibilityManager.class, new CachedServiceFetcher<AccessibilityManager>(){

            @Override
            public AccessibilityManager createService(ContextImpl ctx) {
                return AccessibilityManager.getInstance(ctx);
            }
        });
        SystemServiceRegistry.registerService("captioning", CaptioningManager.class, new CachedServiceFetcher<CaptioningManager>(){

            @Override
            public CaptioningManager createService(ContextImpl ctx) {
                return new CaptioningManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("account", AccountManager.class, new CachedServiceFetcher<AccountManager>(){

            @Override
            public AccountManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("account");
                IAccountManager service = IAccountManager.Stub.asInterface(b);
                return new AccountManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("activity", ActivityManager.class, new CachedServiceFetcher<ActivityManager>(){

            @Override
            public ActivityManager createService(ContextImpl ctx) {
                return new ActivityManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("alarm", AlarmManager.class, new CachedServiceFetcher<AlarmManager>(){

            @Override
            public AlarmManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("alarm");
                IAlarmManager service = IAlarmManager.Stub.asInterface(b);
                return new AlarmManager(service, ctx);
            }
        });
        SystemServiceRegistry.registerService("audio", AudioManager.class, new CachedServiceFetcher<AudioManager>(){

            @Override
            public AudioManager createService(ContextImpl ctx) {
                return new AudioManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("media_router", MediaRouter.class, new CachedServiceFetcher<MediaRouter>(){

            @Override
            public MediaRouter createService(ContextImpl ctx) {
                return new MediaRouter(ctx);
            }
        });
        SystemServiceRegistry.registerService("bluetooth", BluetoothManager.class, new CachedServiceFetcher<BluetoothManager>(){

            @Override
            public BluetoothManager createService(ContextImpl ctx) {
                return new BluetoothManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("hdmi_control", HdmiControlManager.class, new StaticServiceFetcher<HdmiControlManager>(){

            @Override
            public HdmiControlManager createService() {
                IBinder b = ServiceManager.getService("hdmi_control");
                return new HdmiControlManager(IHdmiControlService.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("clipboard", ClipboardManager.class, new CachedServiceFetcher<ClipboardManager>(){

            @Override
            public ClipboardManager createService(ContextImpl ctx) {
                return new ClipboardManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        SYSTEM_SERVICE_NAMES.put(android.text.ClipboardManager.class, "clipboard");
        SystemServiceRegistry.registerService("connectivity", ConnectivityManager.class, new StaticApplicationContextServiceFetcher<ConnectivityManager>(){

            @Override
            public ConnectivityManager createService(Context context) {
                IBinder b = ServiceManager.getService("connectivity");
                IConnectivityManager service = IConnectivityManager.Stub.asInterface(b);
                return new ConnectivityManager(context, service);
            }
        });
        SystemServiceRegistry.registerService("country_detector", CountryDetector.class, new StaticServiceFetcher<CountryDetector>(){

            @Override
            public CountryDetector createService() {
                IBinder b = ServiceManager.getService("country_detector");
                return new CountryDetector(ICountryDetector.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("device_policy", DevicePolicyManager.class, new CachedServiceFetcher<DevicePolicyManager>(){

            @Override
            public DevicePolicyManager createService(ContextImpl ctx) {
                return DevicePolicyManager.create(ctx);
            }
        });
        SystemServiceRegistry.registerService("download", DownloadManager.class, new CachedServiceFetcher<DownloadManager>(){

            @Override
            public DownloadManager createService(ContextImpl ctx) {
                return new DownloadManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("batterymanager", BatteryManager.class, new StaticServiceFetcher<BatteryManager>(){

            @Override
            public BatteryManager createService() {
                return new BatteryManager();
            }
        });
        SystemServiceRegistry.registerService("nfc", NfcManager.class, new CachedServiceFetcher<NfcManager>(){

            @Override
            public NfcManager createService(ContextImpl ctx) {
                return new NfcManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("dropbox", DropBoxManager.class, new CachedServiceFetcher<DropBoxManager>(){

            @Override
            public DropBoxManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("dropbox");
                IDropBoxManagerService service = IDropBoxManagerService.Stub.asInterface(b);
                if (service == null) {
                    return null;
                }
                return new DropBoxManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("input", InputManager.class, new StaticServiceFetcher<InputManager>(){

            @Override
            public InputManager createService() {
                return InputManager.getInstance();
            }
        });
        SystemServiceRegistry.registerService("display", DisplayManager.class, new CachedServiceFetcher<DisplayManager>(){

            @Override
            public DisplayManager createService(ContextImpl ctx) {
                return new DisplayManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("input_method", InputMethodManager.class, new StaticServiceFetcher<InputMethodManager>(){

            @Override
            public InputMethodManager createService() {
                return InputMethodManager.getInstance();
            }
        });
        SystemServiceRegistry.registerService("textservices", TextServicesManager.class, new StaticServiceFetcher<TextServicesManager>(){

            @Override
            public TextServicesManager createService() {
                return TextServicesManager.getInstance();
            }
        });
        SystemServiceRegistry.registerService("keyguard", KeyguardManager.class, new StaticServiceFetcher<KeyguardManager>(){

            @Override
            public KeyguardManager createService() {
                return new KeyguardManager();
            }
        });
        SystemServiceRegistry.registerService("layout_inflater", LayoutInflater.class, new CachedServiceFetcher<LayoutInflater>(){

            @Override
            public LayoutInflater createService(ContextImpl ctx) {
                return new PhoneLayoutInflater(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("location", LocationManager.class, new CachedServiceFetcher<LocationManager>(){

            @Override
            public LocationManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("location");
                return new LocationManager(ctx, ILocationManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("netpolicy", NetworkPolicyManager.class, new CachedServiceFetcher<NetworkPolicyManager>(){

            @Override
            public NetworkPolicyManager createService(ContextImpl ctx) {
                return new NetworkPolicyManager(ctx, INetworkPolicyManager.Stub.asInterface(ServiceManager.getService("netpolicy")));
            }
        });
        SystemServiceRegistry.registerService("notification", NotificationManager.class, new CachedServiceFetcher<NotificationManager>(){

            @Override
            public NotificationManager createService(ContextImpl ctx) {
                Context outerContext = ctx.getOuterContext();
                return new NotificationManager(new ContextThemeWrapper(outerContext, Resources.selectSystemTheme(0, outerContext.getApplicationInfo().targetSdkVersion, 16973835, 16973935, 16974126, 16974130)), ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("servicediscovery", NsdManager.class, new CachedServiceFetcher<NsdManager>(){

            @Override
            public NsdManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("servicediscovery");
                INsdManager service = INsdManager.Stub.asInterface(b);
                return new NsdManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("power", PowerManager.class, new CachedServiceFetcher<PowerManager>(){

            @Override
            public PowerManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("power");
                IPowerManager service = IPowerManager.Stub.asInterface(b);
                if (service == null) {
                    Log.wtf(SystemServiceRegistry.TAG, "Failed to get power manager service.");
                }
                return new PowerManager(ctx.getOuterContext(), service, ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("recovery", RecoverySystem.class, new CachedServiceFetcher<RecoverySystem>(){

            @Override
            public RecoverySystem createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("recovery");
                IRecoverySystem service = IRecoverySystem.Stub.asInterface(b);
                if (service == null) {
                    Log.wtf(SystemServiceRegistry.TAG, "Failed to get recovery service.");
                }
                return new RecoverySystem(service);
            }
        });
        SystemServiceRegistry.registerService("search", SearchManager.class, new CachedServiceFetcher<SearchManager>(){

            @Override
            public SearchManager createService(ContextImpl ctx) {
                return new SearchManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("sensor", SensorManager.class, new CachedServiceFetcher<SensorManager>(){

            @Override
            public SensorManager createService(ContextImpl ctx) {
                return new SystemSensorManager(ctx.getOuterContext(), ctx.mMainThread.getHandler().getLooper());
            }
        });
        SystemServiceRegistry.registerService("statusbar", StatusBarManager.class, new CachedServiceFetcher<StatusBarManager>(){

            @Override
            public StatusBarManager createService(ContextImpl ctx) {
                return new StatusBarManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("storage", StorageManager.class, new CachedServiceFetcher<StorageManager>(){

            @Override
            public StorageManager createService(ContextImpl ctx) {
                return new StorageManager(ctx, ctx.mMainThread.getHandler().getLooper());
            }
        });
        SystemServiceRegistry.registerService("phone", TelephonyManager.class, new CachedServiceFetcher<TelephonyManager>(){

            @Override
            public TelephonyManager createService(ContextImpl ctx) {
                return new TelephonyManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("telephony_subscription_service", SubscriptionManager.class, new CachedServiceFetcher<SubscriptionManager>(){

            @Override
            public SubscriptionManager createService(ContextImpl ctx) {
                return new SubscriptionManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("carrier_config", CarrierConfigManager.class, new CachedServiceFetcher<CarrierConfigManager>(){

            @Override
            public CarrierConfigManager createService(ContextImpl ctx) {
                return new CarrierConfigManager();
            }
        });
        SystemServiceRegistry.registerService("telecom", TelecomManager.class, new CachedServiceFetcher<TelecomManager>(){

            @Override
            public TelecomManager createService(ContextImpl ctx) {
                return new TelecomManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("uimode", UiModeManager.class, new CachedServiceFetcher<UiModeManager>(){

            @Override
            public UiModeManager createService(ContextImpl ctx) {
                return new UiModeManager();
            }
        });
        SystemServiceRegistry.registerService("usb", UsbManager.class, new CachedServiceFetcher<UsbManager>(){

            @Override
            public UsbManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("usb");
                return new UsbManager(ctx, IUsbManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("serial", SerialManager.class, new CachedServiceFetcher<SerialManager>(){

            @Override
            public SerialManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("serial");
                return new SerialManager(ctx, ISerialManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("vibrator", Vibrator.class, new CachedServiceFetcher<Vibrator>(){

            @Override
            public Vibrator createService(ContextImpl ctx) {
                return new SystemVibrator(ctx);
            }
        });
        SystemServiceRegistry.registerService("wallpaper", WallpaperManager.class, new CachedServiceFetcher<WallpaperManager>(){

            @Override
            public WallpaperManager createService(ContextImpl ctx) {
                return new WallpaperManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        SystemServiceRegistry.registerService("wifi", WifiManager.class, new CachedServiceFetcher<WifiManager>(){

            @Override
            public WifiManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("wifi");
                IWifiManager service = IWifiManager.Stub.asInterface(b);
                return new WifiManager(ctx.getOuterContext(), service, ConnectivityThread.getInstanceLooper());
            }
        });
        SystemServiceRegistry.registerService("wifip2p", WifiP2pManager.class, new StaticServiceFetcher<WifiP2pManager>(){

            @Override
            public WifiP2pManager createService() {
                IBinder b = ServiceManager.getService("wifip2p");
                IWifiP2pManager service = IWifiP2pManager.Stub.asInterface(b);
                return new WifiP2pManager(service);
            }
        });
        SystemServiceRegistry.registerService("wifinan", WifiNanManager.class, new StaticServiceFetcher<WifiNanManager>(){

            @Override
            public WifiNanManager createService() {
                IBinder b = ServiceManager.getService("wifinan");
                IWifiNanManager service = IWifiNanManager.Stub.asInterface(b);
                if (service == null) {
                    return null;
                }
                return new WifiNanManager(service);
            }
        });
        SystemServiceRegistry.registerService("wifiscanner", WifiScanner.class, new CachedServiceFetcher<WifiScanner>(){

            @Override
            public WifiScanner createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("wifiscanner");
                IWifiScanner service = IWifiScanner.Stub.asInterface(b);
                return new WifiScanner(ctx.getOuterContext(), service, ConnectivityThread.getInstanceLooper());
            }
        });
        SystemServiceRegistry.registerService("rttmanager", RttManager.class, new CachedServiceFetcher<RttManager>(){

            @Override
            public RttManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("rttmanager");
                IRttManager service = IRttManager.Stub.asInterface(b);
                return new RttManager(ctx.getOuterContext(), service, ConnectivityThread.getInstanceLooper());
            }
        });
        SystemServiceRegistry.registerService("ethernet", EthernetManager.class, new CachedServiceFetcher<EthernetManager>(){

            @Override
            public EthernetManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("ethernet");
                IEthernetManager service = IEthernetManager.Stub.asInterface(b);
                return new EthernetManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("window", WindowManager.class, new CachedServiceFetcher<WindowManager>(){

            @Override
            public WindowManager createService(ContextImpl ctx) {
                return new WindowManagerImpl(ctx);
            }
        });
        SystemServiceRegistry.registerService("user", UserManager.class, new CachedServiceFetcher<UserManager>(){

            @Override
            public UserManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("user");
                IUserManager service = IUserManager.Stub.asInterface(b);
                return new UserManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("appops", AppOpsManager.class, new CachedServiceFetcher<AppOpsManager>(){

            @Override
            public AppOpsManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("appops");
                IAppOpsService service = IAppOpsService.Stub.asInterface(b);
                return new AppOpsManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("camera", CameraManager.class, new CachedServiceFetcher<CameraManager>(){

            @Override
            public CameraManager createService(ContextImpl ctx) {
                return new CameraManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("launcherapps", LauncherApps.class, new CachedServiceFetcher<LauncherApps>(){

            @Override
            public LauncherApps createService(ContextImpl ctx) {
                return new LauncherApps(ctx);
            }
        });
        SystemServiceRegistry.registerService("restrictions", RestrictionsManager.class, new CachedServiceFetcher<RestrictionsManager>(){

            @Override
            public RestrictionsManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("restrictions");
                IRestrictionsManager service = IRestrictionsManager.Stub.asInterface(b);
                return new RestrictionsManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("print", PrintManager.class, new CachedServiceFetcher<PrintManager>(){

            @Override
            public PrintManager createService(ContextImpl ctx) {
                IBinder iBinder = ServiceManager.getService("print");
                IPrintManager service = IPrintManager.Stub.asInterface(iBinder);
                return new PrintManager(ctx.getOuterContext(), service, UserHandle.myUserId(), UserHandle.getAppId(Process.myUid()));
            }
        });
        SystemServiceRegistry.registerService("consumer_ir", ConsumerIrManager.class, new CachedServiceFetcher<ConsumerIrManager>(){

            @Override
            public ConsumerIrManager createService(ContextImpl ctx) {
                return new ConsumerIrManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("media_session", MediaSessionManager.class, new CachedServiceFetcher<MediaSessionManager>(){

            @Override
            public MediaSessionManager createService(ContextImpl ctx) {
                return new MediaSessionManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("trust", TrustManager.class, new StaticServiceFetcher<TrustManager>(){

            @Override
            public TrustManager createService() {
                IBinder b = ServiceManager.getService("trust");
                return new TrustManager(b);
            }
        });
        SystemServiceRegistry.registerService("fingerprint", FingerprintManager.class, new CachedServiceFetcher<FingerprintManager>(){

            @Override
            public FingerprintManager createService(ContextImpl ctx) {
                IBinder binder = ServiceManager.getService("fingerprint");
                IFingerprintService service = IFingerprintService.Stub.asInterface(binder);
                return new FingerprintManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("tv_input", TvInputManager.class, new StaticServiceFetcher<TvInputManager>(){

            @Override
            public TvInputManager createService() {
                IBinder iBinder = ServiceManager.getService("tv_input");
                ITvInputManager service = ITvInputManager.Stub.asInterface(iBinder);
                return new TvInputManager(service, UserHandle.myUserId());
            }
        });
        SystemServiceRegistry.registerService("network_score", NetworkScoreManager.class, new CachedServiceFetcher<NetworkScoreManager>(){

            @Override
            public NetworkScoreManager createService(ContextImpl ctx) {
                return new NetworkScoreManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("usagestats", UsageStatsManager.class, new CachedServiceFetcher<UsageStatsManager>(){

            @Override
            public UsageStatsManager createService(ContextImpl ctx) {
                IBinder iBinder = ServiceManager.getService("usagestats");
                IUsageStatsManager service = IUsageStatsManager.Stub.asInterface(iBinder);
                return new UsageStatsManager(ctx.getOuterContext(), service);
            }
        });
        SystemServiceRegistry.registerService("netstats", NetworkStatsManager.class, new CachedServiceFetcher<NetworkStatsManager>(){

            @Override
            public NetworkStatsManager createService(ContextImpl ctx) {
                return new NetworkStatsManager(ctx.getOuterContext());
            }
        });
        SystemServiceRegistry.registerService("jobscheduler", JobScheduler.class, new StaticServiceFetcher<JobScheduler>(){

            @Override
            public JobScheduler createService() {
                IBinder b = ServiceManager.getService("jobscheduler");
                return new JobSchedulerImpl(IJobScheduler.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("persistent_data_block", PersistentDataBlockManager.class, new StaticServiceFetcher<PersistentDataBlockManager>(){

            @Override
            public PersistentDataBlockManager createService() {
                IBinder b = ServiceManager.getService("persistent_data_block");
                IPersistentDataBlockService persistentDataBlockService = IPersistentDataBlockService.Stub.asInterface(b);
                if (persistentDataBlockService != null) {
                    return new PersistentDataBlockManager(persistentDataBlockService);
                }
                return null;
            }
        });
        SystemServiceRegistry.registerService("media_projection", MediaProjectionManager.class, new CachedServiceFetcher<MediaProjectionManager>(){

            @Override
            public MediaProjectionManager createService(ContextImpl ctx) {
                return new MediaProjectionManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("appwidget", AppWidgetManager.class, new CachedServiceFetcher<AppWidgetManager>(){

            @Override
            public AppWidgetManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("appwidget");
                return new AppWidgetManager(ctx, IAppWidgetService.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("midi", MidiManager.class, new CachedServiceFetcher<MidiManager>(){

            @Override
            public MidiManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("midi");
                if (b == null) {
                    return null;
                }
                return new MidiManager(IMidiManager.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("radio", RadioManager.class, new CachedServiceFetcher<RadioManager>(){

            @Override
            public RadioManager createService(ContextImpl ctx) {
                return new RadioManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("hardware_properties", HardwarePropertiesManager.class, new CachedServiceFetcher<HardwarePropertiesManager>(){

            @Override
            public HardwarePropertiesManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("hardware_properties");
                IHardwarePropertiesManager service = IHardwarePropertiesManager.Stub.asInterface(b);
                if (service == null) {
                    Log.wtf(SystemServiceRegistry.TAG, "Failed to get hardwareproperties service.");
                    return null;
                }
                return new HardwarePropertiesManager(ctx, service);
            }
        });
        SystemServiceRegistry.registerService("soundtrigger", SoundTriggerManager.class, new CachedServiceFetcher<SoundTriggerManager>(){

            @Override
            public SoundTriggerManager createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("soundtrigger");
                return new SoundTriggerManager(ctx, ISoundTriggerService.Stub.asInterface(b));
            }
        });
        SystemServiceRegistry.registerService("shortcut", ShortcutManager.class, new CachedServiceFetcher<ShortcutManager>(){

            @Override
            public ShortcutManager createService(ContextImpl ctx) {
                return new ShortcutManager(ctx);
            }
        });
        SystemServiceRegistry.registerService("systemhealth", SystemHealthManager.class, new CachedServiceFetcher<SystemHealthManager>(){

            @Override
            public SystemHealthManager createService(ContextImpl ctx) {
                return new SystemHealthManager();
            }
        });
        SystemServiceRegistry.registerService("contexthub", ContextHubManager.class, new CachedServiceFetcher<ContextHubManager>(){

            @Override
            public ContextHubManager createService(ContextImpl ctx) {
                return new ContextHubManager(ctx.getOuterContext(), ctx.mMainThread.getHandler().getLooper());
            }
        });
    }

    static abstract class StaticApplicationContextServiceFetcher<T>
    implements ServiceFetcher<T> {
        private T mCachedInstance;

        StaticApplicationContextServiceFetcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getService(ContextImpl ctx) {
            StaticApplicationContextServiceFetcher staticApplicationContextServiceFetcher = this;
            synchronized (staticApplicationContextServiceFetcher) {
                if (this.mCachedInstance == null) {
                    Context appContext = ctx.getApplicationContext();
                    this.mCachedInstance = this.createService(appContext != null ? appContext : ctx);
                }
                return this.mCachedInstance;
            }
        }

        public abstract T createService(Context var1);
    }

    static abstract class StaticServiceFetcher<T>
    implements ServiceFetcher<T> {
        private T mCachedInstance;

        StaticServiceFetcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getService(ContextImpl unused) {
            StaticServiceFetcher staticServiceFetcher = this;
            synchronized (staticServiceFetcher) {
                if (this.mCachedInstance == null) {
                    this.mCachedInstance = this.createService();
                }
                return this.mCachedInstance;
            }
        }

        public abstract T createService();
    }

    static abstract class CachedServiceFetcher<T>
    implements ServiceFetcher<T> {
        private final int mCacheIndex = SystemServiceRegistry.access$008();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getService(ContextImpl ctx) {
            Object[] cache;
            Object[] objectArray = cache = ctx.mServiceCache;
            synchronized (cache) {
                Object service = cache[this.mCacheIndex];
                if (service == null) {
                    cache[this.mCacheIndex] = service = this.createService(ctx);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return (T)service;
            }
        }

        public abstract T createService(ContextImpl var1);
    }

    static interface ServiceFetcher<T> {
        public T getService(ContextImpl var1);
    }
}

