/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.TimeInterpolator;
import android.content.res.ConstantState;
import java.util.ArrayList;

public abstract class Animator
implements Cloneable {
    public static final long DURATION_INFINITE = -1L;
    ArrayList<AnimatorListener> mListeners = null;
    ArrayList<AnimatorPauseListener> mPauseListeners = null;
    boolean mPaused = false;
    int mChangingConfigurations = 0;
    private AnimatorConstantState mConstantState;

    public void start() {
    }

    public void cancel() {
    }

    public void end() {
    }

    public void pause() {
        if (this.isStarted() && !this.mPaused) {
            this.mPaused = true;
            if (this.mPauseListeners != null) {
                ArrayList tmpListeners = (ArrayList)this.mPauseListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((AnimatorPauseListener)tmpListeners.get(i)).onAnimationPause(this);
                }
            }
        }
    }

    public void resume() {
        if (this.mPaused) {
            this.mPaused = false;
            if (this.mPauseListeners != null) {
                ArrayList tmpListeners = (ArrayList)this.mPauseListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((AnimatorPauseListener)tmpListeners.get(i)).onAnimationResume(this);
                }
            }
        }
    }

    public boolean isPaused() {
        return this.mPaused;
    }

    public abstract long getStartDelay();

    public abstract void setStartDelay(long var1);

    public abstract Animator setDuration(long var1);

    public abstract long getDuration();

    public long getTotalDuration() {
        long duration = this.getDuration();
        if (duration == -1L) {
            return -1L;
        }
        return this.getStartDelay() + duration;
    }

    public abstract void setInterpolator(TimeInterpolator var1);

    public TimeInterpolator getInterpolator() {
        return null;
    }

    public abstract boolean isRunning();

    public boolean isStarted() {
        return this.isRunning();
    }

    public void addListener(AnimatorListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(listener);
    }

    public void removeListener(AnimatorListener listener) {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener);
        if (this.mListeners.size() == 0) {
            this.mListeners = null;
        }
    }

    public ArrayList<AnimatorListener> getListeners() {
        return this.mListeners;
    }

    public void addPauseListener(AnimatorPauseListener listener) {
        if (this.mPauseListeners == null) {
            this.mPauseListeners = new ArrayList();
        }
        this.mPauseListeners.add(listener);
    }

    public void removePauseListener(AnimatorPauseListener listener) {
        if (this.mPauseListeners == null) {
            return;
        }
        this.mPauseListeners.remove(listener);
        if (this.mPauseListeners.size() == 0) {
            this.mPauseListeners = null;
        }
    }

    public void removeAllListeners() {
        if (this.mListeners != null) {
            this.mListeners.clear();
            this.mListeners = null;
        }
        if (this.mPauseListeners != null) {
            this.mPauseListeners.clear();
            this.mPauseListeners = null;
        }
    }

    public int getChangingConfigurations() {
        return this.mChangingConfigurations;
    }

    public void setChangingConfigurations(int configs) {
        this.mChangingConfigurations = configs;
    }

    public void appendChangingConfigurations(int configs) {
        this.mChangingConfigurations |= configs;
    }

    public ConstantState<Animator> createConstantState() {
        return new AnimatorConstantState(this);
    }

    public Animator clone() {
        try {
            Animator anim2 = (Animator)super.clone();
            if (this.mListeners != null) {
                anim2.mListeners = new ArrayList<AnimatorListener>(this.mListeners);
            }
            if (this.mPauseListeners != null) {
                anim2.mPauseListeners = new ArrayList<AnimatorPauseListener>(this.mPauseListeners);
            }
            return anim2;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public void setupStartValues() {
    }

    public void setupEndValues() {
    }

    public void setTarget(Object target) {
    }

    public boolean canReverse() {
        return false;
    }

    public void reverse() {
        throw new IllegalStateException("Reverse is not supported");
    }

    public void setAllowRunningAsynchronously(boolean mayRunAsync) {
    }

    private static class AnimatorConstantState
    extends ConstantState<Animator> {
        final Animator mAnimator;
        int mChangingConf;

        public AnimatorConstantState(Animator animator2) {
            this.mAnimator = animator2;
            this.mAnimator.mConstantState = this;
            this.mChangingConf = this.mAnimator.getChangingConfigurations();
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConf;
        }

        @Override
        public Animator newInstance() {
            Animator clone = this.mAnimator.clone();
            clone.mConstantState = this;
            return clone;
        }
    }

    public static interface AnimatorPauseListener {
        public void onAnimationPause(Animator var1);

        public void onAnimationResume(Animator var1);
    }

    public static interface AnimatorListener {
        public void onAnimationStart(Animator var1);

        public void onAnimationEnd(Animator var1);

        public void onAnimationCancel(Animator var1);

        public void onAnimationRepeat(Animator var1);
    }
}

