/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.interaction;

import android.support.constraint.solver.widgets.Animator;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import com.android.tools.sherpa.drawing.SceneDraw;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.drawing.decorator.WidgetDecorator;
import com.android.tools.sherpa.interaction.SnapCandidate;
import com.android.tools.sherpa.interaction.SnapPlacement;
import com.android.tools.sherpa.interaction.WidgetInteractionTargets;
import com.android.tools.sherpa.structure.Selection;
import com.android.tools.sherpa.structure.WidgetCompanion;
import com.android.tools.sherpa.structure.WidgetsScene;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

public class WidgetMotion {
    private static final int SLOPE = 4;
    private final WidgetsScene mWidgetsScene;
    private final Selection mSelection;
    private ArrayList<SnapCandidate> mSnapCandidates = new ArrayList();
    private ArrayList<SnapCandidate> mSimilarMargins = new ArrayList();
    private boolean mShowDecorations = true;
    private static final int GRID_SPACING = 8;
    private SceneDraw mSceneDraw;
    private Point candidatePoint = new Point();

    public WidgetMotion(WidgetsScene widgetsScene, Selection selection) {
        this.mWidgetsScene = widgetsScene;
        this.mSelection = selection;
    }

    public int dragWidget(Point startPoint, Selection.Element widget, int x, int y, boolean snap, boolean isShiftDown, ViewTransform transform) {
        int directionLockedStatus = 0;
        if (widget == null) {
            return directionLockedStatus;
        }
        Animator.setAnimationEnabled(false);
        int dX = startPoint.x - widget.origin.x;
        int dY = startPoint.y - widget.origin.y;
        int dragX = Math.abs(widget.widget.getDrawX() - widget.origin.x);
        int dragY = Math.abs(widget.widget.getDrawY() - widget.origin.y);
        if (dragX > 4 || dragY > 4) {
            this.mShowDecorations = false;
        }
        if (isShiftDown) {
            if (widget.directionLocked == 0) {
                if (dragX > 4 || dragY > 4) {
                    if (dragX > dragY) {
                        widget.directionLocked = 1;
                        directionLockedStatus = 1;
                    } else {
                        widget.directionLocked = 2;
                        directionLockedStatus = 2;
                    }
                } else {
                    snap = false;
                }
            }
        } else {
            widget.directionLocked = 0;
        }
        this.candidatePoint.setLocation(x - dX, y - dY);
        ConstraintWidget base = widget.widget.getParent();
        if (base != null) {
            if (this.candidatePoint.x < base.getDrawX()) {
                this.candidatePoint.x = base.getDrawX();
            } else if (this.candidatePoint.x > base.getDrawRight()) {
                this.candidatePoint.x = base.getDrawRight();
            }
            if (this.candidatePoint.y < base.getDrawY()) {
                this.candidatePoint.y = base.getDrawY();
            } else if (this.candidatePoint.y > base.getDrawBottom()) {
                this.candidatePoint.y = base.getDrawBottom();
            }
        }
        this.mSnapCandidates.clear();
        ArrayList<ConstraintWidget> widgetsToCheck = new ArrayList<ConstraintWidget>();
        for (ConstraintWidget w : this.mWidgetsScene.getWidgets()) {
            if (w.hasAncestor(widget.widget) || this.mSelection.contains(w)) continue;
            widgetsToCheck.add(w);
        }
        if (widget.directionLocked == 1) {
            this.candidatePoint.y = widget.origin.y;
        } else if (widget.directionLocked == 2) {
            this.candidatePoint.x = widget.origin.x;
        }
        if (snap) {
            SnapPlacement.snapWidget(widgetsToCheck, widget.widget, this.candidatePoint, false, this.mSnapCandidates, transform);
        }
        WidgetCompanion widgetCompanion = (WidgetCompanion)widget.widget.getCompanionWidget();
        WidgetInteractionTargets widgetInteraction = widgetCompanion.getWidgetInteractionTargets();
        this.snapBias(widget.widget, this.candidatePoint);
        widget.widget.setDrawOrigin(this.candidatePoint.x, this.candidatePoint.y);
        widget.widget.forceUpdateDrawPosition();
        widgetInteraction.updatePosition(transform);
        this.mSimilarMargins.clear();
        for (SnapCandidate candidate : this.mSnapCandidates) {
            if (candidate.margin == 0) continue;
            this.mSimilarMargins.add(candidate);
        }
        for (SnapCandidate candidate : this.mSnapCandidates) {
            SnapPlacement.gatherMargins(this.mWidgetsScene.getWidgets(), this.mSimilarMargins, candidate.margin, candidate.source.isVerticalAnchor());
        }
        return directionLockedStatus;
    }

    private void snapBias(ConstraintWidget widget, Point candidatePoint) {
        WidgetCompanion widgetCompanion = (WidgetCompanion)widget.getCompanionWidget();
        int currentStyle = 0;
        if (this.mSceneDraw != null) {
            currentStyle = this.mSceneDraw.getCurrentStyle();
        }
        WidgetDecorator decorator = widgetCompanion.getWidgetDecorator(currentStyle);
        ConstraintAnchor leftAnchor = widget.getAnchor(ConstraintAnchor.Type.LEFT);
        ConstraintAnchor rightAnchor = widget.getAnchor(ConstraintAnchor.Type.RIGHT);
        if (leftAnchor != null && rightAnchor != null && leftAnchor.isConnected() && rightAnchor.isConnected() && leftAnchor.getTarget() != rightAnchor.getTarget()) {
            int begin = WidgetInteractionTargets.constraintHandle(leftAnchor.getTarget()).getDrawX();
            int end = WidgetInteractionTargets.constraintHandle(rightAnchor.getTarget()).getDrawX();
            int width = widget.getDrawWidth();
            int delta = candidatePoint.x - begin;
            float percent = (float)delta / (float)(end - begin - width);
            percent = Math.max(0.0f, Math.min(1.0f, percent));
            percent = WidgetMotion.snapPercent(percent);
            widget.setHorizontalBiasPercent(percent);
            decorator.updateBias();
        }
        ConstraintAnchor topAnchor = widget.getAnchor(ConstraintAnchor.Type.TOP);
        ConstraintAnchor bottomAnchor = widget.getAnchor(ConstraintAnchor.Type.BOTTOM);
        if (topAnchor != null && bottomAnchor != null && topAnchor.isConnected() && bottomAnchor.isConnected() && topAnchor.getTarget() != bottomAnchor.getTarget()) {
            int begin = WidgetInteractionTargets.constraintHandle(topAnchor.getTarget()).getDrawY();
            int end = WidgetInteractionTargets.constraintHandle(bottomAnchor.getTarget()).getDrawY();
            int height = widget.getDrawHeight();
            int delta = candidatePoint.y - begin;
            float percent = (float)delta / (float)(end - begin - height);
            percent = Math.max(0.0f, Math.min(1.0f, percent));
            percent = WidgetMotion.snapPercent(percent);
            widget.setVerticalBiasPercent(percent);
            decorator.updateBias();
        }
    }

    private static float snapPercent(float percent) {
        int value = (int)(percent * 100.0f);
        int slope = 2;
        if (Math.abs(value - 25) <= slope) {
            value = 25;
        }
        if (Math.abs(value - 33) <= slope) {
            value = 33;
        }
        if (Math.abs(value - 50) <= slope) {
            value = 50;
        }
        if (Math.abs(value - 66) <= slope) {
            value = 66;
        }
        if (Math.abs(value - 75) <= slope) {
            value = 75;
        }
        return (float)value / 100.0f;
    }

    public void mouseReleased() {
        this.mShowDecorations = true;
        this.mSnapCandidates.clear();
        this.mSimilarMargins.clear();
    }

    public void setSceneDraw(SceneDraw sceneDraw) {
        this.mSceneDraw = sceneDraw;
    }

    public boolean needToShowDecorations() {
        return this.mShowDecorations;
    }

    public ArrayList<SnapCandidate> getSimilarMargins() {
        return this.mSimilarMargins;
    }

    public ArrayList<SnapCandidate> getSnapCandidates() {
        return this.mSnapCandidates;
    }

    public static boolean isArrowKey(KeyEvent e) {
        int code = e.getKeyCode();
        return code >= 37 && code <= 40;
    }

    public static Direction directionForArrowKey(KeyEvent e) {
        int index = Math.max(0, Math.min(e.getKeyCode(), 40) - 37);
        return Direction.values()[index];
    }

    public void moveWidget(ConstraintWidget widget, Direction direction, boolean snapToGrid) {
        if (widget == null) {
            return;
        }
        int x = widget.getDrawX();
        int y = widget.getDrawY();
        int xOffset = 0;
        int yOffset = 0;
        switch (direction) {
            case LEFT: {
                xOffset = -1;
                break;
            }
            case UP: {
                yOffset = -1;
                break;
            }
            case RIGHT: {
                xOffset = 1;
                break;
            }
            case DOWN: {
                yOffset = 1;
            }
        }
        if (snapToGrid) {
            xOffset *= 8;
            yOffset *= 8;
        }
        widget.setDrawOrigin(x + xOffset, y + yOffset);
    }

    private static enum Direction {
        LEFT,
        UP,
        RIGHT,
        DOWN;

    }
}

