/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.interaction;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.Guideline;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.interaction.ConstraintHandle;
import com.android.tools.sherpa.interaction.SnapCandidate;
import com.android.tools.sherpa.interaction.WidgetInteractionTargets;
import com.android.tools.sherpa.structure.WidgetCompanion;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;

public class SnapPlacement {
    private static final double MAX_CONNECTION_DISTANCE = 100.0;
    private static final double MAX_SNAP_MARGIN_DISTANCE = 80.0;
    private static final boolean ALLOWS_ALL_SNAP_MARGIN = true;
    private static final int SNAP_MARGIN_INCREMENT = 8;
    private static final int SNAP_MARGIN_MAX = 56;
    private static final int CONNECTION_SLOPE = 4;
    static final int DEFAULT_MARGIN = 16;

    public static void snapWidget(Collection<ConstraintWidget> widgets, ConstraintWidget widget, Point candidatePoint, boolean useGridSnap, ArrayList<SnapCandidate> snapCandidates, ViewTransform transform) {
        if (widget instanceof Guideline) {
            return;
        }
        ConstraintAnchor left = widget.getAnchor(ConstraintAnchor.Type.LEFT);
        ConstraintAnchor right = widget.getAnchor(ConstraintAnchor.Type.RIGHT);
        if (!left.isConnected() || !right.isConnected()) {
            widget.setDrawX(candidatePoint.x);
            WidgetCompanion widgetCompanion = (WidgetCompanion)widget.getCompanionWidget();
            WidgetInteractionTargets widgetInteraction = widgetCompanion.getWidgetInteractionTargets();
            widgetInteraction.updatePosition(transform);
            if (!SnapPlacement.checkHorizontalMarginsSnap(snapCandidates, widget, candidatePoint, 16) && !SnapPlacement.snapExistingHorizontalMargin(widget, candidatePoint)) {
                SnapCandidate candidate = new SnapCandidate();
                SnapPlacement.findSnap(widgets, widget, candidate, true);
                if (candidate.target == null || candidate.target.getType() == ConstraintAnchor.Type.CENTER_X || candidate.target.getType() == ConstraintAnchor.Type.CENTER) {
                    for (int i = 8; i <= 56; i += 8) {
                        SnapPlacement.findSnapMargin(widgets, widget, candidate, false, ConstraintAnchor.Type.LEFT, ConstraintAnchor.Type.RIGHT, i, 4);
                        SnapPlacement.findSnapMargin(widgets, widget, candidate, false, ConstraintAnchor.Type.RIGHT, ConstraintAnchor.Type.LEFT, -i, 4);
                    }
                }
                if (!SnapPlacement.snapToHorizontalAnchor(candidatePoint, widget, candidate)) {
                    if (useGridSnap) {
                        SnapPlacement.snapHorizontalGrid(candidatePoint);
                    }
                } else {
                    snapCandidates.add(candidate);
                }
            }
        }
        ConstraintAnchor top = widget.getAnchor(ConstraintAnchor.Type.TOP);
        ConstraintAnchor bottom = widget.getAnchor(ConstraintAnchor.Type.BOTTOM);
        ConstraintAnchor baseline = widget.getAnchor(ConstraintAnchor.Type.BASELINE);
        if (!(baseline.isConnected() || top.isConnected() && bottom.isConnected())) {
            widget.setDrawY(candidatePoint.y);
            WidgetCompanion widgetCompanion = (WidgetCompanion)widget.getCompanionWidget();
            WidgetInteractionTargets widgetInteraction = widgetCompanion.getWidgetInteractionTargets();
            widgetInteraction.updatePosition(transform);
            if (!SnapPlacement.checkVerticalMarginsSnap(snapCandidates, widget, candidatePoint, 16) && !SnapPlacement.snapExistingVerticalMargin(widget, candidatePoint)) {
                SnapCandidate candidate = new SnapCandidate();
                SnapPlacement.findSnap(widgets, widget, candidate, false);
                if (candidate.target == null || candidate.target.getType() == ConstraintAnchor.Type.CENTER_Y || candidate.target.getType() == ConstraintAnchor.Type.CENTER) {
                    for (int i = 8; i <= 56; i += 8) {
                        SnapPlacement.findSnapMargin(widgets, widget, candidate, true, ConstraintAnchor.Type.TOP, ConstraintAnchor.Type.BOTTOM, i, 4);
                        SnapPlacement.findSnapMargin(widgets, widget, candidate, true, ConstraintAnchor.Type.BOTTOM, ConstraintAnchor.Type.TOP, -i, 4);
                    }
                }
                if (!SnapPlacement.snapToVerticalAnchor(candidatePoint, widget, candidate)) {
                    if (useGridSnap) {
                        SnapPlacement.snapVerticalGrid(candidatePoint);
                    }
                } else {
                    snapCandidates.add(candidate);
                }
            }
        }
    }

    public static void snapAnchor(Collection<ConstraintWidget> widgets, ConstraintWidget widget, ConstraintAnchor anchor, SnapCandidate candidate) {
        if (widget.getParent() != null) {
            if (!anchor.isVerticalAnchor()) {
                SnapPlacement.checkHorizontalParentMarginSnap(anchor, ConstraintAnchor.Type.RIGHT, -16, candidate);
                SnapPlacement.checkHorizontalParentMarginSnap(anchor, ConstraintAnchor.Type.LEFT, 16, candidate);
            } else {
                SnapPlacement.checkVerticalParentMarginSnap(anchor, ConstraintAnchor.Type.BOTTOM, -16, candidate);
                SnapPlacement.checkVerticalParentMarginSnap(anchor, ConstraintAnchor.Type.TOP, 16, candidate);
            }
        }
        for (ConstraintWidget w : widgets) {
            if (w == widget) continue;
            ArrayList<ConstraintAnchor> anchorsTarget = w.getAnchors();
            for (ConstraintAnchor at : anchorsTarget) {
                SnapPlacement.snapCheck(anchor, at, candidate, 4);
            }
        }
    }

    public static void gatherMargins(Collection<ConstraintWidget> widgets, ArrayList<SnapCandidate> margins, int margin, boolean isVertical) {
        if ((margin = Math.abs(margin)) == 0) {
            return;
        }
        ArrayList<SnapCandidate> foundMargins = new ArrayList<SnapCandidate>();
        for (ConstraintWidget w1 : widgets) {
            for (ConstraintAnchor a1 : w1.getAnchors()) {
                if (!a1.isSideAnchor() || a1.isVerticalAnchor() != isVertical) continue;
                for (ConstraintWidget w2 : widgets) {
                    for (ConstraintAnchor a2 : w2.getAnchors()) {
                        int currentMargin;
                        if (!a2.isSideAnchor() || !a2.isSimilarDimensionConnection(a1)) continue;
                        ConstraintHandle h1 = WidgetInteractionTargets.constraintHandle(a1);
                        ConstraintHandle h2 = WidgetInteractionTargets.constraintHandle(a2);
                        if (h1 == null || h2 == null || Math.abs(currentMargin = h1.getStraightDistanceFrom(h2)) != margin) continue;
                        SnapCandidate candidate = new SnapCandidate();
                        candidate.source = a1;
                        candidate.target = a2;
                        candidate.margin = currentMargin;
                        foundMargins.add(candidate);
                    }
                }
            }
        }
        for (SnapCandidate c1 : foundMargins) {
            boolean insert = true;
            for (SnapCandidate c2 : margins) {
                if (Math.abs(c1.margin) == Math.abs(c2.margin) && (c2.source == c1.target && c2.target == c1.source || c2.source == c1.source && c2.target == c1.target)) {
                    insert = false;
                    break;
                }
                if (!c1.source.isSimilarDimensionConnection(c2.source) || c1.margin != c2.margin) continue;
                ConstraintHandle sourceHandle1 = WidgetInteractionTargets.constraintHandle(c1.source);
                ConstraintHandle targetHandle1 = WidgetInteractionTargets.constraintHandle(c1.target);
                ConstraintHandle sourceHandle2 = WidgetInteractionTargets.constraintHandle(c2.source);
                ConstraintHandle targetHandle2 = WidgetInteractionTargets.constraintHandle(c2.target);
                if (c1.source.isVerticalAnchor()) {
                    if (Math.min(sourceHandle1.getDrawY(), targetHandle1.getDrawY()) != Math.min(sourceHandle2.getDrawY(), targetHandle2.getDrawY())) continue;
                    insert = false;
                    break;
                }
                if (Math.min(sourceHandle1.getDrawX(), targetHandle1.getDrawX()) != Math.min(sourceHandle2.getDrawX(), targetHandle2.getDrawX())) continue;
                insert = false;
                break;
            }
            if (!insert) continue;
            margins.add(c1);
        }
    }

    private static SnapCandidate createSnapCandidate(ConstraintWidget widget, ConstraintAnchor.Type type, int x, int y) {
        SnapCandidate candidate = new SnapCandidate();
        candidate.source = widget.getAnchor(type);
        ConstraintWidget owner = widget.getParent();
        ConstraintAnchor anchor = new ConstraintAnchor(owner, type);
        candidate.x = x;
        candidate.y = y;
        candidate.target = anchor;
        return candidate;
    }

    private static boolean checkHorizontalMarginsSnap(ArrayList<SnapCandidate> snapCandidates, ConstraintWidget widget, Point candidatePoint, int margin) {
        if (widget.getParent() == null) {
            return false;
        }
        int parentX1 = widget.getParent().getDrawX() + margin;
        int parentX2 = widget.getParent().getDrawRight() - margin;
        if (Math.abs(widget.getDrawX() - parentX1) < 4) {
            candidatePoint.x = parentX1;
            SnapCandidate candidate = SnapPlacement.createSnapCandidate(widget, ConstraintAnchor.Type.LEFT, parentX1, 0);
            candidate.padding = margin;
            snapCandidates.add(candidate);
            return true;
        }
        if (Math.abs(widget.getDrawX() + widget.getDrawWidth() - parentX2) < 4) {
            candidatePoint.x = parentX2 - widget.getDrawWidth();
            SnapCandidate candidate = SnapPlacement.createSnapCandidate(widget, ConstraintAnchor.Type.RIGHT, parentX2, 0);
            candidate.padding = margin;
            snapCandidates.add(candidate);
            return true;
        }
        return false;
    }

    private static boolean checkVerticalMarginsSnap(ArrayList<SnapCandidate> snapCandidates, ConstraintWidget widget, Point candidatePoint, int margin) {
        if (widget.getParent() == null) {
            return false;
        }
        int parentY1 = widget.getParent().getDrawY() + margin;
        int parentY2 = widget.getParent().getDrawBottom() - margin;
        if (Math.abs(widget.getDrawY() - parentY1) < 4) {
            candidatePoint.y = parentY1;
            SnapCandidate candidate = SnapPlacement.createSnapCandidate(widget, ConstraintAnchor.Type.TOP, 0, parentY1);
            candidate.padding = margin;
            snapCandidates.add(candidate);
            return true;
        }
        if (Math.abs(widget.getDrawY() + widget.getHeight() - parentY2) < 4) {
            candidatePoint.y = parentY2 - widget.getHeight();
            SnapCandidate candidate = SnapPlacement.createSnapCandidate(widget, ConstraintAnchor.Type.BOTTOM, 0, parentY2);
            candidate.padding = margin;
            snapCandidates.add(candidate);
            return true;
        }
        return false;
    }

    private static void checkHorizontalParentMarginSnap(ConstraintAnchor anchor, ConstraintAnchor.Type type, int margin, SnapCandidate candidate) {
        ConstraintWidget widget = anchor.getOwner();
        if (widget.getParent() == null) {
            return;
        }
        ConstraintAnchor targetParent = widget.getParent().getAnchor(type);
        ConstraintHandle targetParentHandle = WidgetInteractionTargets.constraintHandle(targetParent);
        ConstraintHandle anchorHandle = WidgetInteractionTargets.constraintHandle(anchor);
        ConstraintAnchor target = new ConstraintAnchor(widget.getParent(), type);
        int tx = targetParentHandle.getDrawX() + margin;
        int ty = targetParentHandle.getDrawY();
        int distance = Math.abs(anchorHandle.getDrawX() - tx);
        if (distance <= 4) {
            candidate.distance = distance;
            candidate.target = target;
            candidate.source = anchor;
            candidate.x = tx;
            candidate.y = ty;
        }
    }

    private static void checkVerticalParentMarginSnap(ConstraintAnchor anchor, ConstraintAnchor.Type type, int margin, SnapCandidate candidate) {
        ConstraintWidget widget = anchor.getOwner();
        if (widget.getParent() == null) {
            return;
        }
        ConstraintAnchor targetParent = widget.getParent().getAnchor(type);
        ConstraintHandle targetParentHandle = WidgetInteractionTargets.constraintHandle(targetParent);
        ConstraintHandle anchorHandle = WidgetInteractionTargets.constraintHandle(anchor);
        ConstraintAnchor target = new ConstraintAnchor(widget.getParent(), type);
        int tx = targetParentHandle.getDrawX();
        int ty = targetParentHandle.getDrawY() + margin;
        int distance = Math.abs(anchorHandle.getDrawY() - ty);
        if (distance <= 4) {
            candidate.distance = distance;
            candidate.target = target;
            candidate.source = anchor;
            candidate.x = tx;
            candidate.y = ty;
        }
    }

    private static void findSnap(Collection<ConstraintWidget> widgets, ConstraintWidget widget, SnapCandidate candidate, boolean checkHorizontal) {
        ArrayList<ConstraintAnchor> anchorsSource = widget.getAnchors();
        for (ConstraintWidget w : widgets) {
            if (w == widget) continue;
            ArrayList<ConstraintAnchor> anchorsTarget = w.getAnchors();
            for (ConstraintAnchor as : anchorsSource) {
                if (checkHorizontal && as.isVerticalAnchor() || !checkHorizontal && !as.isVerticalAnchor()) continue;
                for (ConstraintAnchor at : anchorsTarget) {
                    SnapPlacement.snapCheck(as, at, candidate, 4);
                }
            }
        }
    }

    private static void findSnapMargin(Collection<ConstraintWidget> widgets, ConstraintWidget widget, SnapCandidate candidate, boolean isVertical, ConstraintAnchor.Type sourceAnchor, ConstraintAnchor.Type targetAnchor, int margin, int slope) {
        if (widget instanceof Guideline) {
            return;
        }
        ConstraintAnchor source = widget.getAnchor(sourceAnchor);
        for (ConstraintWidget w : widgets) {
            ConstraintAnchor target;
            if (w == widget || (target = w.getAnchor(targetAnchor)) == null) continue;
            ConstraintHandle sourceHandle = WidgetInteractionTargets.constraintHandle(source);
            ConstraintHandle targetHandle = WidgetInteractionTargets.constraintHandle(target);
            if (sourceHandle == null || targetHandle == null) continue;
            int anchorDistance = sourceHandle.getDrawX() - targetHandle.getDrawX() - margin;
            if (isVertical) {
                anchorDistance = sourceHandle.getDrawY() - targetHandle.getDrawY() - margin;
            }
            if (anchorDistance < 0) continue;
            int minDistance = sourceHandle.getDistanceFrom(target.getOwner());
            double distance = Math.sqrt(anchorDistance * anchorDistance + minDistance * minDistance);
            if (target.getOwner() instanceof Guideline) {
                distance = Math.sqrt(anchorDistance * anchorDistance);
            }
            if (anchorDistance >= slope || !(distance <= candidate.distance) || candidate.target != null && candidate.margin <= margin && candidate.target.getType() != ConstraintAnchor.Type.CENTER_X && candidate.target.getType() != ConstraintAnchor.Type.CENTER && candidate.target.getType() != ConstraintAnchor.Type.CENTER_Y) continue;
            candidate.distance = distance;
            candidate.target = target;
            candidate.source = source;
            candidate.margin = margin;
        }
    }

    private static void snapCheck(ConstraintAnchor source, ConstraintAnchor target, SnapCandidate candidate, int slope) {
        boolean targetBelongsToParent;
        if (!target.isSnapCompatibleWith(source) || target.getOwner() == source.getOwner()) {
            return;
        }
        ConstraintHandle handleSource = WidgetInteractionTargets.constraintHandle(source);
        ConstraintHandle handleTarget = WidgetInteractionTargets.constraintHandle(target);
        int anchorDistance = handleSource.getStraightDistanceFrom(handleTarget);
        int minDistance = handleSource.getDistanceFrom(target.getOwner());
        if (target.getOwner() instanceof Guideline) {
            minDistance = 0;
        }
        double distance = Math.sqrt(anchorDistance * anchorDistance + minDistance * minDistance);
        boolean bl = targetBelongsToParent = source.getOwner().getParent() == target.getOwner();
        if (anchorDistance < slope && distance <= candidate.distance && (targetBelongsToParent || distance < 100.0)) {
            if (candidate.target != null) {
                boolean currentTargetBelongsToParent;
                boolean bl2 = currentTargetBelongsToParent = source.getOwner().getParent() == candidate.target.getOwner();
                if (currentTargetBelongsToParent) {
                    return;
                }
                if (candidate.distance == distance && !targetBelongsToParent && candidate.target.getSnapPriorityLevel() > target.getSnapPriorityLevel()) {
                    return;
                }
            }
            candidate.distance = distance;
            candidate.target = target;
            candidate.source = source;
        }
    }

    private static boolean snapToHorizontalAnchor(Point candidatePoint, ConstraintWidget widget, SnapCandidate candidate) {
        if (candidate.target == null) {
            return false;
        }
        int x1 = WidgetInteractionTargets.constraintHandle(candidate.source).getDrawX();
        int x2 = WidgetInteractionTargets.constraintHandle(candidate.target).getDrawX() + candidate.margin;
        int distance = x2 - x1;
        candidatePoint.x = widget.getDrawX() + distance;
        return true;
    }

    private static boolean snapToVerticalAnchor(Point candidatePoint, ConstraintWidget widget, SnapCandidate candidate) {
        if (candidate.target == null) {
            return false;
        }
        int y1 = WidgetInteractionTargets.constraintHandle(candidate.source).getDrawY();
        int y2 = WidgetInteractionTargets.constraintHandle(candidate.target).getDrawY() + candidate.margin;
        int distance = y2 - y1;
        candidatePoint.y = widget.getDrawY() + distance;
        return true;
    }

    private static boolean snapHorizontalGrid(Point candidatePoint) {
        int x = candidatePoint.x;
        candidatePoint.x = x = x / 8 * 8;
        return true;
    }

    private static boolean snapVerticalGrid(Point candidatePoint) {
        int y = candidatePoint.y;
        candidatePoint.y = y = y / 8 * 8;
        return true;
    }

    private static boolean snapExistingHorizontalMargin(ConstraintWidget widget, Point candidatePoint) {
        int x = candidatePoint.x;
        ConstraintAnchor left = widget.getAnchor(ConstraintAnchor.Type.LEFT);
        ConstraintAnchor right = widget.getAnchor(ConstraintAnchor.Type.RIGHT);
        boolean snapped = false;
        if (!left.isConnected() || !right.isConnected()) {
            if (left.isConnected()) {
                int x1 = x;
                int x2 = WidgetInteractionTargets.constraintHandle(left.getTarget()).getDrawX();
                int margin = (x1 - x2) / 8 * 8;
                if (margin < 0) {
                    margin = 0;
                }
                left.setMargin(margin);
                snapped = true;
            } else if (right != null && right.isConnected()) {
                int x1 = x + widget.getDrawWidth();
                int x2 = WidgetInteractionTargets.constraintHandle(right.getTarget()).getDrawX();
                int margin = (x2 - x1) / 8 * 8;
                if (margin < 0) {
                    margin = 0;
                }
                right.setMargin(margin);
                snapped = true;
            }
        }
        return snapped;
    }

    private static boolean snapExistingVerticalMargin(ConstraintWidget widget, Point candidatePoint) {
        int y = candidatePoint.y;
        boolean snapped = false;
        ConstraintAnchor top = widget.getAnchor(ConstraintAnchor.Type.TOP);
        ConstraintAnchor bottom = widget.getAnchor(ConstraintAnchor.Type.BOTTOM);
        if (!top.isConnected() || !bottom.isConnected()) {
            if (top.isConnected()) {
                int y1 = y;
                int y2 = WidgetInteractionTargets.constraintHandle(top.getTarget()).getDrawY();
                int margin = (y1 - y2) / 8 * 8;
                if (margin < 0) {
                    margin = 0;
                }
                top.setMargin(margin);
                snapped = true;
            } else if (bottom.isConnected()) {
                int y1 = y + widget.getHeight();
                int y2 = WidgetInteractionTargets.constraintHandle(bottom.getTarget()).getDrawY();
                int margin = (y2 - y1) / 8 * 8;
                if (margin < 0) {
                    margin = 0;
                }
                bottom.setMargin(margin);
                snapped = true;
            }
        }
        return snapped;
    }
}

