/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.drawing.decorator;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import com.android.tools.sherpa.drawing.ColorSet;
import com.android.tools.sherpa.drawing.ConnectionDraw;
import com.android.tools.sherpa.drawing.SceneDraw;
import com.android.tools.sherpa.drawing.SnapDraw;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.drawing.WidgetDraw;
import com.android.tools.sherpa.drawing.decorator.ColorTheme;
import com.android.tools.sherpa.interaction.ConstraintHandle;
import com.android.tools.sherpa.interaction.DrawPicker;
import com.android.tools.sherpa.interaction.WidgetInteractionTargets;
import com.android.tools.sherpa.structure.Selection;
import com.android.tools.sherpa.structure.WidgetCompanion;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.imageio.ImageIO;
import javax.swing.Timer;

public class WidgetDecorator {
    public static final int BLUEPRINT_STYLE = 0;
    public static final int ANDROID_STYLE = 1;
    public static Image sLockImageIcon = null;
    public static Image sUnlockImageIcon = null;
    public static Image sDeleteConnectionsImageIcon = null;
    public static Image sPackChainImageIcon = null;
    private static boolean sShowAllConstraints = false;
    private static boolean sShowTextUI = false;
    private static final int ACTIONS_HIDE_TIMEOUT = 1000;
    private boolean mIsVisible = true;
    private boolean mIsSelected = false;
    private boolean mShowResizeHandles = false;
    private boolean mShowSizeIndicator = false;
    private boolean mShowActions = false;
    protected ColorSet mColorSet;
    private SceneDraw.Repaintable mRepaintableSurface;
    private AnimationProgress mShowBaseline = new AnimationProgress();
    private AnimationProgress mShowBias = new AnimationProgress();
    private static Font sInfoFont = new Font("Helvetica", 0, 12);
    private ArrayList<WidgetAction> mWidgetActions = new ArrayList();
    private EnumSet<WidgetDraw.ANCHORS_DISPLAY> mDisplayAnchorsPolicy = EnumSet.of(WidgetDraw.ANCHORS_DISPLAY.NONE);
    private StateModel mStateModel;
    ColorTheme mBackgroundColor;
    ColorTheme mFrameColor;
    ColorTheme mTextColor;
    ColorTheme mConstraintsColor;
    ColorTheme.Look mLook;
    protected final ConstraintWidget mWidget;
    private int mStyle;
    private static final int ACTION_SIZE = 22;
    private boolean mOver = false;
    private final Timer mHideActions = new Timer(1000, e -> {
        this.mShowActions = false;
        this.repaint();
    });

    public static ConstraintHandle getConstraintHandle(ConstraintAnchor anchor) {
        ConstraintWidget widget = anchor.getOwner();
        WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
        WidgetInteractionTargets interactionTargets = companion.getWidgetInteractionTargets();
        return interactionTargets.getConstraintHandle(anchor);
    }

    public static BufferedImage loadImage(String path) {
        if (path == null) {
            return null;
        }
        try {
            InputStream stream = WidgetDecorator.class.getResourceAsStream(path);
            if (stream != null) {
                BufferedImage image = ImageIO.read(stream);
                return image;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public WidgetDecorator(ConstraintWidget widget) {
        this.mWidget = widget;
        this.mShowBias.setDelay(0L);
        this.mShowBias.setDuration(1000L);
        this.mShowBaseline.setDelay(1000L);
        this.mShowBaseline.setDuration(1000L);
        this.mWidgetActions.add(new DeleteConnectionsWidgetAction(this.mWidget));
        this.mWidgetActions.add(new ToggleChainStyleWidgetAction(this.mWidget));
        this.mHideActions.setRepeats(false);
    }

    public void setStateModel(StateModel model) {
        this.mStateModel = model;
    }

    public StateModel getStateModel() {
        return this.mStateModel;
    }

    public ArrayList<WidgetAction> getWidgetActions() {
        return this.mWidgetActions;
    }

    public void setRepaintableSurface(SceneDraw.Repaintable repaintableSurface) {
        this.mRepaintableSurface = repaintableSurface;
    }

    public void repaint() {
        if (this.mRepaintableSurface != null) {
            this.mRepaintableSurface.repaint();
        }
    }

    public void repaint(int x, int y, int w, int h) {
        if (this.mRepaintableSurface != null) {
            this.mRepaintableSurface.repaint(x, y, w, h);
        }
    }

    public boolean isShowBaseline() {
        return this.mShowBaseline.isDone();
    }

    public void updateBias() {
        this.mShowBias.start();
    }

    public void setColorSet(ColorSet colorSet) {
        if (this.mColorSet == colorSet) {
            return;
        }
        this.mColorSet = colorSet;
        if (this.mColorSet == null) {
            return;
        }
        this.mBackgroundColor = new ColorTheme(this.mColorSet.getSubduedBackground(), this.mColorSet.getBackground(), this.mColorSet.getHighlightedBackground(), this.mColorSet.getSelectedBackground());
        this.mFrameColor = new ColorTheme(this.mColorSet.getSubduedFrames(), this.mColorSet.getFrames(), this.mColorSet.getHighlightedFrames(), this.mColorSet.getSelectedFrames());
        this.mTextColor = new ColorTheme(this.mColorSet.getSubduedText(), this.mColorSet.getText(), this.mColorSet.getText(), this.mColorSet.getSelectedText());
        this.mConstraintsColor = new ColorTheme(this.mColorSet.getSubduedConstraints(), this.mColorSet.getConstraints(), this.mColorSet.getHighlightedConstraints(), this.mColorSet.getSelectedConstraints());
    }

    public void setIsVisible(boolean isVisible) {
        this.mIsVisible = isVisible;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public boolean isAnimating() {
        if (this.mColorSet == null) {
            return false;
        }
        if (this.mBackgroundColor.isAnimating()) {
            return true;
        }
        if (this.mFrameColor.isAnimating()) {
            return true;
        }
        if (this.mTextColor.isAnimating()) {
            return true;
        }
        if (this.mConstraintsColor.isAnimating()) {
            return true;
        }
        if (this.mShowBaseline.isRunning()) {
            return true;
        }
        return this.mShowBias.isRunning();
    }

    public static void setShowAllConstraints(boolean value) {
        sShowAllConstraints = value;
    }

    public static void setShowFakeUI(boolean value) {
        sShowTextUI = value;
    }

    public static boolean isShowAllConstraints() {
        return sShowAllConstraints;
    }

    public static boolean isShowFakeUI() {
        return sShowTextUI;
    }

    public void setIsSelected(boolean value) {
        if (this.mIsSelected == value && this.mLook != null) {
            return;
        }
        this.mIsSelected = value;
        if (this.mIsSelected) {
            this.setLook(ColorTheme.Look.SELECTED);
            this.mShowBaseline.start();
            this.mShowBias.start();
            this.showActions();
        } else {
            this.setLook(ColorTheme.Look.NORMAL);
            this.mShowBaseline.reset();
            this.mShowBias.reset();
        }
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    public void setShowResizeHandles(boolean value) {
        this.mShowResizeHandles = value;
    }

    public void setShowActions(boolean value) {
        this.mShowActions = value;
    }

    public void setShowSizeIndicator(boolean value) {
        this.mShowSizeIndicator = value;
    }

    public void setShowPercentIndicator(boolean value) {
        if (value) {
            this.mShowBias.start();
        }
    }

    public void setLook(ColorTheme.Look look) {
        this.mLook = look;
    }

    public ColorTheme.Look getLook() {
        return this.mLook;
    }

    public void applyLook() {
        if (this.mColorSet == null) {
            return;
        }
        if (this.mBackgroundColor.getLook() != this.mLook) {
            this.mBackgroundColor.setLook(this.mLook);
            this.mFrameColor.setLook(this.mLook);
            this.mTextColor.setLook(this.mLook);
            this.mConstraintsColor.setLook(this.mLook);
        }
    }

    public void over(boolean value) {
        this.mOver = value;
        if (this.mOver) {
            this.mShowActions = true;
        }
        this.mHideActions.restart();
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColor.getColor();
    }

    public boolean onPaint(ViewTransform transform, Graphics2D g) {
        if (this.mColorSet == null) {
            return false;
        }
        if (this.mIsSelected) {
            this.updateShowAnchorsPolicy();
        } else {
            this.mShowResizeHandles = false;
            this.mShowSizeIndicator = false;
        }
        if (this.mColorSet.drawWidgetInfos()) {
            if (this.mWidget.getVisibility() == 4) {
                Color c = this.mTextColor.getColor();
                g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 100));
            } else {
                g.setColor(this.mTextColor.getColor());
            }
            WidgetDraw.drawWidgetInfo(transform, g, this.mWidget);
        } else {
            this.onPaintBackground(transform, g);
        }
        g.setColor(this.mFrameColor.getColor());
        WidgetDraw.drawWidgetFrame(transform, g, this.mWidget, this.mDisplayAnchorsPolicy, this.mShowResizeHandles, this.mShowSizeIndicator, this.mIsSelected);
        g.setColor(this.mConstraintsColor.getColor());
        this.onPaintAnchors(transform, g);
        return this.isAnimating();
    }

    public void onPaintBackground(ViewTransform transform, Graphics2D g) {
        if (this.mColorSet == null) {
            return;
        }
        if (!this.mColorSet.drawBackground()) {
            return;
        }
        if (this.mWidget.isRoot() || this.mWidget.isRootContainer()) {
            return;
        }
        if (!(this.mWidget instanceof ConstraintWidgetContainer) && this.mWidget.getVisibility() == 0) {
            int l = transform.getSwingX(this.mWidget.getDrawX());
            int t = transform.getSwingY(this.mWidget.getDrawY());
            int w = transform.getSwingDimension(this.mWidget.getDrawWidth());
            int h = transform.getSwingDimension(this.mWidget.getDrawHeight());
            g.setColor(this.mBackgroundColor.getColor());
            if (this.mBackgroundColor.getLook() != ColorTheme.Look.NORMAL) {
                g.fillRect(l, t, w, h);
            }
            Color bg = new Color(0, 0, 0, 0);
            Color fg = ColorTheme.updateBrightness(this.mBackgroundColor.getColor(), 1.6f);
            Graphics2D gfill = (Graphics2D)g.create();
            gfill.setPaint(new LinearGradientPaint(l, t, l + 2, t + 2, new float[]{0.0f, 0.1f, 0.1001f}, new Color[]{fg, fg, bg}, MultipleGradientPaint.CycleMethod.REFLECT));
            gfill.fillRect(l, t, w, h);
            gfill.dispose();
        }
    }

    public void onPaintAnchors(ViewTransform transform, Graphics2D g) {
        ConstraintHandle handle;
        ConstraintAnchor baseline;
        boolean showBottomAnchor;
        if (this.mColorSet == null) {
            return;
        }
        if (this.mWidget.getVisibility() == 8) {
            return;
        }
        ConstraintAnchor leftAnchor = this.mWidget.getAnchor(ConstraintAnchor.Type.LEFT);
        ConstraintAnchor rightAnchor = this.mWidget.getAnchor(ConstraintAnchor.Type.RIGHT);
        ConstraintAnchor topAnchor = this.mWidget.getAnchor(ConstraintAnchor.Type.TOP);
        ConstraintAnchor bottomAnchor = this.mWidget.getAnchor(ConstraintAnchor.Type.BOTTOM);
        boolean leftAnchorIsConnected = leftAnchor != null ? leftAnchor.isConnected() : false;
        boolean rightAnchorIsConnected = rightAnchor != null ? rightAnchor.isConnected() : false;
        boolean topAnchorIsConnected = topAnchor != null ? topAnchor.isConnected() : false;
        boolean bottomAnchorIsConnected = bottomAnchor != null ? bottomAnchor.isConnected() : false;
        boolean displayAllAnchors = this.mDisplayAnchorsPolicy.contains((Object)WidgetDraw.ANCHORS_DISPLAY.ALL);
        boolean showLeftAnchor = displayAllAnchors || this.mDisplayAnchorsPolicy.contains((Object)WidgetDraw.ANCHORS_DISPLAY.LEFT) || this.mDisplayAnchorsPolicy.contains((Object)WidgetDraw.ANCHORS_DISPLAY.HORIZONTAL);
        boolean showRightAnchor = displayAllAnchors || this.mDisplayAnchorsPolicy.contains((Object)WidgetDraw.ANCHORS_DISPLAY.RIGHT) || this.mDisplayAnchorsPolicy.contains((Object)WidgetDraw.ANCHORS_DISPLAY.HORIZONTAL);
        boolean showTopAnchor = displayAllAnchors || this.mDisplayAnchorsPolicy.contains((Object)WidgetDraw.ANCHORS_DISPLAY.TOP) || this.mDisplayAnchorsPolicy.contains((Object)WidgetDraw.ANCHORS_DISPLAY.VERTICAL);
        boolean bl = showBottomAnchor = displayAllAnchors || this.mDisplayAnchorsPolicy.contains((Object)WidgetDraw.ANCHORS_DISPLAY.BOTTOM) || this.mDisplayAnchorsPolicy.contains((Object)WidgetDraw.ANCHORS_DISPLAY.VERTICAL);
        if (!this.mDisplayAnchorsPolicy.contains((Object)WidgetDraw.ANCHORS_DISPLAY.NONE)) {
            showLeftAnchor |= leftAnchorIsConnected;
            showRightAnchor |= rightAnchorIsConnected;
            showTopAnchor |= topAnchorIsConnected;
            showBottomAnchor |= bottomAnchorIsConnected;
        }
        WidgetCompanion widgetCompanion = (WidgetCompanion)this.mWidget.getCompanionWidget();
        WidgetInteractionTargets interactionTargets = widgetCompanion.getWidgetInteractionTargets();
        g.setColor(this.mConstraintsColor.getColor());
        if (this.mWidget.hasBaseline() && ((baseline = this.mWidget.getAnchor(ConstraintAnchor.Type.BASELINE)).isConnected() || this.mIsSelected && this.mShowResizeHandles)) {
            Color c = g.getColor();
            float progress = 1.0f;
            if (!baseline.isConnected() && (progress = this.mShowBaseline.getProgress()) > 0.0f) {
                int alpha = (int)(255.0f * progress);
                g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
            }
            if (progress > 0.0f) {
                ConstraintHandle handle2 = interactionTargets.getConstraintHandle(baseline);
                handle2.draw(transform, g, this.mColorSet, this.mIsSelected);
            }
            g.setColor(c);
        }
        if (this.mIsSelected) {
            g.setColor(this.mColorSet.getSelectedConstraints());
        }
        if (showLeftAnchor && (handle = interactionTargets.getConstraintHandle(leftAnchor)) != null) {
            handle.draw(transform, g, this.mColorSet, this.mIsSelected);
        }
        if (showRightAnchor && (handle = interactionTargets.getConstraintHandle(rightAnchor)) != null) {
            handle.draw(transform, g, this.mColorSet, this.mIsSelected);
        }
        if (showTopAnchor && (handle = interactionTargets.getConstraintHandle(topAnchor)) != null) {
            handle.draw(transform, g, this.mColorSet, this.mIsSelected);
        }
        if (showBottomAnchor && (handle = interactionTargets.getConstraintHandle(bottomAnchor)) != null) {
            handle.draw(transform, g, this.mColorSet, this.mIsSelected);
        }
    }

    public void onPaintConstraints(ViewTransform transform, Graphics2D g) {
        if (this.mColorSet == null) {
            return;
        }
        if (this.mWidget.getVisibility() == 8) {
            return;
        }
        g.setColor(this.mConstraintsColor.getColor());
        if (this.mIsSelected || WidgetDecorator.isShowAllConstraints() || this.getLook() == ColorTheme.Look.HIGHLIGHTED) {
            if (this.mWidget.getVisibility() == 4) {
                g.setStroke(SnapDraw.sDashedStroke);
            }
            ArrayList<ConstraintAnchor.Type> anchors = new ArrayList<ConstraintAnchor.Type>();
            if (this.mWidget.hasBaseline() && (this.mShowBaseline.isDone() || this.mWidget.getAnchor(ConstraintAnchor.Type.BASELINE).isConnected())) {
                anchors.add(ConstraintAnchor.Type.BASELINE);
            }
            anchors.add(ConstraintAnchor.Type.LEFT);
            anchors.add(ConstraintAnchor.Type.TOP);
            anchors.add(ConstraintAnchor.Type.RIGHT);
            anchors.add(ConstraintAnchor.Type.BOTTOM);
            Color currentColor = g.getColor();
            Stroke currentStroke = g.getStroke();
            for (ConstraintAnchor.Type type : anchors) {
                float progress;
                ConstraintAnchor target;
                ConstraintAnchor anchor = this.mWidget.getAnchor(type);
                if (anchor == null || !anchor.isConnected() || (target = anchor.getTarget()).getOwner().getVisibility() == 8) continue;
                ConstraintHandle startHandle = WidgetInteractionTargets.constraintHandle(anchor);
                if (startHandle.getAnchor().isConnected() && startHandle.getAnchor().getConnectionCreator() == 2) {
                    g.setColor(this.mColorSet.getSoftConstraintColor());
                    g.setStroke(this.mColorSet.getSoftConstraintStroke());
                } else {
                    g.setColor(currentColor);
                    g.setStroke(currentStroke);
                }
                boolean painted = false;
                if (startHandle.isLocking() && (progress = startHandle.getLockingProgress()) > 0.0f) {
                    startHandle.drawConnection(transform, g, this.mColorSet, this.mIsSelected, true, startHandle.getAnchor().getConnectionCreator(), progress);
                    painted = true;
                    this.repaint();
                }
                if (painted) continue;
                startHandle.drawConnection(transform, g, this.mColorSet, this.mIsSelected);
            }
            g.setStroke(SnapDraw.sNormalStroke);
            this.paintBias(transform, g);
        }
    }

    public void onPaintActions(ViewTransform transform, Graphics2D g) {
        if (!this.mIsSelected) {
            return;
        }
        if (this.mColorSet == null) {
            return;
        }
        if (this.mWidget.getVisibility() == 8) {
            return;
        }
        if (!this.mShowResizeHandles) {
            return;
        }
        if (!this.mShowActions) {
            return;
        }
        if (this.mWidgetActions.size() == 0) {
            return;
        }
        int l = transform.getSwingFX(this.mWidget.getDrawX());
        int t = transform.getSwingFY(this.mWidget.getDrawY());
        int h = transform.getSwingDimension(this.mWidget.getHeight());
        int x = l;
        int y = t + h + ConnectionDraw.CONNECTION_ANCHOR_SIZE + 4;
        g.setColor(this.mColorSet.getSelectedFrames());
        for (WidgetAction action : this.mWidgetActions) {
            action.update();
            if (!action.isVisible()) continue;
            action.onPaint(transform, g, x, y);
            x += 22 + ConnectionDraw.CONNECTION_ANCHOR_SIZE;
        }
    }

    static ConstraintHandle getTargetHandle(ConstraintAnchor anchor) {
        return WidgetDecorator.getConstraintHandle(anchor.getTarget());
    }

    private void paintBias(ViewTransform transform, Graphics2D g) {
        ConstraintAnchor left = this.mWidget.getAnchor(ConstraintAnchor.Type.LEFT);
        ConstraintAnchor right = this.mWidget.getAnchor(ConstraintAnchor.Type.RIGHT);
        if (left != null && right != null && left.isConnected() && right.isConnected() && left.getConnectionCreator() != 2 && this.mShowBias.isRunning()) {
            float progress = 1.0f - this.mShowBias.getProgress();
            int percent = (int)(this.mWidget.getHorizontalBiasPercent() * 100.0f);
            int x = this.mWidget.getDrawX();
            int y = (int)((float)this.mWidget.getDrawY() + (float)this.mWidget.getDrawHeight() / 2.0f);
            Color c = this.mColorSet.getTooltipBackground();
            Color pre = g.getColor();
            int alpha = (int)(progress * 255.0f);
            x = transform.getSwingFX(x);
            y = transform.getSwingFY(y);
            int tx = transform.getSwingFX(WidgetDecorator.getTargetHandle(left).getDrawX());
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
            Color textColor = new Color(this.mColorSet.getTooltipText().getRed(), this.mColorSet.getTooltipText().getGreen(), this.mColorSet.getTooltipText().getBlue(), alpha);
            ConnectionDraw.drawRoundRectText(g, sInfoFont, textColor, this.formatPercent(percent, true), (x + tx) / 2, y);
            tx = transform.getSwingFX(WidgetDecorator.getTargetHandle(right).getDrawX());
            x = this.mWidget.getDrawRight();
            x = transform.getSwingFX(x);
            ConnectionDraw.drawRoundRectText(g, sInfoFont, textColor, this.formatPercent(percent, false), (x + tx) / 2, y);
            g.setColor(pre);
        }
        ConstraintAnchor top = this.mWidget.getAnchor(ConstraintAnchor.Type.TOP);
        ConstraintAnchor bottom = this.mWidget.getAnchor(ConstraintAnchor.Type.BOTTOM);
        if (top != null && bottom != null && top.isConnected() && bottom.isConnected() && this.mShowBias.isRunning()) {
            float progress = 1.0f - this.mShowBias.getProgress();
            int percent = (int)(this.mWidget.getVerticalBiasPercent() * 100.0f);
            int y = this.mWidget.getDrawY();
            int x = (int)((float)this.mWidget.getDrawX() + (float)this.mWidget.getDrawWidth() / 2.0f);
            Color c = this.mColorSet.getTooltipBackground();
            Color pre = g.getColor();
            int alpha = (int)(progress * 255.0f);
            int ty = transform.getSwingFY(WidgetDecorator.getTargetHandle(top).getDrawY());
            x = transform.getSwingFX(x);
            y = transform.getSwingFY(y);
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
            Color textColor = new Color(this.mColorSet.getTooltipText().getRed(), this.mColorSet.getTooltipText().getGreen(), this.mColorSet.getTooltipText().getBlue(), alpha);
            ConnectionDraw.drawRoundRectText(g, sInfoFont, textColor, this.formatPercent(percent, true), x, (y + ty) / 2);
            ty = transform.getSwingFY(WidgetDecorator.getTargetHandle(bottom).getDrawY());
            y = this.mWidget.getDrawBottom();
            y = transform.getSwingFY(y);
            ConnectionDraw.drawRoundRectText(g, sInfoFont, textColor, this.formatPercent(percent, false), x, (y + ty) / 2);
            g.setColor(pre);
        }
    }

    private String formatPercent(int percent, boolean begin) {
        String message = "" + percent + "%";
        if (begin) {
            if (percent == 25) {
                message = "1/4";
            } else if (percent == 33) {
                message = "1/3";
            } else if (percent == 66) {
                message = "2/3";
            } else if (percent == 75) {
                message = "3/4";
            }
        } else {
            message = "" + (100 - percent) + "%";
            if (percent == 25) {
                message = "3/4";
            } else if (percent == 33) {
                message = "2/3";
            } else if (percent == 66) {
                message = "1/3";
            } else if (percent == 75) {
                message = "1/4";
            }
        }
        return message;
    }

    private void updateShowAnchorsPolicy() {
        this.mDisplayAnchorsPolicy.clear();
        this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.ALL);
        this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.SELECTED);
        if (this.mWidget.getParent() instanceof ConstraintWidgetContainer) {
            ConstraintWidgetContainer container = (ConstraintWidgetContainer)this.mWidget.getParent();
            if (container.handlesInternalConstraints()) {
                this.mDisplayAnchorsPolicy.clear();
                this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.NONE);
            }
        } else {
            this.mDisplayAnchorsPolicy.clear();
            this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.NONE);
        }
        if (!this.mShowResizeHandles) {
            this.mDisplayAnchorsPolicy.clear();
            this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.CONNECTED);
        }
    }

    public void updateShowAnchorsPolicy(ConstraintWidget selectedWidget, ConstraintAnchor selectedAnchor) {
        this.mDisplayAnchorsPolicy.clear();
        this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.NONE);
        if (this.getLook() != ColorTheme.Look.HIGHLIGHTED) {
            return;
        }
        if (WidgetDecorator.isShowAllConstraints()) {
            if (this.mWidget.getParent() != null) {
                ConstraintWidgetContainer container;
                if (this.mWidget.getParent() instanceof ConstraintWidgetContainer && !(container = (ConstraintWidgetContainer)this.mWidget.getParent()).handlesInternalConstraints()) {
                    this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.CONNECTED);
                }
            } else {
                this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.CONNECTED);
            }
        }
        if (selectedWidget != null) {
            if (!WidgetDecorator.isShowAllConstraints()) {
                this.mDisplayAnchorsPolicy.clear();
                this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.NONE);
            }
            ConstraintAnchor left = this.isConnectedAnchor(selectedWidget, ConstraintAnchor.Type.LEFT, this.mWidget);
            ConstraintAnchor right = this.isConnectedAnchor(selectedWidget, ConstraintAnchor.Type.RIGHT, this.mWidget);
            ConstraintAnchor top = this.isConnectedAnchor(selectedWidget, ConstraintAnchor.Type.TOP, this.mWidget);
            ConstraintAnchor bottom = this.isConnectedAnchor(selectedWidget, ConstraintAnchor.Type.BOTTOM, this.mWidget);
            ConstraintAnchor baseline = this.isConnectedAnchor(selectedWidget, ConstraintAnchor.Type.BASELINE, this.mWidget);
            this.updateDisplayAnchorSet(this.mDisplayAnchorsPolicy, left);
            this.updateDisplayAnchorSet(this.mDisplayAnchorsPolicy, top);
            this.updateDisplayAnchorSet(this.mDisplayAnchorsPolicy, right);
            this.updateDisplayAnchorSet(this.mDisplayAnchorsPolicy, bottom);
            this.updateDisplayAnchorSet(this.mDisplayAnchorsPolicy, baseline);
        }
        if (selectedAnchor != null && selectedAnchor.isConnectionAllowed(this.mWidget)) {
            if (selectedAnchor.getType() == ConstraintAnchor.Type.BASELINE) {
                this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.BASELINE);
            } else if (selectedAnchor.getType() == ConstraintAnchor.Type.CENTER) {
                this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.VERTICAL);
                this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.HORIZONTAL);
                if (this.mWidget == selectedAnchor.getOwner().getParent()) {
                    this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.CENTER);
                }
            } else if (selectedAnchor.isVerticalAnchor()) {
                this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.VERTICAL);
            } else {
                this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.HORIZONTAL);
            }
        }
        if (this.getLook() == ColorTheme.Look.HIGHLIGHTED) {
            this.mDisplayAnchorsPolicy.clear();
            this.mDisplayAnchorsPolicy.add(WidgetDraw.ANCHORS_DISPLAY.CONNECTED);
        }
    }

    private ConstraintAnchor isConnectedAnchor(ConstraintWidget selectedWidget, ConstraintAnchor.Type type, ConstraintWidget widget) {
        ConstraintAnchor anchor = selectedWidget.getAnchor(type);
        if (anchor != null && anchor.isConnected() && anchor.getTarget().getOwner() == widget) {
            return anchor.getTarget();
        }
        return null;
    }

    private void updateDisplayAnchorSet(EnumSet<WidgetDraw.ANCHORS_DISPLAY> set, ConstraintAnchor anchor) {
        if (anchor == null) {
            return;
        }
        ConstraintAnchor.Type type = anchor.getType();
        switch (type) {
            case LEFT: {
                set.add(WidgetDraw.ANCHORS_DISPLAY.LEFT);
                break;
            }
            case TOP: {
                set.add(WidgetDraw.ANCHORS_DISPLAY.TOP);
                break;
            }
            case RIGHT: {
                set.add(WidgetDraw.ANCHORS_DISPLAY.RIGHT);
                break;
            }
            case BOTTOM: {
                set.add(WidgetDraw.ANCHORS_DISPLAY.BOTTOM);
                break;
            }
            case BASELINE: {
                set.add(WidgetDraw.ANCHORS_DISPLAY.BASELINE);
            }
        }
    }

    public void applyDimensionBehaviour() {
    }

    public ConstraintWidget mousePressed(float x, float y, ViewTransform transform, Selection selection) {
        return null;
    }

    public void mouseRelease(int x, int y, ViewTransform transform, Selection selection) {
    }

    public int getStyle() {
        return this.mStyle;
    }

    public void setStyle(int style) {
        this.mStyle = style;
    }

    private void showActions() {
        if (this.mColorSet == null) {
            return;
        }
        int delay = 0;
        for (WidgetAction action : this.mWidgetActions) {
            action.show(delay);
            delay += 250;
        }
        this.repaint();
    }

    private class ToggleChainStyleWidgetAction
    extends WidgetAction {
        String[] mPackChainText;
        boolean mIsVisible;

        ToggleChainStyleWidgetAction(ConstraintWidget widget) {
            super(widget);
            this.mPackChainText = new String[]{"Toggle chain style"};
            this.mIsVisible = false;
        }

        @Override
        String[] getText() {
            return this.mPackChainText;
        }

        @Override
        void update() {
            this.mIsVisible = this.mWidget.isInVerticalChain() || this.mWidget.isInHorizontalChain();
        }

        @Override
        public boolean isVisible() {
            return this.mIsVisible;
        }

        @Override
        boolean onPaint(ViewTransform transform, Graphics2D g, int x, int y) {
            if (!super.onPaint(transform, g, x, y)) {
                return false;
            }
            int m = 4;
            int rect = 22 - 2 * m;
            if (sPackChainImageIcon != null) {
                g.drawImage(sPackChainImageIcon, x + m, y + m, rect, rect, null, null);
            }
            return true;
        }

        @Override
        public boolean click() {
            WidgetDecorator decorator;
            WidgetCompanion companion;
            int[] cycle;
            ConstraintAnchor targetAnchor;
            ConstraintWidget target;
            ConstraintAnchor targetOwner;
            ConstraintAnchor anchor;
            ConstraintWidget found;
            ConstraintWidget tmp;
            if (this.mWidget.isInHorizontalChain()) {
                tmp = this.mWidget;
                found = null;
                while (found == null && tmp != null) {
                    anchor = tmp.getAnchor(ConstraintAnchor.Type.LEFT);
                    targetOwner = anchor == null ? null : anchor.getTarget();
                    ConstraintWidget constraintWidget = target = targetOwner == null ? null : targetOwner.getOwner();
                    if (target == this.mWidget.getParent()) {
                        found = tmp;
                        break;
                    }
                    ConstraintAnchor constraintAnchor = targetAnchor = target == null ? null : target.getAnchor(ConstraintAnchor.Type.RIGHT).getTarget();
                    if (targetAnchor != null && targetAnchor.getOwner() != tmp) {
                        found = tmp;
                        continue;
                    }
                    tmp = target;
                }
                if (found != null) {
                    cycle = new int[]{1, 2, 0};
                    found.setHorizontalChainStyle(cycle[found.getHorizontalChainStyle()]);
                    companion = (WidgetCompanion)found.getCompanionWidget();
                    decorator = companion.getWidgetDecorator(0);
                    decorator.getStateModel().save(decorator);
                }
            }
            if (this.mWidget.isInVerticalChain()) {
                tmp = this.mWidget;
                found = null;
                while (found == null && tmp != null) {
                    anchor = tmp.getAnchor(ConstraintAnchor.Type.TOP);
                    targetOwner = anchor == null ? null : anchor.getTarget();
                    ConstraintWidget constraintWidget = target = targetOwner == null ? null : targetOwner.getOwner();
                    if (target == this.mWidget.getParent()) {
                        found = tmp;
                        break;
                    }
                    ConstraintAnchor constraintAnchor = targetAnchor = target == null ? null : target.getAnchor(ConstraintAnchor.Type.BOTTOM).getTarget();
                    if (targetAnchor != null && targetAnchor.getOwner() != tmp) {
                        found = tmp;
                        continue;
                    }
                    tmp = target;
                }
                if (found != null) {
                    cycle = new int[]{1, 2, 0};
                    found.setVerticalChainStyle(cycle[found.getVerticalChainStyle()]);
                    companion = (WidgetCompanion)found.getCompanionWidget();
                    decorator = companion.getWidgetDecorator(0);
                    decorator.getStateModel().save(decorator);
                }
            }
            return true;
        }
    }

    private class DeleteConnectionsWidgetAction
    extends WidgetAction {
        String[] mDeleteText;
        boolean mIsVisible;

        DeleteConnectionsWidgetAction(ConstraintWidget widget) {
            super(widget);
            this.mDeleteText = new String[]{"Delete All Constraints"};
            this.mIsVisible = false;
        }

        @Override
        String[] getText() {
            return this.mDeleteText;
        }

        @Override
        void update() {
            this.mIsVisible = false;
            for (ConstraintAnchor anchor : this.mWidget.getAnchors()) {
                if (!anchor.isConnected()) continue;
                this.mIsVisible = true;
                return;
            }
        }

        @Override
        public boolean isVisible() {
            return this.mIsVisible;
        }

        @Override
        boolean onPaint(ViewTransform transform, Graphics2D g, int x, int y) {
            if (!super.onPaint(transform, g, x, y)) {
                return false;
            }
            int m = 4;
            int rect = 22 - 2 * m;
            if (sDeleteConnectionsImageIcon != null) {
                g.drawImage(sDeleteConnectionsImageIcon, x + m, y + m, rect, rect, null, null);
            }
            return true;
        }

        @Override
        public boolean click() {
            this.mWidget.resetAllConstraints();
            WidgetCompanion companion = (WidgetCompanion)this.mWidget.getCompanionWidget();
            WidgetDecorator decorator = companion.getWidgetDecorator(0);
            decorator.getStateModel().save(decorator);
            WidgetDecorator.this.repaint();
            return true;
        }
    }

    private class LockWidgetAction
    extends WidgetAction {
        int mConstraintsCreator;
        String[] mLockConstraints;
        String[] mUnlockConstraints;

        LockWidgetAction(ConstraintWidget widget) {
            super(widget);
            this.mConstraintsCreator = -1;
            this.mLockConstraints = new String[]{"Lock Constraints", "(unlock constraints are broken", "by dragging the widget)"};
            this.mUnlockConstraints = new String[]{"Unlock Constraints"};
        }

        @Override
        void update() {
            this.mConstraintsCreator = this.getMainConstraintsCreator(this.mWidget);
        }

        @Override
        public boolean isVisible() {
            return this.mConstraintsCreator != -1;
        }

        @Override
        String[] getText() {
            if (this.mConstraintsCreator == 2) {
                return this.mLockConstraints;
            }
            return this.mUnlockConstraints;
        }

        @Override
        boolean onPaint(ViewTransform transform, Graphics2D g, int x, int y) {
            if (!super.onPaint(transform, g, x, y)) {
                return false;
            }
            int m = 4;
            int rect = 22 - 2 * m;
            if (sLockImageIcon != null) {
                Image image = sUnlockImageIcon;
                if (this.mConstraintsCreator == 2) {
                    image = sLockImageIcon;
                }
                g.drawImage(image, x + m, y + m, rect, rect, null, null);
            }
            return true;
        }

        @Override
        public boolean click() {
            if (this.mConstraintsCreator == 2) {
                this.setConstraintsCreator(this.mWidget, 0);
            } else {
                this.setConstraintsCreator(this.mWidget, 2);
            }
            WidgetDecorator.this.repaint();
            return true;
        }

        void setConstraintsCreator(ConstraintWidget widget, int creator) {
            for (ConstraintAnchor anchor : widget.getAnchors()) {
                if (!anchor.isConnected()) continue;
                anchor.setConnectionCreator(creator);
            }
        }

        int getMainConstraintsCreator(ConstraintWidget widget) {
            int numAuto = 0;
            int numUser = 0;
            for (ConstraintAnchor anchor : widget.getAnchors()) {
                if (!anchor.isConnected()) continue;
                if (anchor.getConnectionCreator() == 2) {
                    ++numAuto;
                    continue;
                }
                ++numUser;
            }
            if (numAuto == 0 && numUser == 0) {
                return -1;
            }
            if (numUser > numAuto) {
                return 0;
            }
            return 2;
        }
    }

    public class WidgetAction {
        private int mX;
        private int mY;
        private boolean mOver = false;
        protected final ConstraintWidget mWidget;
        private long mStartVisible = 0L;

        WidgetAction(ConstraintWidget widget) {
            this.mWidget = widget;
        }

        String[] getText() {
            return null;
        }

        void update() {
        }

        public boolean isVisible() {
            return true;
        }

        public boolean click() {
            return false;
        }

        void show(int delay) {
            this.mStartVisible = System.currentTimeMillis();
        }

        boolean onPaint(ViewTransform transform, Graphics2D g, int x, int y) {
            int r = 22;
            this.mX = x;
            this.mY = y;
            x += r / 2;
            y += r / 2;
            Color pre = g.getColor();
            if (!this.mOver) {
                g.setColor(WidgetDecorator.this.mColorSet.getWidgetActionBackground());
            } else {
                g.setColor(WidgetDecorator.this.mColorSet.getWidgetActionSelectedBackground());
            }
            int c = 8;
            Color prec = g.getColor();
            g.setColor(WidgetDecorator.this.mColorSet.getBackground());
            g.fillRoundRect(x - r / 2 - 2, y - r / 2 - 2, r + 4, r + 4, c, c);
            g.drawRoundRect(x - r / 2 - 2, y - r / 2 - 2, r + 4, r + 4, c, c);
            g.setColor(prec);
            g.fillRoundRect(x - r / 2, y - r / 2, r, r, c, c);
            g.drawRoundRect(x - r / 2, y - r / 2, r, r, c, c);
            g.setColor(pre);
            if (this.mOver && this.mStartVisible != 0L && System.currentTimeMillis() - this.mStartVisible > 800L) {
                WidgetDraw.drawTooltip(g, WidgetDecorator.this.mColorSet, this.getText(), x, y, false);
            } else if (!this.mOver) {
                this.mStartVisible = 0L;
            }
            return true;
        }

        public void over(boolean value) {
            this.mOver = value;
            if (this.mOver && this.mStartVisible == 0L) {
                this.mStartVisible = System.currentTimeMillis();
            }
            int r = 22;
            WidgetDecorator.this.repaint(this.mX - r / 2, this.mY - r / 2, r, r);
            if (this.mOver) {
                WidgetDecorator.this.mShowActions = true;
                WidgetDecorator.this.mHideActions.stop();
            }
        }

        public void addToPicker(ViewTransform transform, DrawPicker picker) {
            picker.addRect(this, 0, this.mX, this.mY, this.mX + 22, this.mY + 22);
        }

        public ConstraintWidget getWidget() {
            return this.mWidget;
        }
    }

    class AnimationProgress {
        long mStart = 0L;
        long mDelay = 1000L;
        long mDuration = 300L;

        AnimationProgress() {
        }

        public void setDelay(long delay) {
            this.mDelay = delay;
        }

        public void setDuration(long duration) {
            this.mDuration = duration;
        }

        public void start() {
            this.mStart = System.currentTimeMillis() + this.mDelay;
        }

        public float getProgress() {
            if (this.mStart == 0L) {
                return 0.0f;
            }
            long current = System.currentTimeMillis();
            long delta = current - this.mStart;
            if (delta < 0L) {
                return 0.0f;
            }
            if (delta > this.mDuration) {
                return 1.0f;
            }
            return (float)(current - this.mStart) / (float)this.mDuration;
        }

        public boolean isDone() {
            if (this.mStart == 0L) {
                return false;
            }
            long current = System.currentTimeMillis();
            long delta = current - this.mStart;
            return delta > this.mDuration;
        }

        public void reset() {
            this.mStart = 0L;
        }

        public boolean isRunning() {
            return this.mStart != 0L && !this.isDone();
        }
    }

    public static interface StateModel {
        public void save(WidgetDecorator var1);
    }
}

