/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.animation;

import com.android.tools.sherpa.animation.Animation;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.interaction.ConstraintHandle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;

public class AnimatedCircle
extends Animation {
    private ConstraintHandle mAnchor;
    protected int mRadius = 3;
    protected Color mColor = Color.white;
    protected Color mBackgroundColor = new Color(24, 55, 112);
    private Stroke mStroke = new BasicStroke(1.0f);

    public AnimatedCircle(ConstraintHandle anchor) {
        this.mAnchor = anchor;
        this.setLoop(true);
    }

    protected int getRadius(double progress) {
        return this.mRadius;
    }

    @Override
    public void onPaint(ViewTransform transform, Graphics2D g) {
        int x = transform.getSwingX(this.mAnchor.getDrawX());
        int y = transform.getSwingY(this.mAnchor.getDrawY());
        double progress = this.getProgress();
        int alpha = this.getPulsatingAlpha(progress);
        int radius = this.getRadius(progress);
        if (this.mBackgroundColor != null) {
            g.setColor(this.mBackgroundColor);
            Ellipse2D.Float circle = new Ellipse2D.Float(x - radius, y - radius, radius * 2, radius * 2);
            g.fill(circle);
        }
        Color highlight = new Color(this.mColor.getRed(), this.mColor.getGreen(), this.mColor.getBlue(), alpha);
        g.setColor(highlight);
        Ellipse2D.Float circle = new Ellipse2D.Float(x - radius, y - radius, radius * 2, radius * 2);
        g.setStroke(this.mStroke);
        g.fill(circle);
        g.draw(circle);
    }
}

