/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver;

import android.support.constraint.solver.Amount;
import android.support.constraint.solver.EquationVariable;
import android.support.constraint.solver.LinearSystem;
import android.support.constraint.solver.SolverVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

class LinearEquation {
    private ArrayList<EquationVariable> mLeftSide = new ArrayList();
    private ArrayList<EquationVariable> mRightSide = new ArrayList();
    private ArrayList<EquationVariable> mCurrentSide = null;
    private Type mType = Type.EQUALS;
    private LinearSystem mSystem = null;
    private static int artificialIndex = 0;
    private static int slackIndex = 0;
    private static int errorIndex = 0;

    public boolean isNull() {
        if (this.mLeftSide.size() == 0 && this.mRightSide.size() == 0) {
            return true;
        }
        if (this.mLeftSide.size() == 1 && this.mRightSide.size() == 1) {
            EquationVariable v1 = this.mLeftSide.get(0);
            EquationVariable v2 = this.mRightSide.get(0);
            if (v1.isConstant() && v2.isConstant() && v1.getAmount().isNull() && v2.getAmount().isNull()) {
                return true;
            }
        }
        return false;
    }

    static String getNextArtificialVariableName() {
        return "a" + ++artificialIndex;
    }

    static String getNextSlackVariableName() {
        return "s" + ++slackIndex;
    }

    static String getNextErrorVariableName() {
        return "e" + ++errorIndex;
    }

    public static void resetNaming() {
        artificialIndex = 0;
        slackIndex = 0;
        errorIndex = 0;
    }

    public LinearEquation(LinearEquation equation) {
        ArrayList<EquationVariable> mLeftSide1 = equation.mLeftSide;
        int mLeftSide1Size = mLeftSide1.size();
        for (int i = 0; i < mLeftSide1Size; ++i) {
            EquationVariable v = mLeftSide1.get(i);
            EquationVariable v2 = new EquationVariable(v);
            this.mLeftSide.add(v2);
        }
        ArrayList<EquationVariable> mRightSide1 = equation.mRightSide;
        int mRightSide1Size = mRightSide1.size();
        for (int i = 0; i < mRightSide1Size; ++i) {
            EquationVariable v = mRightSide1.get(i);
            EquationVariable v2 = new EquationVariable(v);
            this.mRightSide.add(v2);
        }
        this.mCurrentSide = this.mRightSide;
    }

    public void i() {
        if (this.mSystem == null) {
            return;
        }
        this.mSystem.addConstraint(this);
    }

    public void setLeftSide() {
        this.mCurrentSide = this.mLeftSide;
    }

    public void clearLeftSide() {
        this.mLeftSide.clear();
    }

    public void remove(SolverVariable v) {
        EquationVariable ev = this.find(v, this.mLeftSide);
        if (ev != null) {
            this.mLeftSide.remove(ev);
        }
        if ((ev = this.find(v, this.mRightSide)) != null) {
            this.mRightSide.remove(ev);
        }
    }

    public LinearEquation() {
        this.mCurrentSide = this.mLeftSide;
    }

    public LinearEquation(LinearSystem system) {
        this.mCurrentSide = this.mLeftSide;
        this.mSystem = system;
    }

    public void setSystem(LinearSystem system) {
        this.mSystem = system;
    }

    public LinearEquation equalsTo() {
        this.mCurrentSide = this.mRightSide;
        return this;
    }

    public LinearEquation greaterThan() {
        this.mCurrentSide = this.mRightSide;
        this.mType = Type.GREATER_THAN;
        return this;
    }

    public LinearEquation lowerThan() {
        this.mCurrentSide = this.mRightSide;
        this.mType = Type.LOWER_THAN;
        return this;
    }

    public void normalize() {
        if (this.mType == Type.EQUALS) {
            return;
        }
        this.mCurrentSide = this.mLeftSide;
        if (this.mType == Type.LOWER_THAN) {
            this.withSlack(1);
        } else if (this.mType == Type.GREATER_THAN) {
            this.withSlack(-1);
        }
        this.mType = Type.EQUALS;
        this.mCurrentSide = this.mRightSide;
    }

    public void simplify() {
        this.simplifySide(this.mLeftSide);
        this.simplifySide(this.mRightSide);
    }

    private void simplifySide(ArrayList<EquationVariable> side) {
        int i;
        EquationVariable constant = null;
        HashMap<String, EquationVariable> variables = new HashMap<String, EquationVariable>();
        ArrayList<String> variablesNames = new ArrayList<String>();
        int sideSize = side.size();
        for (i = 0; i < sideSize; ++i) {
            EquationVariable v = side.get(i);
            if (v.isConstant()) {
                if (constant == null) {
                    constant = v;
                    continue;
                }
                constant.add(v);
                continue;
            }
            if (variables.containsKey(v.getName())) {
                EquationVariable original = (EquationVariable)variables.get(v.getName());
                original.add(v);
                continue;
            }
            variables.put(v.getName(), v);
            variablesNames.add(v.getName());
        }
        side.clear();
        if (constant != null) {
            side.add(constant);
        }
        Collections.sort(variablesNames);
        int variablesNamesSize = variablesNames.size();
        for (i = 0; i < variablesNamesSize; ++i) {
            String name = (String)variablesNames.get(i);
            EquationVariable v = (EquationVariable)variables.get(name);
            side.add(v);
        }
        this.removeNullTerms(side);
    }

    public void moveAllToTheRight() {
        int mLeftSideSize = this.mLeftSide.size();
        for (int i = 0; i < mLeftSideSize; ++i) {
            EquationVariable v = this.mLeftSide.get(i);
            this.mRightSide.add(v.inverse());
        }
        this.mLeftSide.clear();
    }

    public void balance() {
        EquationVariable v;
        int i;
        if (this.mLeftSide.size() == 0 && this.mRightSide.size() == 0) {
            return;
        }
        this.mCurrentSide = this.mLeftSide;
        int mLeftSideSize = this.mLeftSide.size();
        for (int i2 = 0; i2 < mLeftSideSize; ++i2) {
            EquationVariable v2 = this.mLeftSide.get(i2);
            this.mRightSide.add(v2.inverse());
        }
        this.mLeftSide.clear();
        this.simplifySide(this.mRightSide);
        EquationVariable found = null;
        int mRightSideSize = this.mRightSide.size();
        for (i = 0; i < mRightSideSize; ++i) {
            v = this.mRightSide.get(i);
            if (v.getType() != SolverVariable.Type.UNRESTRICTED) continue;
            found = v;
            break;
        }
        if (found == null) {
            mRightSideSize = this.mRightSide.size();
            for (i = 0; i < mRightSideSize; ++i) {
                v = this.mRightSide.get(i);
                if (v.getType() != SolverVariable.Type.SLACK) continue;
                found = v;
                break;
            }
        }
        if (found == null) {
            mRightSideSize = this.mRightSide.size();
            for (i = 0; i < mRightSideSize; ++i) {
                v = this.mRightSide.get(i);
                if (v.getType() != SolverVariable.Type.ERROR) continue;
                found = v;
                break;
            }
        }
        if (found == null) {
            return;
        }
        this.mRightSide.remove(found);
        found.inverse();
        if (!found.getAmount().isOne()) {
            Amount foundAmount = found.getAmount();
            int mRightSideSize2 = this.mRightSide.size();
            for (int i3 = 0; i3 < mRightSideSize2; ++i3) {
                EquationVariable v3 = this.mRightSide.get(i3);
                v3.getAmount().divide(foundAmount);
            }
            found.setAmount(new Amount(1));
        }
        this.simplifySide(this.mRightSide);
        this.mLeftSide.add(found);
    }

    private void removeNullTerms(ArrayList<EquationVariable> list) {
        boolean hasNullTerm = false;
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            EquationVariable v = list.get(i);
            if (!v.getAmount().isNull()) continue;
            hasNullTerm = true;
            break;
        }
        if (hasNullTerm) {
            ArrayList<EquationVariable> newSide = new ArrayList<EquationVariable>();
            int listSize2 = list.size();
            for (int i = 0; i < listSize2; ++i) {
                EquationVariable v = list.get(i);
                if (v.getAmount().isNull()) continue;
                newSide.add(v);
            }
            list.clear();
            list.addAll(newSide);
        }
    }

    public void pivot(SolverVariable variable) {
        if (this.mLeftSide.size() == 1 && this.mLeftSide.get(0).getSolverVariable() == variable) {
            return;
        }
        int mLeftSideSize = this.mLeftSide.size();
        for (int i = 0; i < mLeftSideSize; ++i) {
            EquationVariable v = this.mLeftSide.get(i);
            this.mRightSide.add(v.inverse());
        }
        this.mLeftSide.clear();
        this.simplifySide(this.mRightSide);
        EquationVariable found = null;
        int mRightSideSize = this.mRightSide.size();
        for (int i = 0; i < mRightSideSize; ++i) {
            EquationVariable v = this.mRightSide.get(i);
            if (v.getSolverVariable() != variable) continue;
            found = v;
            break;
        }
        if (found != null) {
            this.mRightSide.remove(found);
            found.inverse();
            if (!found.getAmount().isOne()) {
                Amount foundAmount = found.getAmount();
                int mRightSideSize2 = this.mRightSide.size();
                for (int i = 0; i < mRightSideSize2; ++i) {
                    EquationVariable v = this.mRightSide.get(i);
                    v.getAmount().divide(foundAmount);
                }
                found.setAmount(new Amount(1));
            }
            this.mLeftSide.add(found);
        }
    }

    public boolean hasNegativeConstant() {
        int mRightSideSize = this.mRightSide.size();
        for (int i = 0; i < mRightSideSize; ++i) {
            EquationVariable v = this.mRightSide.get(i);
            if (!v.isConstant() || !v.getAmount().isNegative()) continue;
            return true;
        }
        return false;
    }

    public Amount getConstant() {
        int mRightSideSize = this.mRightSide.size();
        for (int i = 0; i < mRightSideSize; ++i) {
            EquationVariable v = this.mRightSide.get(i);
            if (!v.isConstant()) continue;
            return v.getAmount();
        }
        return null;
    }

    public void inverse() {
        EquationVariable v;
        int i;
        Amount amount = new Amount(-1);
        int mLeftSideSize = this.mLeftSide.size();
        for (i = 0; i < mLeftSideSize; ++i) {
            v = this.mLeftSide.get(i);
            v.multiply(amount);
        }
        int mRightSideSize = this.mRightSide.size();
        for (i = 0; i < mRightSideSize; ++i) {
            v = this.mRightSide.get(i);
            v.multiply(amount);
        }
    }

    public EquationVariable getFirstUnconstrainedVariable() {
        EquationVariable v;
        int i;
        int mLeftSideSize = this.mLeftSide.size();
        for (i = 0; i < mLeftSideSize; ++i) {
            v = this.mLeftSide.get(i);
            if (v.getType() != SolverVariable.Type.UNRESTRICTED) continue;
            return v;
        }
        int mRightSideSize = this.mRightSide.size();
        for (i = 0; i < mRightSideSize; ++i) {
            v = this.mRightSide.get(i);
            if (v.getType() != SolverVariable.Type.UNRESTRICTED) continue;
            return v;
        }
        return null;
    }

    public EquationVariable getLeftVariable() {
        if (this.mLeftSide.size() == 1) {
            return this.mLeftSide.get(0);
        }
        return null;
    }

    public void replace(SolverVariable v, LinearEquation l) {
        this.replace(v, l, this.mLeftSide);
        this.replace(v, l, this.mRightSide);
    }

    private void replace(SolverVariable v, LinearEquation l, ArrayList<EquationVariable> list) {
        EquationVariable toReplace = this.find(v, list);
        if (toReplace != null) {
            list.remove(toReplace);
            Amount amount = toReplace.getAmount();
            ArrayList<EquationVariable> mRightSide1 = l.mRightSide;
            int mRightSide1Size = mRightSide1.size();
            for (int i = 0; i < mRightSide1Size; ++i) {
                EquationVariable lv = mRightSide1.get(i);
                list.add(new EquationVariable(amount, lv));
            }
        }
    }

    private EquationVariable find(SolverVariable v, ArrayList<EquationVariable> list) {
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            EquationVariable ev = list.get(i);
            if (ev.getSolverVariable() != v) continue;
            return ev;
        }
        return null;
    }

    public ArrayList<EquationVariable> getRightSide() {
        return this.mRightSide;
    }

    public boolean contains(SolverVariable solverVariable) {
        if (this.find(solverVariable, this.mLeftSide) != null) {
            return true;
        }
        return this.find(solverVariable, this.mRightSide) != null;
    }

    public EquationVariable getVariable(SolverVariable solverVariable) {
        EquationVariable variable = this.find(solverVariable, this.mRightSide);
        if (variable != null) {
            return variable;
        }
        return this.find(solverVariable, this.mLeftSide);
    }

    public LinearEquation var(int amount) {
        EquationVariable e = new EquationVariable(this.mSystem, amount);
        this.mCurrentSide.add(e);
        return this;
    }

    public LinearEquation var(int numerator, int denominator) {
        EquationVariable e = new EquationVariable(new Amount(numerator, denominator));
        this.mCurrentSide.add(e);
        return this;
    }

    public LinearEquation var(String name) {
        EquationVariable e = new EquationVariable(this.mSystem, name, SolverVariable.Type.UNRESTRICTED);
        this.mCurrentSide.add(e);
        return this;
    }

    public LinearEquation var(int amount, String name) {
        EquationVariable e = new EquationVariable(this.mSystem, amount, name, SolverVariable.Type.UNRESTRICTED);
        this.mCurrentSide.add(e);
        return this;
    }

    public LinearEquation var(int numerator, int denominator, String name) {
        Amount amount = new Amount(numerator, denominator);
        EquationVariable e = new EquationVariable(this.mSystem, amount, name, SolverVariable.Type.UNRESTRICTED);
        this.mCurrentSide.add(e);
        return this;
    }

    public LinearEquation plus(String name) {
        this.var(name);
        return this;
    }

    public LinearEquation plus(int amount, String name) {
        this.var(amount, name);
        return this;
    }

    public LinearEquation minus(String name) {
        this.var(-1, name);
        return this;
    }

    public LinearEquation minus(int amount, String name) {
        this.var(-1 * amount, name);
        return this;
    }

    public LinearEquation plus(int amount) {
        this.var(amount);
        return this;
    }

    public LinearEquation minus(int amount) {
        this.var(amount * -1);
        return this;
    }

    public LinearEquation plus(int numerator, int denominator) {
        this.var(numerator, denominator);
        return this;
    }

    public LinearEquation minus(int numerator, int denominator) {
        this.var(numerator * -1, denominator);
        return this;
    }

    public LinearEquation withError(String name, int strength) {
        EquationVariable e = new EquationVariable(this.mSystem, strength, name, SolverVariable.Type.ERROR);
        this.mCurrentSide.add(e);
        return this;
    }

    public LinearEquation withError(Amount amount, String name) {
        EquationVariable e = new EquationVariable(this.mSystem, amount, name, SolverVariable.Type.ERROR);
        this.mCurrentSide.add(e);
        return this;
    }

    public LinearEquation withError() {
        String name = LinearEquation.getNextErrorVariableName();
        this.withError(name + "+", 1);
        this.withError(name + "-", -1);
        return this;
    }

    public LinearEquation withPositiveError() {
        String name = LinearEquation.getNextErrorVariableName();
        this.withError(name + "+", 1);
        return this;
    }

    public LinearEquation withStrongError() {
        String name = LinearEquation.getNextErrorVariableName();
        EquationVariable e = new EquationVariable(this.mSystem, 1, name + "+", SolverVariable.Type.ERROR);
        e.getSolverVariable().setStrength(SolverVariable.Strength.STRONG);
        this.mCurrentSide.add(e);
        e = new EquationVariable(this.mSystem, -1, name + "-", SolverVariable.Type.ERROR);
        e.getSolverVariable().setStrength(SolverVariable.Strength.STRONG);
        this.mCurrentSide.add(e);
        return this;
    }

    public EquationVariable addArtificialVar() {
        EquationVariable e = new EquationVariable(this.mSystem, 1, LinearEquation.getNextArtificialVariableName(), SolverVariable.Type.ERROR);
        this.mCurrentSide.add(e);
        return e;
    }

    public LinearEquation withError(int strength) {
        this.withError(LinearEquation.getNextErrorVariableName(), strength);
        return this;
    }

    public LinearEquation withSlack(String name, int strength) {
        EquationVariable e = new EquationVariable(this.mSystem, strength, name, SolverVariable.Type.SLACK);
        this.mCurrentSide.add(e);
        return this;
    }

    public LinearEquation withSlack(Amount amount, String name) {
        EquationVariable e = new EquationVariable(this.mSystem, amount, name, SolverVariable.Type.SLACK);
        this.mCurrentSide.add(e);
        return this;
    }

    public LinearEquation withSlack() {
        this.withSlack(LinearEquation.getNextSlackVariableName(), 1);
        return this;
    }

    public LinearEquation withSlack(int strength) {
        this.withSlack(LinearEquation.getNextSlackVariableName(), strength);
        return this;
    }

    public String toString() {
        String result = "";
        result = this.sideToString(this.mLeftSide);
        switch (this.mType) {
            case EQUALS: {
                result = result + "= ";
                break;
            }
            case LOWER_THAN: {
                result = result + "<= ";
                break;
            }
            case GREATER_THAN: {
                result = result + ">= ";
            }
        }
        result = result + this.sideToString(this.mRightSide);
        return result.trim();
    }

    private String sideToString(ArrayList<EquationVariable> side) {
        String result = "";
        boolean first = true;
        int sideSize = side.size();
        for (int i = 0; i < sideSize; ++i) {
            EquationVariable v = side.get(i);
            if (first) {
                result = v.getAmount().isPositive() ? result + v + " " : result + v.signString() + " " + v + " ";
                first = false;
                continue;
            }
            result = result + v.signString() + " " + v + " ";
        }
        if (side.size() == 0) {
            result = "0";
        }
        return result;
    }

    private static enum Type {
        EQUALS,
        LOWER_THAN,
        GREATER_THAN;

    }
}

