/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver;

import android.support.constraint.solver.Amount;
import android.support.constraint.solver.LinearSystem;
import android.support.constraint.solver.SolverVariable;

class EquationVariable {
    private Amount mAmount = null;
    private SolverVariable mVariable = null;

    public EquationVariable(LinearSystem system, Amount amount, String name, SolverVariable.Type type) {
        this.mAmount = amount;
        this.mVariable = system.getVariable(name, type);
    }

    public EquationVariable(Amount amount) {
        this.mAmount = amount;
    }

    public EquationVariable(LinearSystem system, int amount, String name, SolverVariable.Type type) {
        this.mAmount = new Amount(amount);
        this.mVariable = system.getVariable(name, type);
    }

    public EquationVariable(LinearSystem system, int amount) {
        this.mAmount = new Amount(amount);
    }

    public EquationVariable(LinearSystem system, String name, SolverVariable.Type type) {
        this.mAmount = new Amount(1);
        this.mVariable = system.getVariable(name, type);
    }

    public EquationVariable(Amount amount, EquationVariable variable) {
        this.mAmount = new Amount(amount);
        this.mAmount.multiply(variable.mAmount);
        this.mVariable = variable.getSolverVariable();
    }

    public EquationVariable(EquationVariable v) {
        this.mAmount = new Amount(v.mAmount);
        this.mVariable = v.getSolverVariable();
    }

    public String getName() {
        if (this.mVariable == null) {
            return null;
        }
        return this.mVariable.getName();
    }

    public SolverVariable.Type getType() {
        if (this.mVariable == null) {
            return SolverVariable.Type.CONSTANT;
        }
        return this.mVariable.mType;
    }

    public SolverVariable getSolverVariable() {
        return this.mVariable;
    }

    public boolean isConstant() {
        return this.mVariable == null;
    }

    public Amount getAmount() {
        return this.mAmount;
    }

    public void setAmount(Amount amount) {
        this.mAmount = amount;
    }

    public EquationVariable inverse() {
        this.mAmount.inverse();
        return this;
    }

    public boolean isCompatible(EquationVariable variable) {
        if (this.isConstant()) {
            return variable.isConstant();
        }
        if (variable.isConstant()) {
            return false;
        }
        return variable.getSolverVariable() == this.getSolverVariable();
    }

    public void add(EquationVariable variable) {
        if (variable.isCompatible(this)) {
            this.mAmount.add(variable.mAmount);
        }
    }

    public void substract(EquationVariable variable) {
        if (variable.isCompatible(this)) {
            this.mAmount.substract(variable.mAmount);
        }
    }

    public void multiply(EquationVariable variable) {
        this.multiply(variable.getAmount());
    }

    public void multiply(Amount amount) {
        this.mAmount.multiply(amount);
    }

    public void divide(EquationVariable variable) {
        this.mAmount.divide(variable.mAmount);
    }

    public String toString() {
        if (this.isConstant()) {
            return "" + this.mAmount;
        }
        if (this.mAmount.isOne() || this.mAmount.isMinusOne()) {
            return "" + this.mVariable;
        }
        return "" + this.mAmount + " " + this.mVariable;
    }

    public String signString() {
        if (this.mAmount.isPositive()) {
            return "+";
        }
        return "-";
    }
}

