/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import javax.swing.JTextField;

public class UiUtil {
    public static void setupDirectoryPicker(TextFieldWithBrowseButton component, String title, String description, Project project, TextComponentAccessor<JTextField> textAccessor) {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        component.addBrowseFolderListener(title, description, project, fileChooserDescriptor, textAccessor);
        UiUtil.installPathCompletion(component.getTextField(), fileChooserDescriptor);
    }

    private static void installPathCompletion(JTextField textField, FileChooserDescriptor fileChooserDescriptor) {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        FileChooserFactory.getInstance().installFileCompletion(textField, fileChooserDescriptor, true, null);
    }
}

