/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.shell;

import com.intellij.dmserver.deploy.jmx.ConnectorExecuteCommand;
import com.intellij.dmserver.run.DMServerInstance;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.management.InstanceNotFoundException;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;

public class DmShellToolWindowPanel
extends SimpleToolWindowPanel
implements Disposable {
    private static final int POLL_MSEC = 2000;
    private final Project myProject;
    private final DMServerInstance myServerInstance;

    public DmShellToolWindowPanel(Project project, DMServerInstance serverInstance) {
        super(false);
        this.myProject = project;
        this.myServerInstance = serverInstance;
        this.createContent();
    }

    public DMServerInstance getServerInstance() {
        return this.myServerInstance;
    }

    private void createContent() {
        this.setBorder((Border)new ToolWindow.Border(true, false, false, false));
        this.setContent(this.createServerConsole(this.myServerInstance));
    }

    private JComponent createServerConsole(DMServerInstance serverInstance) {
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject);
        ConsoleView consoleView = builder.getConsole();
        ServerHandler processHandler = new ServerHandler(serverInstance);
        consoleView.attachToProcess((ProcessHandler)processHandler);
        processHandler.startNotify();
        return consoleView.getComponent();
    }

    public void dispose() {
    }

    private class ServerHandler
    extends ProcessHandler {
        @NonNls
        private final String CRLF = System.getProperty("line.separator");
        private final Object myMutex = new Object();
        private LinkedList<String> myQueuedCommands = null;
        private final OutputStream myOut;
        private final DMServerInstance myServerInstance;

        public ServerHandler(DMServerInstance serverInstance) {
            this.myServerInstance = serverInstance;
            this.myOut = new ByteArrayOutputStream(){

                @Override
                public void flush() throws IOException {
                    super.flush();
                    String inputText = this.toString();
                    ServerHandler.this.processCommand(inputText);
                    super.reset();
                }
            };
        }

        protected void destroyProcessImpl() {
        }

        public boolean detachIsDefault() {
            return false;
        }

        protected void detachProcessImpl() {
        }

        public OutputStream getProcessInput() {
            return this.myOut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processCommand(String commandText) {
            String trimmedCommandText = commandText.trim();
            if ("".equals(trimmedCommandText)) {
                this.printInvitation();
                return;
            }
            Object object = this.myMutex;
            synchronized (object) {
                if (this.myQueuedCommands != null) {
                    this.myQueuedCommands.addLast(trimmedCommandText);
                } else if (!new CommandProcessor(trimmedCommandText, false).doProcessCommand()) {
                    this.notifyTextAvailable(DmServerBundle.message("DmShellToolWindowPanel.ServerHandler.message.not-ready", new Object[0]) + this.CRLF, ProcessOutputTypes.SYSTEM);
                    this.myQueuedCommands = new LinkedList();
                    this.myQueuedCommands.add(trimmedCommandText);
                    Thread pollingThread = new Thread(new Runnable(){

                        /*
                         * Exception decompiling
                         */
                        @Override
                        public void run() {
                            /*
                             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                             * 
                             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[DOLOOP]], but top level block is 1[TRYBLOCK]
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                             *     at org.benf.cfr.reader.Main.main(Main.java:54)
                             */
                            throw new IllegalStateException("Decompilation failed");
                        }
                    }, "DM polling");
                    pollingThread.start();
                }
                this.printInvitation();
            }
        }

        private void printInvitation() {
            this.notifyTextAvailable(this.CRLF + DmServerBundle.message("DmShellToolWindowPanel.ServerHandler.invitation", new Object[0]) + " ", ProcessOutputTypes.SYSTEM);
        }

        public void startNotify() {
            super.startNotify();
            this.printInvitation();
        }

        static /* synthetic */ Object access$100(ServerHandler x0) {
            return x0.myMutex;
        }

        static /* synthetic */ LinkedList access$200(ServerHandler x0) {
            return x0.myQueuedCommands;
        }

        static /* synthetic */ LinkedList access$202(ServerHandler x0, LinkedList x1) {
            x0.myQueuedCommands = x1;
            return x0.myQueuedCommands;
        }

        private class CommandProcessor {
            private final String myCommandText;
            private final boolean myQueued;

            public CommandProcessor(String commandText, boolean queued) {
                this.myCommandText = commandText;
                this.myQueued = queued;
            }

            public boolean doProcessCommand() {
                try {
                    ConnectorExecuteCommand jmxCommand = new ConnectorExecuteCommand(ServerHandler.this.myServerInstance, this.myCommandText);
                    String response = (String)jmxCommand.execute();
                    this.printResponse(response, ProcessOutputTypes.STDOUT);
                }
                catch (TimeoutException e) {
                    this.printResponse(DmServerBundle.message("DmShellToolWindowPanel.CommandProcessor.error.timeout", new Object[0]), ProcessOutputTypes.STDERR);
                }
                catch (ExecutionException e) {
                    Throwable t = e;
                    while (t.getCause() != null) {
                        if (t.getCause() instanceof InstanceNotFoundException) {
                            return false;
                        }
                        t = t.getCause();
                    }
                    this.printResponse(DmServerBundle.message("DmShellToolWindowPanel.CommandProcessor.error.execution-error", new Object[0]), ProcessOutputTypes.STDERR);
                }
                return true;
            }

            private void printResponse(String text, Key outputType) {
                if (this.myQueued) {
                    ServerHandler.this.printInvitation();
                    ServerHandler.this.notifyTextAvailable(this.myCommandText + ServerHandler.this.CRLF, ProcessOutputTypes.SYSTEM);
                }
                if (text != null) {
                    ServerHandler.this.notifyTextAvailable(text, outputType);
                }
            }
        }
    }
}

