/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.run;

import com.intellij.dmserver.deploy.DeploymentIdentity;
import com.intellij.dmserver.install.ServerVersionHandler;
import com.intellij.dmserver.run.DMServerModelBase;
import com.intellij.dmserver.shell.DmShellToolWindowFactory;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.server.JavaeeServerConnector;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.containers.hash.HashMap;
import icons.DmServerSupportIcons;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMServerInstance
extends JavaeeServerConnector {
    @NonNls
    private static final String TOOL_WINDOW_ID = "DM Shell";
    private final ServerVersionHandler myVersionHandler;
    private final Map<DeploymentModel, DeploymentIdentity> myDeploymentModel2Identity = new HashMap();

    public DMServerInstance(CommonModel commonModel, ServerVersionHandler versionHandler) {
        super(commonModel);
        this.myVersionHandler = versionHandler;
    }

    @NotNull
    public DMServerModelBase getServerModel() {
        DMServerModelBase dMServerModelBase = (DMServerModelBase)super.getServerModel();
        if (dMServerModelBase == null) {
            DMServerInstance.$$$reportNull$$$0(0);
        }
        return dMServerModelBase;
    }

    public void start(ProcessHandler processHandler) {
        super.start(processHandler);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private final ToolWindowManager myToolWindowManager;
            {
                this.myToolWindowManager = ToolWindowManager.getInstance((Project)DMServerInstance.this.getCommonModel().getProject());
            }

            @Nullable
            private ToolWindow getShellToolWindow(boolean force) {
                ToolWindow window = this.myToolWindowManager.getToolWindow(DMServerInstance.TOOL_WINDOW_ID);
                if (window == null && force) {
                    window = this.myToolWindowManager.registerToolWindow(DMServerInstance.TOOL_WINDOW_ID, false, ToolWindowAnchor.RIGHT);
                    window.setIcon(DmServerSupportIcons.DM);
                    window.setAvailable(false, null);
                }
                return window;
            }

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> DmShellToolWindowFactory.addServer(DMServerInstance.this.getCommonModel(), this.getShellToolWindow(true), DMServerInstance.this));
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (DMServerInstance.this.getCommonModel().getProject().isDisposed()) {
                        return;
                    }
                    ToolWindow window = this.getShellToolWindow(false);
                    if (window != null) {
                        DmShellToolWindowFactory.removeServer(window, DMServerInstance.this);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/dmserver/run/DMServerInstance$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected boolean doConnect() {
        try {
            return this.myVersionHandler.pingServerInstance(this);
        }
        catch (TimeoutException e) {
            return false;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    protected void doDisconnect() {
    }

    public boolean addToRepository(List<VirtualFile> filesToDeploy) {
        return this.getServerModel().addToRepository(filesToDeploy);
    }

    public boolean removeFromRepository(List<VirtualFile> filesToUndeploy) {
        return this.getServerModel().removeFromRepository(filesToUndeploy);
    }

    @Nullable
    public String getRepositoryName() {
        return this.getServerModel().getRepositoryName();
    }

    public ServerVersionHandler getVersionHandler() {
        return this.myVersionHandler;
    }

    public void registerDeployment(DeploymentModel model, DeploymentIdentity identity) {
        this.myDeploymentModel2Identity.put(model, identity);
    }

    public DeploymentIdentity findRegisteredDeployment(DeploymentModel model) {
        return this.myDeploymentModel2Identity.get(model);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/run/DMServerInstance", "getServerModel"));
    }
}

