/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.osmorc;

import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.install.DMServerInstallationManager;
import com.intellij.dmserver.osmorc.DMServerFrameworkIntegrator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.settings.ApplicationSettings;
import org.osmorc.settings.ProjectSettings;

public class FrameworkUtils {
    private static final FrameworkUtils ourInstance = new FrameworkUtils();

    private FrameworkUtils() {
    }

    public static FrameworkUtils getInstance() {
        return ourInstance;
    }

    public FrameworkInstanceManager getFrameworkInstanceManager(FrameworkInstanceDefinition instanceDefinition) {
        FrameworkIntegratorRegistry registry = (FrameworkIntegratorRegistry)ServiceManager.getService(FrameworkIntegratorRegistry.class);
        FrameworkIntegrator frameworkIntegrator = registry.findIntegratorByInstanceDefinition(instanceDefinition);
        return frameworkIntegrator.getFrameworkInstanceManager();
    }

    @Nullable
    public FrameworkInstanceDefinition getActiveFrameworkInstance(Project project) {
        ApplicationSettings applicationSettings = (ApplicationSettings)ServiceManager.getService(ApplicationSettings.class);
        ProjectSettings projectSettings = (ProjectSettings)ServiceManager.getService((Project)project, ProjectSettings.class);
        return applicationSettings.getFrameworkInstance(projectSettings.getFrameworkInstanceName());
    }

    @Nullable
    public DMServerInstallation getActiveDMServerInstallation(Project project) {
        return this.getDMServerInstallation(FrameworkUtils.getInstance().getActiveFrameworkInstance(project));
    }

    @Nullable
    public DMServerInstallation getDMServerInstallation(FrameworkInstanceDefinition framework) {
        if (!DMServerFrameworkIntegrator.isCompatibleInstance(framework)) {
            return null;
        }
        DMServerInstallationManager installationManager = DMServerInstallationManager.getInstance();
        DMServerInstallation result = installationManager.findInstallation(framework);
        return result != null && result.isValid() ? result : null;
    }

    public void setActiveFrameworkInstance(Project project, FrameworkInstanceDefinition framework) {
        ProjectSettings projectSettings = (ProjectSettings)ServiceManager.getService((Project)project, ProjectSettings.class);
        projectSettings.setFrameworkInstanceName(framework == null ? null : framework.getName());
    }
}

