/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries;

import com.intellij.dmserver.libraries.BundleDefinition;
import com.intellij.dmserver.util.ManifestUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.jetbrains.lang.manifest.psi.ManifestToken;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;
import org.osmorc.manifest.lang.psi.Attribute;
import org.osmorc.manifest.lang.psi.Clause;

public class LibraryDefinition {
    private final VirtualFile myLibraryDefFile;
    private final String mySymbolicName;
    private final String myVersion;
    private final List<BundleDefinition> myBundleDefs;
    private final List<Clause> myUnparsableClauses;
    @NonNls
    private static final String HEADER_LIBRARY_SYMBOLIC_NAME = "Library-SymbolicName";
    @NonNls
    private static final String HEADER_LIBRARY_VERSION = "Library-Version";
    @NonNls
    private static final String HEADER_IMPORT_BUNDLE = "Import-Bundle";

    @Nullable
    public static LibraryDefinition load(Project project, VirtualFile libraryDef) {
        PsiFile libraryPsi = PsiManager.getInstance((Project)project).findFile(libraryDef);
        String symbolicName = ManifestUtils.getInstance().getHeaderValue(libraryPsi, HEADER_LIBRARY_SYMBOLIC_NAME);
        if (symbolicName == null) {
            return null;
        }
        String version = ManifestUtils.getInstance().getHeaderValue(libraryPsi, HEADER_LIBRARY_VERSION);
        if (version == null) {
            return null;
        }
        Header importBundleHeader = ManifestUtils.getInstance().findHeader(libraryPsi, HEADER_IMPORT_BUNDLE);
        if (importBundleHeader == null) {
            return null;
        }
        ArrayList<BundleDefinition> bundleDefs = new ArrayList<BundleDefinition>();
        ArrayList<Clause> unparsableClauses = new ArrayList<Clause>();
        for (Clause bundleClause : (Clause[])PsiTreeUtil.getChildrenOfType((PsiElement)importBundleHeader, Clause.class)) {
            BundleDefinition bundleDefintion = LibraryDefinition.parseBundleClause(bundleClause);
            if (bundleDefintion == null) {
                unparsableClauses.add(bundleClause);
                continue;
            }
            bundleDefs.add(bundleDefintion);
        }
        return new LibraryDefinition(libraryDef, symbolicName, version, bundleDefs, unparsableClauses);
    }

    public LibraryDefinition(VirtualFile libraryDefFile, String symbolicName, String version, List<BundleDefinition> bundleDefs, List<Clause> unparsableClauses) {
        this.myLibraryDefFile = libraryDefFile;
        this.mySymbolicName = symbolicName;
        this.myVersion = version;
        this.myBundleDefs = bundleDefs;
        this.myUnparsableClauses = unparsableClauses;
    }

    public VirtualFile getLibDefFile() {
        return this.myLibraryDefFile;
    }

    private static BundleDefinition parseBundleClause(Clause bundleClause) {
        HeaderValuePart bundleNamePart = (HeaderValuePart)PsiTreeUtil.getChildOfType((PsiElement)bundleClause, HeaderValuePart.class);
        if (bundleNamePart == null) {
            return null;
        }
        Attribute[] bundleAttributes = (Attribute[])PsiTreeUtil.getChildrenOfType((PsiElement)bundleClause, Attribute.class);
        String bundleVersion = null;
        for (Attribute bundleAttribute : bundleAttributes) {
            if (!"version".equals(bundleAttribute.getNameElement().getUnwrappedText())) continue;
            boolean hasOpeningBracket = false;
            boolean hasClosingBracket = false;
            String leftBound = null;
            String rightBound = null;
            for (ManifestToken token : (ManifestToken[])PsiTreeUtil.getChildrenOfType((PsiElement)bundleAttribute.getValueElement(), ManifestToken.class)) {
                ManifestTokenType tokenType = token.getTokenType();
                if (tokenType == ManifestTokenType.OPENING_BRACKET_TOKEN) {
                    if (!"[".equals(token.getText()) || leftBound != null) continue;
                    hasOpeningBracket = true;
                    continue;
                }
                if (tokenType == ManifestTokenType.CLOSING_BRACKET_TOKEN) {
                    if (!"]".equals(token.getText()) || rightBound == null) continue;
                    hasClosingBracket = true;
                    continue;
                }
                if (tokenType != ManifestTokenType.HEADER_VALUE_PART) continue;
                if (leftBound == null) {
                    leftBound = token.getText().trim();
                    if (!leftBound.startsWith("[")) continue;
                    leftBound = leftBound.substring(1);
                    hasOpeningBracket = true;
                    continue;
                }
                if (rightBound == null) {
                    rightBound = token.getText().trim();
                    if (!rightBound.endsWith("]")) continue;
                    rightBound = rightBound.substring(0, rightBound.length() - 1);
                    hasClosingBracket = true;
                    continue;
                }
                return null;
            }
            if (!hasOpeningBracket || !hasClosingBracket) {
                return null;
            }
            if (leftBound == null || rightBound == null) {
                return null;
            }
            if (!leftBound.equals(rightBound)) {
                return null;
            }
            bundleVersion = leftBound;
            break;
        }
        if (bundleVersion == null) {
            return null;
        }
        return new BundleDefinition(bundleNamePart.getUnwrappedText(), bundleVersion);
    }

    public String getSymbolicName() {
        return this.mySymbolicName;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public List<BundleDefinition> getBundleDefs() {
        return this.myBundleDefs;
    }

    public List<Clause> getUnparsableClauses() {
        return this.myUnparsableClauses;
    }
}

