/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.integration;

import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.integration.DMServerIntegrationData;
import com.intellij.dmserver.integration.DMServerIntegrationEditor;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.javaee.appServerIntegrations.ApplicationServerHelper;
import com.intellij.javaee.appServerIntegrations.ApplicationServerInfo;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.javaee.appServerIntegrations.CantFindApplicationServerJarsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;

public class DMServerHelper
implements ApplicationServerHelper {
    public ApplicationServerInfo getApplicationServerInfo(ApplicationServerPersistentData applicationServerPersistentData) throws CantFindApplicationServerJarsException {
        DMServerIntegrationData persistentDataImpl = (DMServerIntegrationData)applicationServerPersistentData;
        DMServerInstallation installation = persistentDataImpl.getInstallation();
        if (installation == null) {
            throw new CantFindApplicationServerJarsException("Can't find dmServer home");
        }
        return DMServerHelper.createApplicationServerInfo(installation);
    }

    public static ApplicationServerInfo createApplicationServerInfo(DMServerInstallation installation) {
        String defaultName = DmServerBundle.message("DMServerHelper.server.info.default.name", installation.getVersionName());
        return new ApplicationServerInfo(DMServerHelper.unwrapVirtualFiles(installation.getSharedLibraries()), defaultName);
    }

    public ApplicationServerPersistentData createPersistentDataEmptyInstance() {
        return new DMServerIntegrationData("");
    }

    public ApplicationServerPersistentDataEditor createConfigurable() {
        return new DMServerIntegrationEditor();
    }

    private static File[] unwrapVirtualFiles(VirtualFile[] vFiles) {
        File[] result = new File[vFiles.length];
        for (int i = 0; i < vFiles.length; ++i) {
            result[i] = VfsUtil.virtualToIoFile((VirtualFile)vFiles[i]);
        }
        return result;
    }
}

