/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.install.impl;

import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.install.DMServerInstallationManager;
import com.intellij.dmserver.install.impl.DMServerInstallationImpl;
import com.intellij.dmserver.integration.DMServerIntegration;
import com.intellij.dmserver.integration.DMServerIntegrationData;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.j2ee.appServerIntegrations.impl.ApplicationServersManagerAdapter;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.javaee.serverInstances.ApplicationServersManagerListener;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.settings.ApplicationSettings;

public class DMServerInstallationManagerImpl
extends DMServerInstallationManager {
    private final Map<String, DMServerInstallation> myInstallations = new THashMap();
    private final ApplicationSettings myApplicationSettings;

    public DMServerInstallationManagerImpl(ApplicationSettings applicationSettings, ApplicationServersManager serversManager) {
        this.myApplicationSettings = applicationSettings;
        serversManager.addServersListener((ApplicationServersManagerListener)new ApplicationServersManagerAdapter(){

            public void serverAdded(@NotNull ApplicationServer server) {
                AppServerIntegration sourceIntegration;
                if (server == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((sourceIntegration = server.getSourceIntegration()) != null && sourceIntegration instanceof DMServerIntegration) {
                    DMServerInstallationManagerImpl.this.findFramework(((DMServerIntegration)sourceIntegration).getServerInstallation(server));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/dmserver/install/impl/DMServerInstallationManagerImpl$1", "serverAdded"));
            }
        });
    }

    @Override
    @NotNull
    public List<? extends DMServerInstallation> getValidInstallations() {
        List servers = ApplicationServersManager.getInstance().getApplicationServers(new AppServerIntegration[]{DMServerIntegration.getInstance()});
        ArrayList<DMServerInstallation> result = new ArrayList<DMServerInstallation>();
        for (ApplicationServer next : servers) {
            DMServerInstallation nextInstall = ((DMServerIntegrationData)next.getPersistentData()).getInstallation();
            if (nextInstall == null || !nextInstall.isValid()) continue;
            result.add(nextInstall);
        }
        ArrayList<DMServerInstallation> arrayList = result;
        if (arrayList == null) {
            DMServerInstallationManagerImpl.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public DMServerInstallation findInstallation(VirtualFile home) {
        String homePath = FileUtil.toSystemIndependentName((String)home.getPath());
        DMServerInstallation result = this.myInstallations.get(homePath);
        if (result == null) {
            result = new DMServerInstallationImpl(home);
            this.myInstallations.put(homePath, result);
        }
        DMServerInstallation dMServerInstallation = result;
        if (dMServerInstallation == null) {
            DMServerInstallationManagerImpl.$$$reportNull$$$0(1);
        }
        return dMServerInstallation;
    }

    @Override
    public FrameworkInstanceDefinition findFramework(DMServerInstallation installation) {
        return this.findFramework(installation, true);
    }

    @Override
    public FrameworkInstanceDefinition findFramework(DMServerInstallation installation, boolean create) {
        if (installation == null || !installation.isValid()) {
            return null;
        }
        for (FrameworkInstanceDefinition framework : this.myApplicationSettings.getFrameworkInstanceDefinitions()) {
            VirtualFile frameworkHome;
            if (!"dmServer".equals(framework.getFrameworkIntegratorName()) || (frameworkHome = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)framework.getBaseFolder()))) == null || !frameworkHome.getPath().equals(installation.getHome().getPath())) continue;
            return framework;
        }
        if (!create) {
            return null;
        }
        FrameworkInstanceDefinition newFramework = new FrameworkInstanceDefinition();
        UniqueNameGenerator generator = new UniqueNameGenerator((Collection)this.myApplicationSettings.getFrameworkInstanceDefinitions(), (Function)((NullableFunction)o -> DMServerInstallationManagerImpl.createFrameworkName(o.getName())));
        newFramework.setName(generator.generateUniqueName(DMServerInstallationManagerImpl.createFrameworkName(installation.getOrCreateApplicationServer().getName())));
        newFramework.setFrameworkIntegratorName("dmServer");
        newFramework.setBaseFolder(FileUtil.toSystemDependentName((String)installation.getHome().getPath()));
        this.myApplicationSettings.getFrameworkInstanceDefinitions().add(newFramework);
        return newFramework;
    }

    private static String createFrameworkName(String basicName) {
        return DmServerBundle.message("DMServerInstallationManagerImpl.framework.name", basicName);
    }

    @Override
    @Nullable
    public DMServerInstallation findInstallation(@NotNull String homePath) {
        VirtualFile home;
        if (homePath == null) {
            DMServerInstallationManagerImpl.$$$reportNull$$$0(2);
        }
        return (home = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)homePath))) == null ? null : this.findInstallation(home);
    }

    @Override
    @Nullable
    public DMServerInstallation findInstallation(FrameworkInstanceDefinition framework) {
        return this.findInstallation(framework.getBaseFolder());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dmserver/install/impl/DMServerInstallationManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidInstallations";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findInstallation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dmserver/install/impl/DMServerInstallationManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findInstallation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

