/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.install.impl;

import com.intellij.dmserver.install.impl.ConfigElementWrapper;
import com.intellij.dmserver.install.impl.DMServerConfigSupportBase;
import com.intellij.dmserver.install.impl.JsonUtil;
import com.intellij.dmserver.integration.DMServerIntegrationData;
import com.intellij.dmserver.integration.DMServerRepositoryItem;
import com.intellij.dmserver.integration.DMServerRepositoryItem10;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.NonNls;

public class DMServerConfigSupport10
extends DMServerConfigSupportBase {
    private static final Logger LOG = Logger.getInstance(DMServerConfigSupport10.class);
    @NonNls
    private static final List<String> DEFAULT_REPOSITORY_PATHS = Arrays.asList("repository/bundles/subsystems/{name}/{bundle}.jar", "repository/bundles/ext/{bundle}", "repository/bundles/usr/{bundle}", "repository/libraries/ext/{library}", "repository/libraries/usr/{library}");
    private static final ConfigElement<?>[] ourServerConfigElements = new ConfigElement[]{new ObjectConfigElement("serviceability", new ConfigElement[]{new ObjectConfigElement("dump", new ConfigElement[]{new StringConfigElement("directory", ourDumpsFolderWrapper)})}), new ObjectConfigElement("osgiConsole", new ConfigElement[]{new BooleanConfigElement("enabled", ourShellEnabledWrapper), new IntegerConfigElement("port", ourShellPortWrapper)}), new StringConfigElement("pickupDirectory", ourPickupFolderWrapper), new ObjectConfigElement("provisioning", new ConfigElement[]{new RepositoryConfigElement("searchPaths")})};
    private static final ConfigElement<?>[] ourDeployerConfigElements = new ConfigElement[]{new ObjectConfigElement("deployer", new ConfigElement[]{new IntegerConfigElement("deploymentTimeoutSeconds", ourDeploymentTimeoutSecsWrapper)})};
    private final VirtualFile myServerConfigFile;
    private final VirtualFile myDeployerConfigFile;

    public DMServerConfigSupport10(VirtualFile home) {
        this.myServerConfigFile = home.findFileByRelativePath("config/server.config");
        this.myDeployerConfigFile = home.findFileByRelativePath("config/deployer.config");
    }

    @Override
    protected List<VirtualFile> getFiles() {
        return Arrays.asList(this.myServerConfigFile, this.myDeployerConfigFile);
    }

    @Override
    public void readFromServer(DMServerIntegrationData data) {
        try {
            this.myServerConfigFile.refresh(false, false);
            JSONObject serverConfig = JsonUtil.loadConfig(this.myServerConfigFile);
            for (ConfigElement<?> element : ourServerConfigElements) {
                element.load(serverConfig, data);
            }
            this.myDeployerConfigFile.refresh(false, false);
            JSONObject deployerConfig = JsonUtil.loadConfig(this.myDeployerConfigFile);
            for (ConfigElement<?> element : ourDeployerConfigElements) {
                element.load(deployerConfig, data);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        catch (JSONException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void writeToServer(DMServerIntegrationData data) {
        try {
            JSONObject serverConfig = JsonUtil.loadConfig(this.myServerConfigFile);
            for (ConfigElement<?> element : ourServerConfigElements) {
                element.save(serverConfig, data);
            }
            JsonUtil.saveConfig(this.myServerConfigFile, serverConfig);
            JSONObject deployerConfig = JsonUtil.loadConfig(this.myDeployerConfigFile);
            for (ConfigElement<?> element : ourDeployerConfigElements) {
                element.save(deployerConfig, data);
            }
            JsonUtil.saveConfig(this.myDeployerConfigFile, deployerConfig);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        catch (JSONException e) {
            LOG.error((Throwable)e);
        }
    }

    private static class StringConfigElement
    extends PrimitiveConfigElement<String> {
        public StringConfigElement(@NonNls String elementName, ConfigElementWrapper<String> elementWrapper) {
            super(elementName, elementWrapper);
        }

        @Override
        protected String loadValue(JSONObject source) throws JSONException {
            return source.getString(this.getElementName());
        }
    }

    private static class IntegerConfigElement
    extends PrimitiveConfigElement<Integer> {
        public IntegerConfigElement(@NonNls String elementName, ConfigElementWrapper<Integer> elementWrapper) {
            super(elementName, elementWrapper);
        }

        @Override
        protected Integer loadValue(JSONObject source) throws JSONException {
            return source.getInt(this.getElementName());
        }
    }

    private static class BooleanConfigElement
    extends PrimitiveConfigElement<Boolean> {
        public BooleanConfigElement(@NonNls String elementName, ConfigElementWrapper<Boolean> elementWrapper) {
            super(elementName, elementWrapper);
        }

        @Override
        protected Boolean loadValue(JSONObject source) throws JSONException {
            return source.getBoolean(this.getElementName());
        }
    }

    private static abstract class PrimitiveConfigElement<T>
    extends ConfigElement<T> {
        private final ConfigElementWrapper<T> myElementWrapper;

        public PrimitiveConfigElement(@NonNls String elementName, ConfigElementWrapper<T> elementWrapper) {
            super(elementName);
            this.myElementWrapper = elementWrapper;
        }

        @Override
        public void save(JSONObject target, DMServerIntegrationData data) throws JSONException {
            target.put(this.getElementName(), this.getValue(data));
        }

        private T getValue(DMServerIntegrationData data) {
            return this.myElementWrapper.getValue(data);
        }

        @Override
        protected void setValue(DMServerIntegrationData data, T value) throws JSONException {
            if (value != null) {
                this.myElementWrapper.setValue(data, value);
            }
        }
    }

    private static class RepositoryConfigElement
    extends ConfigElement<JSONArray> {
        public RepositoryConfigElement(@NonNls String elementName) {
            super(elementName);
        }

        @Override
        public void save(JSONObject target, DMServerIntegrationData data) throws JSONException {
            target.put(this.getElementName(), (Object)RepositoryConfigElement.getValue(data));
        }

        @Override
        protected JSONArray loadValue(JSONObject source) throws JSONException {
            return source.getJSONArray(this.getElementName());
        }

        private static JSONArray getValue(DMServerIntegrationData data) {
            ArrayList<String> paths = new ArrayList<String>();
            for (DMServerRepositoryItem item : data.getRepositoryItems()) {
                if (!(item instanceof DMServerRepositoryItem10)) continue;
                DMServerRepositoryItem10 item10 = (DMServerRepositoryItem10)item;
                paths.add(item10.getPath());
            }
            return new JSONArray(paths);
        }

        @Override
        protected void setValue(DMServerIntegrationData data, JSONArray value) throws JSONException {
            if (value == null) {
                ArrayList<DMServerRepositoryItem> items = new ArrayList<DMServerRepositoryItem>();
                for (String path : DEFAULT_REPOSITORY_PATHS) {
                    DMServerRepositoryItem10 item = new DMServerRepositoryItem10();
                    item.setPath(path);
                    items.add(item);
                }
                data.setRepositoryItems(items);
            } else {
                ArrayList<DMServerRepositoryItem> items = new ArrayList<DMServerRepositoryItem>();
                for (int i = 0; i < value.length(); ++i) {
                    DMServerRepositoryItem10 item = new DMServerRepositoryItem10();
                    item.setPath(value.getString(i));
                    items.add(item);
                }
                data.setRepositoryItems(items);
            }
        }
    }

    private static class ObjectConfigElement
    extends ConfigElement<JSONObject> {
        private final ConfigElement<?>[] myChildren;

        public ObjectConfigElement(@NonNls String elementName, ConfigElement<?>[] children) {
            super(elementName);
            this.myChildren = children;
        }

        @Override
        protected JSONObject loadValue(JSONObject source) throws JSONException {
            return source.getJSONObject(this.getElementName());
        }

        @Override
        public void save(JSONObject target, DMServerIntegrationData data) throws JSONException {
            JSONObject childTarget;
            if (target.has(this.getElementName())) {
                childTarget = target.getJSONObject(this.getElementName());
            } else {
                childTarget = new JSONObject();
                target.put(this.getElementName(), (Object)childTarget);
            }
            for (ConfigElement<?> child : this.myChildren) {
                child.save(childTarget, data);
            }
        }

        @Override
        protected void setValue(DMServerIntegrationData data, JSONObject value) throws JSONException {
            for (ConfigElement<?> child : this.myChildren) {
                child.load(value, data);
            }
        }
    }

    private static abstract class ConfigElement<T> {
        private final String myElementName;

        public ConfigElement(@NonNls String elementName) {
            this.myElementName = elementName;
        }

        protected final String getElementName() {
            return this.myElementName;
        }

        public void load(JSONObject source, DMServerIntegrationData data) throws JSONException {
            boolean hasValue = source != null && source.has(this.getElementName());
            this.setValue(data, hasValue ? (T)this.loadValue(source) : null);
        }

        public abstract void save(JSONObject var1, DMServerIntegrationData var2) throws JSONException;

        protected abstract T loadValue(JSONObject var1) throws JSONException;

        protected abstract void setValue(DMServerIntegrationData var1, T var2) throws JSONException;
    }
}

