/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.util.VersionUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.annotations.Transient;

public class NestedUnitIdentity
implements Comparable<NestedUnitIdentity> {
    private static final Logger LOG = Logger.getInstance(NestedUnitIdentity.class);
    private String myVersionRange;
    private String myModuleName;
    private ModulePointer myModulePointer;

    public NestedUnitIdentity() {
    }

    public NestedUnitIdentity(Module module) {
        this.setModule(module);
        this.setVersionRange(VersionUtils.emptyRange.toString());
    }

    @Transient
    public void init(Project project) {
        if (this.myModulePointer == null) {
            if (this.myModuleName == null) {
                LOG.error("Either module name or module pointer should be set before calling the init");
                return;
            }
            this.myModulePointer = ModulePointerManager.getInstance((Project)project).create(this.myModuleName);
        }
    }

    public String getModuleName() {
        return this.myModulePointer == null ? this.myModuleName : this.myModulePointer.getModuleName();
    }

    public void setModuleName(String moduleName) {
        this.myModuleName = moduleName;
    }

    public String getVersionRange() {
        return this.myVersionRange == null ? VersionUtils.emptyRange.toString() : this.myVersionRange;
    }

    public void setVersionRange(String versionRange) {
        this.myVersionRange = versionRange;
    }

    @Override
    public int compareTo(NestedUnitIdentity o) {
        return this.getModuleName().compareTo(o.getModuleName());
    }

    @Transient
    public Module getModule() {
        return this.myModulePointer.getModule();
    }

    @Transient
    public void setModule(Module module) {
        this.myModulePointer = ModulePointerManager.getInstance((Project)module.getProject()).create(module);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NestedUnitIdentity)) {
            return false;
        }
        NestedUnitIdentity asInstance = (NestedUnitIdentity)obj;
        return this.getModule() == asInstance.getModule() && this.getVersionRange().equals(asInstance.getVersionRange());
    }

    public NestedUnitIdentity clone() {
        NestedUnitIdentity result = new NestedUnitIdentity();
        result.setModule(this.getModule());
        result.setVersionRange(this.getVersionRange());
        return result;
    }
}

