/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.facet.DMFacetBase;
import com.intellij.dmserver.facet.DMFacetConfigurationBase;
import com.intellij.dmserver.facet.DMModuleFacetSettingsPanel;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class DMFacetEditorBase<T extends DMFacetBase<C>, C extends DMFacetConfigurationBase<C>>
extends FacetEditorTab
implements Disposable {
    private final FacetEditorContext myFacetEditorContext;
    private final C myFacetConfiguration;
    private final DMModuleFacetSettingsPanel<C> mySettingsPanel;

    public DMFacetEditorBase(FacetEditorContext facetEditorContext, C facetConfiguration, DMModuleFacetSettingsPanel<C> settingsPanel) {
        this.myFacetEditorContext = facetEditorContext;
        this.myFacetConfiguration = facetConfiguration;
        this.mySettingsPanel = settingsPanel;
        this.mySettingsPanel.init(facetEditorContext.getProject(), facetEditorContext.getModule(), facetEditorContext.getModulesProvider(), this);
    }

    protected final FacetEditorContext getFacetEditorContext() {
        return this.myFacetEditorContext;
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.mySettingsPanel.getMainPanel();
        if (jPanel == null) {
            DMFacetEditorBase.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    public void apply() throws ConfigurationException {
        this.mySettingsPanel.apply(this.myFacetConfiguration);
        DMFacetBase facet = (DMFacetBase)this.myFacetEditorContext.getFacet();
        facet.getCommonPart().fireFacetChanged();
        facet.updateSupportWithArtifact(this.myFacetEditorContext.getModifiableRootModel(), this.myFacetEditorContext.getModulesProvider());
    }

    public boolean isModified() {
        C uiConfiguration = this.createFacetConfiguration();
        this.mySettingsPanel.save(uiConfiguration);
        return !((DMFacetConfigurationBase)this.myFacetConfiguration).equals(uiConfiguration);
    }

    public void reset() {
        this.mySettingsPanel.load(this.myFacetConfiguration);
    }

    protected abstract C createFacetConfiguration();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/facet/DMFacetEditorBase", "createComponent"));
    }
}

