/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.facet.DMBundleFacetEditor;
import com.intellij.dmserver.facet.DMFacetConfigurationBase;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.util.xmlb.annotations.Tag;

public class DMBundleFacetConfiguration
extends DMFacetConfigurationBase<DMBundleFacetConfiguration> {
    private boolean myIsDynamicModules = false;
    private boolean myIsWebModule = false;
    private String myWebFrameworkVersionName;
    private boolean myIsCreateWebConfigFile = true;

    private static boolean hasFacet(FacetEditorContext facetEditorContext, FacetTypeId<?> facetTypeId) {
        return !facetEditorContext.getFacetsProvider().getFacetsByType(facetEditorContext.getModule(), facetTypeId).isEmpty();
    }

    public FacetEditorTab[] createEditorTabs(FacetEditorContext facetEditorContext, FacetValidatorsManager facetValidatorsManager) {
        this.myIsDynamicModules = DMBundleFacetConfiguration.hasFacet(facetEditorContext, SpringFacet.FACET_TYPE_ID);
        this.myIsWebModule = DMBundleFacetConfiguration.hasFacet(facetEditorContext, WebFacet.ID);
        return new FacetEditorTab[]{new DMBundleFacetEditor(facetEditorContext, this)};
    }

    public void loadState(DMBundleFacetConfiguration state) {
        this.setIsSpringDM(state.getIsSpringDM());
        this.setIsWebModule(state.getIsWebModule());
        this.setWebFrameworkVersionName(state.getWebFrameworkVersionName());
        this.setIsCreateWebConfigFile(state.getIsCreateWebConfigFile());
    }

    public DMBundleFacetConfiguration getState() {
        return this;
    }

    @Tag(value="springDM")
    public boolean getIsSpringDM() {
        return this.myIsDynamicModules;
    }

    public void setIsSpringDM(boolean isSpringDM) {
        this.myIsDynamicModules = isSpringDM;
    }

    @Tag(value="web")
    public boolean getIsWebModule() {
        return this.myIsWebModule;
    }

    public void setIsWebModule(boolean isWebModule) {
        this.myIsWebModule = isWebModule;
    }

    @Tag(value="webVersion")
    public String getWebFrameworkVersionName() {
        return this.myWebFrameworkVersionName;
    }

    public void setWebFrameworkVersionName(String webFrameworkVersionName) {
        this.myWebFrameworkVersionName = webFrameworkVersionName;
    }

    @Tag(value="createWebConfigFile")
    public boolean getIsCreateWebConfigFile() {
        return this.myIsCreateWebConfigFile;
    }

    public void setIsCreateWebConfigFile(boolean isCreateWebConfigFile) {
        this.myIsCreateWebConfigFile = isCreateWebConfigFile;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DMBundleFacetConfiguration)) {
            return false;
        }
        DMBundleFacetConfiguration asInstance = (DMBundleFacetConfiguration)obj;
        if (asInstance.getIsSpringDM() != this.getIsSpringDM()) {
            return false;
        }
        if (asInstance.getIsWebModule() != this.getIsWebModule()) {
            return false;
        }
        if (!StringUtil.notNullize((String)asInstance.getWebFrameworkVersionName()).equals(StringUtil.notNullize((String)this.getWebFrameworkVersionName()))) {
            return false;
        }
        return asInstance.getIsCreateWebConfigFile() == this.getIsCreateWebConfigFile();
    }
}

