/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.dmserver.editor.ImportedBundlesPanel;
import com.intellij.dmserver.editor.ImportedLibrariesPanel;
import com.intellij.dmserver.editor.ImportedPackagesPanel;
import com.intellij.dmserver.editor.ImportedUnitsPanel;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.dmserver.util.PsiTreeChangedAdapter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.psi.ManifestFile;

public class ManifestFileEditor
extends UserDataHolderBase
implements FileEditor {
    private JPanel myMainPanel;
    private ImportedUnitsPanel myImportedPackagesPanel;
    private ImportedUnitsPanel myImportedBundlesPanel;
    private ImportedUnitsPanel myImportedLibrariesPanel;
    private final List<ImportedUnitsPanel> myImportedUnitsPanels;
    private final ManifestFile myManifestFile;

    public ManifestFileEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ManifestFileEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ManifestFileEditor.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.myManifestFile = (ManifestFile)PsiManager.getInstance((Project)project).findFile(file);
        this.myImportedUnitsPanels = Arrays.asList(this.myImportedPackagesPanel, this.myImportedBundlesPanel, this.myImportedLibrariesPanel);
        for (ImportedUnitsPanel importedUnitsPanel : this.myImportedUnitsPanels) {
            importedUnitsPanel.init(project, this.myManifestFile);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiTreeChangedAdapter psiTreeChangeListener = new PsiTreeChangedAdapter(){

            @Override
            protected void treeChanged(PsiTreeChangeEvent event) {
                if (ManifestFileEditor.this.myManifestFile != event.getFile()) {
                    return;
                }
                for (ImportedUnitsPanel importedUnitsPanel : ManifestFileEditor.this.myImportedUnitsPanels) {
                    importedUnitsPanel.notifyFileChanged();
                }
            }
        };
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)psiTreeChangeListener, (Disposable)this);
    }

    private void createUIComponents() {
        this.myImportedPackagesPanel = new ImportedPackagesPanel();
        this.myImportedBundlesPanel = new ImportedBundlesPanel();
        this.myImportedLibrariesPanel = new ImportedLibrariesPanel();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            ManifestFileEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMainPanel;
    }

    @NotNull
    public String getName() {
        String string = DmServerBundle.message("ManifestFileEditor.name", new Object[0]);
        if (string == null) {
            ManifestFileEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            ManifestFileEditor.$$$reportNull$$$0(4);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            ManifestFileEditor.$$$reportNull$$$0(5);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            ManifestFileEditor.$$$reportNull$$$0(6);
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return new FileEditorLocation(){

            @NotNull
            public FileEditor getEditor() {
                ManifestFileEditor manifestFileEditor = ManifestFileEditor.this;
                if (manifestFileEditor == null) {
                    2.$$$reportNull$$$0(0);
                }
                return manifestFileEditor;
            }

            public int compareTo(FileEditorLocation fileEditorLocation) {
                return 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/editor/ManifestFileEditor$2", "getEditor"));
            }
        };
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dmserver/editor/ManifestFileEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dmserver/editor/ManifestFileEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(4, 4, 4, 4), -1, -1, true, true));
        ImportedUnitsPanel importedUnitsPanel = this.myImportedPackagesPanel;
        JComponent jComponent = importedUnitsPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        ImportedUnitsPanel importedUnitsPanel2 = this.myImportedBundlesPanel;
        JComponent jComponent2 = importedUnitsPanel2.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        ImportedUnitsPanel importedUnitsPanel3 = this.myImportedLibrariesPanel;
        JComponent jComponent3 = importedUnitsPanel3.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent3, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

