/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.artifacts.WithModulePackagingElement;
import com.intellij.dmserver.artifacts.WithModulePackagingElementType;
import com.intellij.dmserver.facet.DMFacetBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DMArtifactTypeBase<E extends WithModulePackagingElement, T extends WithModulePackagingElementType<E>, F extends DMFacetBase<?>>
extends ArtifactType {
    private static final Logger LOG = Logger.getInstance(DMArtifactTypeBase.class);

    public DMArtifactTypeBase(@NonNls String id, String title) {
        super(id, title);
    }

    public String getDefaultPathFor(@NotNull PackagingElementOutputKind kind) {
        if (kind == null) {
            DMArtifactTypeBase.$$$reportNull$$$0(0);
        }
        return "/";
    }

    protected E addOrFindModuleReference(CompositePackagingElement<?> destinationElement, Module module) {
        Object moduleRef = ((WithModulePackagingElementType)((Object)this.getModulePackagingElementType())).createFor(module);
        moduleRef = (WithModulePackagingElement)destinationElement.addOrFindChild(moduleRef);
        return moduleRef;
    }

    protected static void addOrFindModuleOutputReference(CompositePackagingElement<?> destinationElement, Module module) {
        PackagingElement moduleOutput = PackagingElementFactory.getInstance().createModuleOutput(module);
        destinationElement.addOrFindChild(moduleOutput);
    }

    public final boolean isCompatibleArtifact(@NotNull Artifact artifact) {
        if (artifact == null) {
            DMArtifactTypeBase.$$$reportNull$$$0(1);
        }
        return artifact.getArtifactType() == this;
    }

    public final VirtualFile findMainFileToDeploy(@NotNull Artifact artifact) {
        if (artifact == null) {
            DMArtifactTypeBase.$$$reportNull$$$0(2);
        }
        return DMArtifactTypeBase.findFileByFilter(artifact, this.getMainFileToDeployFilter(artifact));
    }

    @NotNull
    protected abstract VirtualFileFilter getMainFileToDeployFilter(@NotNull Artifact var1);

    private static VirtualFile findFileByFilter(@NotNull Artifact artifact, @NotNull VirtualFileFilter filter) {
        VirtualFile output;
        if (artifact == null) {
            DMArtifactTypeBase.$$$reportNull$$$0(3);
        }
        if (filter == null) {
            DMArtifactTypeBase.$$$reportNull$$$0(4);
        }
        if ((output = LocalFileSystem.getInstance().refreshAndFindFileByPath(artifact.getOutputPath())) == null) {
            LOG.warn("Artifact output doesn't exist, is the artifact built?");
            return null;
        }
        for (VirtualFile nextToDeploy : output.getChildren()) {
            if (!filter.accept(nextToDeploy)) continue;
            return nextToDeploy;
        }
        return null;
    }

    public static VirtualFile findFileByExtension(@NotNull Artifact artifact, String ... extensions) {
        if (artifact == null) {
            DMArtifactTypeBase.$$$reportNull$$$0(5);
        }
        if (extensions == null) {
            DMArtifactTypeBase.$$$reportNull$$$0(6);
        }
        return DMArtifactTypeBase.findFileByFilter(artifact, new ByExtensionFilter(extensions));
    }

    public abstract Artifact createArtifactFor(@NotNull Module var1, @NotNull F var2);

    public abstract void synchronizeArtifact(@NotNull Artifact var1, @NotNull Module var2, @NotNull F var3);

    public abstract T getModulePackagingElementType();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dmserver/artifacts/DMArtifactTypeBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultPathFor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompatibleArtifact";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findMainFileToDeploy";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findFileByFilter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findFileByExtension";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class ByExtensionFilter
    implements VirtualFileFilter {
        private final List<String> myExtensions;

        public ByExtensionFilter(String ... extensions) {
            this.myExtensions = new ArrayList<String>(extensions.length);
            for (String next : extensions) {
                this.myExtensions.add(next.toLowerCase());
            }
        }

        public boolean accept(VirtualFile file) {
            if (file.isDirectory()) {
                return false;
            }
            String extension = file.getExtension();
            return this.myExtensions.contains(extension.toLowerCase());
        }
    }
}

