/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.logging;

import com.vladium.logging.ILogLevels;
import com.vladium.util.ClassLoaderResolver;
import com.vladium.util.Property;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public final class Logger
implements ILogLevels {
    private final int m_level;
    private final PrintWriter m_out;
    private final String m_prefix;
    private final Set m_classMask;
    private static final String PREFIX_TO_STRIP = "com.vladium.";
    private static final int PREFIX_TO_STRIP_LENGTH;
    private static final boolean FLUSH_LOG = true;
    private static final String COMMA_DELIMITERS = ", \t\r\n";
    private static final Logger STATIC_LOGGER;
    private static final ThreadLocalStack THREAD_LOCAL_STACK;
    static /* synthetic */ Class class$com$vladium$logging$Logger;

    public static Logger create(int level, PrintWriter out, String prefix, Set classMask) {
        if (level < -1 || level > 7) {
            throw new IllegalArgumentException("invalid log level: " + level);
        }
        if (out == null) {
            throw new IllegalArgumentException("null or corrupt input: out");
        }
        return new Logger(level, out, prefix, classMask);
    }

    public static Logger create(int level, PrintWriter out, String prefix, Set classMask, Logger base) {
        if (base == null) {
            return Logger.create(level, out, prefix, classMask);
        }
        int _level = level >= -1 ? level : base.m_level;
        PrintWriter _out = out != null && !out.checkError() ? out : base.m_out;
        String _prefix = prefix;
        Set _classMask = classMask != null ? classMask : base.m_classMask;
        return new Logger(_level, _out, _prefix, _classMask);
    }

    public final boolean isLoggable(int level) {
        return level <= this.m_level;
    }

    public final boolean atINFO() {
        return 2 <= this.m_level;
    }

    public final boolean atVERBOSE() {
        return 3 <= this.m_level;
    }

    public final boolean atTRACE1() {
        return 4 <= this.m_level;
    }

    public final boolean atTRACE2() {
        return 5 <= this.m_level;
    }

    public final boolean atTRACE3() {
        return 6 <= this.m_level;
    }

    public final void warning(String msg) {
        this._log(1, null, msg, false);
    }

    public final void info(String msg) {
        this._log(2, null, msg, false);
    }

    public final void verbose(String msg) {
        this._log(3, null, msg, false);
    }

    public final void trace1(String method, String msg) {
        this._log(4, method, msg, true);
    }

    public final void trace2(String method, String msg) {
        this._log(5, method, msg, true);
    }

    public final void trace3(String method, String msg) {
        this._log(6, method, msg, true);
    }

    public final void log(int level, String msg, boolean logCaller) {
        this._log(level, null, msg, logCaller);
    }

    public final void log(int level, String method, String msg, boolean logCaller) {
        this._log(level, method, msg, logCaller);
    }

    public final void log(int level, String msg, Throwable throwable) {
        this._log(level, null, msg, throwable);
    }

    public final void log(int level, String method, String msg, Throwable throwable) {
        this._log(level, method, msg, throwable);
    }

    public PrintWriter getWriter() {
        return this.m_out;
    }

    public static Logger getLogger() {
        LinkedList stack = (LinkedList)THREAD_LOCAL_STACK.get();
        if (stack.isEmpty()) {
            return STATIC_LOGGER;
        }
        return (Logger)stack.getLast();
    }

    public static void push(Logger ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("null input: ctx");
        }
        LinkedList stack = (LinkedList)THREAD_LOCAL_STACK.get();
        stack.addLast(ctx);
    }

    public static void pop(Logger ctx) {
        LinkedList stack = (LinkedList)THREAD_LOCAL_STACK.get();
        try {
            Logger current = (Logger)stack.getLast();
            if (current != ctx) {
                throw new IllegalStateException("invalid context being popped: " + ctx);
            }
            stack.removeLast();
            current.cleanup();
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalStateException("empty logger context stack on thread [" + Thread.currentThread() + "]: " + nsee);
        }
    }

    public static int stringToLevel(String level) {
        if ("severe".equalsIgnoreCase(level) || "silent".equalsIgnoreCase(level)) {
            return 0;
        }
        if ("warning".equalsIgnoreCase(level) || "quiet".equalsIgnoreCase(level)) {
            return 1;
        }
        if ("info".equalsIgnoreCase(level)) {
            return 2;
        }
        if ("verbose".equalsIgnoreCase(level)) {
            return 3;
        }
        if ("trace1".equalsIgnoreCase(level)) {
            return 4;
        }
        if ("trace2".equalsIgnoreCase(level)) {
            return 5;
        }
        if ("trace3".equalsIgnoreCase(level)) {
            return 6;
        }
        if ("none".equalsIgnoreCase(level)) {
            return -1;
        }
        if ("all".equalsIgnoreCase(level)) {
            return 7;
        }
        int _level = Integer.MIN_VALUE;
        try {
            _level = Integer.parseInt(level);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_level >= -1 && _level <= 7) {
            return _level;
        }
        return 2;
    }

    private Logger(int level, PrintWriter out, String prefix, Set classMask) {
        this.m_level = level;
        this.m_out = out;
        this.m_prefix = prefix;
        this.m_classMask = classMask;
    }

    private void cleanup() {
        this.m_out.flush();
    }

    private void _log(int level, String method, String msg, boolean logCaller) {
        if (level <= this.m_level && level >= 0) {
            Class caller = logCaller ? ClassLoaderResolver.getCallerClass(2) : null;
            StringBuffer buf = new StringBuffer(this.m_prefix != null ? this.m_prefix + ": " : "");
            if (caller != null || method != null) {
                buf.append("[");
                if (caller != null) {
                    String callerName = caller.getName();
                    if (callerName.startsWith(PREFIX_TO_STRIP)) {
                        callerName = callerName.substring(PREFIX_TO_STRIP_LENGTH);
                    }
                    String parentName = callerName;
                    int firstDollar = callerName.indexOf(36);
                    if (firstDollar > 0) {
                        parentName = callerName.substring(0, firstDollar);
                    }
                    if (this.m_classMask == null || this.m_classMask.contains(parentName)) {
                        buf.append(callerName);
                    } else {
                        return;
                    }
                }
                if (method != null) {
                    buf.append("::");
                    buf.append(method);
                }
                buf.append("] ");
            }
            PrintWriter out = this.m_out;
            if (msg != null) {
                buf.append(msg);
            }
            out.println(buf);
            out.flush();
        }
    }

    private void _log(int level, String method, String msg, Throwable throwable) {
        if (level <= this.m_level && level >= 0) {
            Class caller = ClassLoaderResolver.getCallerClass(2);
            StringBuffer buf = new StringBuffer(this.m_prefix != null ? this.m_prefix + ": " : "");
            if (caller != null || method != null) {
                buf.append("[");
                if (caller != null) {
                    String callerName = caller.getName();
                    if (callerName.startsWith(PREFIX_TO_STRIP)) {
                        callerName = callerName.substring(PREFIX_TO_STRIP_LENGTH);
                    }
                    String parentName = callerName;
                    int firstDollar = callerName.indexOf(36);
                    if (firstDollar > 0) {
                        parentName = callerName.substring(0, firstDollar);
                    }
                    if (this.m_classMask == null || this.m_classMask.contains(parentName)) {
                        buf.append(callerName);
                    } else {
                        return;
                    }
                }
                if (method != null) {
                    buf.append("::");
                    buf.append(method);
                }
                buf.append("] ");
            }
            PrintWriter out = this.m_out;
            if (msg != null) {
                buf.append(msg);
            }
            if (throwable != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                throwable.printStackTrace(pw);
                pw.flush();
                buf.append(sw.toString());
            }
            out.println(buf);
            out.flush();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringTokenizer tokenizer;
        PREFIX_TO_STRIP_LENGTH = PREFIX_TO_STRIP.length();
        THREAD_LOCAL_STACK = new ThreadLocalStack();
        Properties properties = Property.getAppProperties("emma", (class$com$vladium$logging$Logger == null ? (class$com$vladium$logging$Logger = Logger.class$("com.vladium.logging.Logger")) : class$com$vladium$logging$Logger).getClassLoader());
        String _level = properties.getProperty("verbosity.level", "info");
        int level = Logger.stringToLevel(_level);
        String _filter = properties.getProperty("verbosity.filter");
        HashSet<String> temp = null;
        if (_filter != null && (tokenizer = new StringTokenizer(_filter, COMMA_DELIMITERS)).countTokens() > 0) {
            temp = new HashSet<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                temp.add(tokenizer.nextToken());
            }
        }
        HashSet<String> filter = temp;
        STATIC_LOGGER = Logger.create(level, new PrintWriter(System.out, false), "EMMA", filter);
    }

    private static final class ThreadLocalStack
    extends InheritableThreadLocal {
        private ThreadLocalStack() {
        }

        protected Object initialValue() {
            return new LinkedList();
        }
    }
}

