/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.data;

import com.vladium.emma.data.MethodDescriptor;
import com.vladium.util.IConstants;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public final class ClassDescriptor
implements IConstants,
Serializable {
    private final String m_packageVMName;
    private final String m_name;
    private final long m_stamp;
    private final String m_srcFileName;
    private final MethodDescriptor[] m_methods;
    private final boolean m_hasCompleteLineNumberInfo;
    private transient int m_hash;

    public ClassDescriptor(String packageVMName, String name, long stamp, String srcFileName, MethodDescriptor[] methods) {
        if (packageVMName == null) {
            throw new IllegalArgumentException("null input: packageVMName");
        }
        if (name == null) {
            throw new IllegalArgumentException("null input: name");
        }
        if (methods == null) {
            throw new IllegalArgumentException("null input: methods");
        }
        this.m_packageVMName = packageVMName;
        this.m_name = name;
        this.m_stamp = stamp;
        this.m_srcFileName = srcFileName;
        this.m_methods = methods;
        boolean completeLineNumberInfo = true;
        for (int m = 0; m < this.m_methods.length; ++m) {
            MethodDescriptor method = methods[m];
            if ((method.getStatus() & 0xE) != 0 || this.m_methods[m].hasLineNumberInfo()) continue;
            completeLineNumberInfo = false;
            break;
        }
        this.m_hasCompleteLineNumberInfo = completeLineNumberInfo;
    }

    public final boolean equals(Object rhs) {
        if (!(rhs instanceof ClassDescriptor)) {
            return false;
        }
        ClassDescriptor _rhs = (ClassDescriptor)rhs;
        if (this.hashCode() != _rhs.hashCode()) {
            return false;
        }
        if (!this.m_name.equals(_rhs.m_name)) {
            return false;
        }
        return this.m_packageVMName.equals(_rhs.m_packageVMName);
    }

    public final int hashCode() {
        if (this.m_hash == 0) {
            int hash;
            this.m_hash = hash = this.m_name.hashCode() + 16661 * this.m_packageVMName.hashCode();
            return hash;
        }
        return this.m_hash;
    }

    public final String getPackageVMName() {
        return this.m_packageVMName;
    }

    public final String getName() {
        return this.m_name;
    }

    public final long getStamp() {
        return this.m_stamp;
    }

    public final String getClassVMName() {
        if (this.m_packageVMName.length() == 0) {
            return this.m_name;
        }
        return this.m_packageVMName + "/" + this.m_name;
    }

    public final String getSrcFileName() {
        return this.m_srcFileName;
    }

    public final MethodDescriptor[] getMethods() {
        return this.m_methods;
    }

    public final boolean hasSrcFileInfo() {
        return this.m_srcFileName != null;
    }

    public final boolean hasCompleteLineNumberInfo() {
        return this.m_hasCompleteLineNumberInfo;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuffer s = new StringBuffer(indent + "class [" + (this.m_packageVMName.length() > 0 ? this.m_packageVMName + "/" : "") + this.m_name + "] descriptor:");
        for (int m = 0; m < this.m_methods.length; ++m) {
            s.append(EOL);
            s.append(this.m_methods[m].toString(indent + "  "));
        }
        return s.toString();
    }

    static ClassDescriptor readExternal(DataInput in) throws IOException {
        String packageVMName = in.readUTF();
        String name = in.readUTF();
        long stamp = in.readLong();
        byte srcFileNameFlag = in.readByte();
        String srcFileName = srcFileNameFlag != 0 ? in.readUTF() : null;
        int length = in.readInt();
        MethodDescriptor[] methods = new MethodDescriptor[length];
        for (int i = 0; i < length; ++i) {
            methods[i] = MethodDescriptor.readExternal(in);
        }
        return new ClassDescriptor(packageVMName, name, stamp, srcFileName, methods);
    }

    static void writeExternal(ClassDescriptor cls, DataOutput out) throws IOException {
        out.writeUTF(cls.m_packageVMName);
        out.writeUTF(cls.m_name);
        out.writeLong(cls.m_stamp);
        if (cls.m_srcFileName != null) {
            out.writeByte(1);
            out.writeUTF(cls.m_srcFileName);
        } else {
            out.writeByte(0);
        }
        MethodDescriptor[] methods = cls.m_methods;
        int length = methods.length;
        out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            MethodDescriptor.writeExternal(methods[i], out);
        }
    }
}

