/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Codec;
import io.grpc.Decompressor;
import io.grpc.Status;
import io.grpc.internal.CompositeReadableBuffer;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.ReadableBuffers;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MessageDeframer
implements Closeable {
    private static final int HEADER_LENGTH = 5;
    private static final int COMPRESSED_FLAG_MASK = 1;
    private static final int RESERVED_MASK = 254;
    private final Listener listener;
    private final int maxMessageSize;
    private Decompressor decompressor;
    private State state = State.HEADER;
    private int requiredLength = 5;
    private boolean compressedFlag;
    private boolean endOfStream;
    private CompositeReadableBuffer nextFrame;
    private CompositeReadableBuffer unprocessed = new CompositeReadableBuffer();
    private long pendingDeliveries;
    private boolean deliveryStalled = true;
    private boolean inDelivery = false;

    public MessageDeframer(Listener listener, Decompressor decompressor, int maxMessageSize) {
        this.listener = (Listener)Preconditions.checkNotNull((Object)listener, (Object)"sink");
        this.decompressor = (Decompressor)Preconditions.checkNotNull((Object)decompressor, (Object)"decompressor");
        this.maxMessageSize = maxMessageSize;
    }

    public void setDecompressor(Decompressor decompressor) {
        this.decompressor = (Decompressor)Preconditions.checkNotNull((Object)decompressor, (Object)"Can't pass an empty decompressor");
    }

    public void request(int numMessages) {
        Preconditions.checkArgument((numMessages > 0 ? 1 : 0) != 0, (Object)"numMessages must be > 0");
        if (this.isClosed()) {
            return;
        }
        this.pendingDeliveries += (long)numMessages;
        this.deliver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deframe(ReadableBuffer data, boolean endOfStream) {
        Preconditions.checkNotNull((Object)data, (Object)"data");
        boolean needToCloseData = true;
        try {
            this.checkNotClosed();
            Preconditions.checkState((!this.endOfStream ? 1 : 0) != 0, (Object)"Past end of stream");
            this.unprocessed.addBuffer(data);
            needToCloseData = false;
            this.endOfStream = endOfStream;
            this.deliver();
        }
        finally {
            if (needToCloseData) {
                data.close();
            }
        }
    }

    public boolean isStalled() {
        return this.deliveryStalled;
    }

    @Override
    public void close() {
        try {
            if (this.unprocessed != null) {
                this.unprocessed.close();
            }
            if (this.nextFrame != null) {
                this.nextFrame.close();
            }
        }
        finally {
            this.unprocessed = null;
            this.nextFrame = null;
        }
    }

    public boolean isClosed() {
        return this.unprocessed == null;
    }

    private void checkNotClosed() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"MessageDeframer is already closed");
    }

    private void deliver() {
        if (this.inDelivery) {
            return;
        }
        this.inDelivery = true;
        try {
            boolean stalled;
            block8: while (this.pendingDeliveries > 0L && this.readRequiredBytes()) {
                switch (this.state) {
                    case HEADER: {
                        this.processHeader();
                        continue block8;
                    }
                    case BODY: {
                        this.processBody();
                        --this.pendingDeliveries;
                        continue block8;
                    }
                }
                throw new AssertionError((Object)("Invalid state: " + (Object)((Object)this.state)));
            }
            boolean bl = stalled = this.unprocessed.readableBytes() == 0;
            if (this.endOfStream && stalled) {
                boolean havePartialMessage;
                boolean bl2 = havePartialMessage = this.nextFrame != null && this.nextFrame.readableBytes() > 0;
                if (!havePartialMessage) {
                    this.listener.endOfStream();
                    this.deliveryStalled = false;
                    return;
                }
                throw Status.INTERNAL.withDescription("Encountered end-of-stream mid-frame").asRuntimeException();
            }
            boolean previouslyStalled = this.deliveryStalled;
            this.deliveryStalled = stalled;
            if (stalled && !previouslyStalled) {
                this.listener.deliveryStalled();
            }
        }
        finally {
            this.inDelivery = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readRequiredBytes() {
        int totalBytesRead = 0;
        try {
            boolean bl;
            int missingBytes;
            if (this.nextFrame == null) {
                this.nextFrame = new CompositeReadableBuffer();
            }
            while ((missingBytes = this.requiredLength - this.nextFrame.readableBytes()) > 0) {
                if (this.unprocessed.readableBytes() == 0) {
                    bl = false;
                    return bl;
                }
                int toRead = Math.min(missingBytes, this.unprocessed.readableBytes());
                totalBytesRead += toRead;
                this.nextFrame.addBuffer(this.unprocessed.readBytes(toRead));
            }
            bl = true;
            return bl;
        }
        finally {
            if (totalBytesRead > 0) {
                this.listener.bytesRead(totalBytesRead);
            }
        }
    }

    private void processHeader() {
        int type = this.nextFrame.readUnsignedByte();
        if ((type & 0xFE) != 0) {
            throw Status.INTERNAL.withDescription("Frame header malformed: reserved bits not zero").asRuntimeException();
        }
        this.compressedFlag = (type & 1) != 0;
        this.requiredLength = this.nextFrame.readInt();
        if (this.requiredLength < 0 || this.requiredLength > this.maxMessageSize) {
            throw Status.INTERNAL.withDescription(String.format("Frame size %d exceeds maximum: %d. If this is normal, increase the maxMessageSize in the channel/server builder", this.requiredLength, this.maxMessageSize)).asRuntimeException();
        }
        this.state = State.BODY;
    }

    private void processBody() {
        InputStream stream = this.compressedFlag ? this.getCompressedBody() : this.getUncompressedBody();
        this.nextFrame = null;
        this.listener.messageRead(stream);
        this.state = State.HEADER;
        this.requiredLength = 5;
    }

    private InputStream getUncompressedBody() {
        return ReadableBuffers.openStream(this.nextFrame, true);
    }

    private InputStream getCompressedBody() {
        if (this.decompressor == Codec.Identity.NONE) {
            throw Status.INTERNAL.withDescription("Can't decode compressed frame as compression not configured.").asRuntimeException();
        }
        try {
            InputStream unlimitedStream = this.decompressor.decompress(ReadableBuffers.openStream(this.nextFrame, true));
            return new SizeEnforcingInputStream(unlimitedStream, this.maxMessageSize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static final class SizeEnforcingInputStream
    extends FilterInputStream {
        private final int maxMessageSize;
        private long count;
        private long mark = -1L;

        SizeEnforcingInputStream(InputStream in, int maxMessageSize) {
            super(in);
            this.maxMessageSize = maxMessageSize;
        }

        @Override
        public int read() throws IOException {
            int result = this.in.read();
            if (result != -1) {
                ++this.count;
            }
            this.verifySize();
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.in.read(b, off, len);
            if (result != -1) {
                this.count += (long)result;
            }
            this.verifySize();
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            long result = this.in.skip(n);
            this.count += result;
            this.verifySize();
            return result;
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
            this.mark = this.count;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (!this.in.markSupported()) {
                throw new IOException("Mark not supported");
            }
            if (this.mark == -1L) {
                throw new IOException("Mark not set");
            }
            this.in.reset();
            this.count = this.mark;
        }

        private void verifySize() {
            if (this.count > (long)this.maxMessageSize) {
                throw Status.INTERNAL.withDescription(String.format("Compressed frame exceeds maximum frame size: %d. Bytes read: %d. If this is normal, increase the maxMessageSize in the channel/server builder", this.maxMessageSize, this.count)).asRuntimeException();
            }
        }
    }

    private static enum State {
        HEADER,
        BODY;

    }

    public static interface Listener {
        public void bytesRead(int var1);

        public void messageRead(InputStream var1);

        public void deliveryStalled();

        public void endOfStream();
    }
}

