/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.include;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCssFileIncludeProvider
extends FileIncludeProvider {
    private static final Logger LOG = Logger.getInstance(AbstractCssFileIncludeProvider.class);

    @NotNull
    public abstract String getId();

    public abstract boolean acceptFile(VirtualFile var1);

    public abstract void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> var1);

    @NotNull
    public final FileIncludeInfo[] getIncludeInfos(FileContent inputData) {
        if (!this.hasImports(inputData.getContentAsText())) {
            if (FileIncludeInfo.EMPTY == null) {
                AbstractCssFileIncludeProvider.$$$reportNull$$$0(0);
            }
            return FileIncludeInfo.EMPTY;
        }
        final ArrayList result = ContainerUtil.newArrayList();
        final VirtualFile hostFile = inputData.getFile();
        final String hostFileExt = StringUtil.notNullize((String)hostFile.getExtension());
        inputData.getPsiFile().accept((PsiElementVisitor)new CssElementVisitor(){

            public void visitCssImport(CssImport cssImport) {
                for (String uri : cssImport.getUriStrings()) {
                    if (!AbstractCssFileIncludeProvider.canBeResolvedToLocalFile(uri)) continue;
                    String uriExt = FileUtilRt.getExtension((String)uri);
                    AbstractCssFileIncludeProvider.this.addImports(result, hostFile, hostFileExt, uri, uriExt);
                }
            }

            public void visitElement(PsiElement element) {
                element.acceptChildren((PsiElementVisitor)this);
            }
        });
        FileIncludeInfo[] fileIncludeInfoArray = result.toArray(new FileIncludeInfo[result.size()]);
        if (fileIncludeInfoArray == null) {
            AbstractCssFileIncludeProvider.$$$reportNull$$$0(1);
        }
        return fileIncludeInfoArray;
    }

    private static boolean canBeResolvedToLocalFile(@NotNull String uri) {
        if (uri == null) {
            AbstractCssFileIncludeProvider.$$$reportNull$$$0(2);
        }
        return !HtmlUtil.hasHtmlPrefix((String)uri) && !uri.startsWith("\\\\");
    }

    protected boolean hasImports(@NotNull CharSequence hostFileText) {
        if (hostFileText == null) {
            AbstractCssFileIncludeProvider.$$$reportNull$$$0(3);
        }
        return CharArrayUtil.indexOf((CharSequence)hostFileText, (CharSequence)"@import", (int)0) >= 0;
    }

    protected abstract void addImports(@NotNull List<FileIncludeInfo> var1, @NotNull VirtualFile var2, @NotNull String var3, @NotNull String var4, @NotNull String var5);

    @NotNull
    protected abstract Language getLanguage();

    @Nullable
    public PsiFileSystemItem resolveIncludedFile(@NotNull FileIncludeInfo info, @NotNull PsiFile context) {
        CssImport cssImport;
        PsiFile psiFile;
        PsiFileImpl psiFileImpl;
        if (info == null) {
            AbstractCssFileIncludeProvider.$$$reportNull$$$0(4);
        }
        if (context == null) {
            AbstractCssFileIncludeProvider.$$$reportNull$$$0(5);
        }
        if ((psiFileImpl = (PsiFileImpl)ObjectUtils.tryCast((Object)(psiFile = (cssImport = CssElementFactory.getInstance((Project)context.getProject()).createImport(info.path, this.getLanguage())).getContainingFile()), PsiFileImpl.class)) == null) {
            LOG.error("Expected type: " + PsiFileImpl.class.getName() + ", actual type: " + (psiFile == null ? null : psiFile.getClass().getName()));
            return null;
        }
        psiFileImpl.setOriginalFile(context);
        return (PsiFileSystemItem)ArrayUtil.getFirstElement((Object[])cssImport.resolve());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/include/AbstractCssFileIncludeProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFileText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeInfos";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/include/AbstractCssFileIncludeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canBeResolvedToLocalFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasImports";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveIncludedFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

