/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.css.impl.util.table.CssTableLoaderValue;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.impl.util.table.CssTableValueVisitor;
import com.intellij.psi.css.impl.util.table.XmlStringWriter;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Css3TableGeneratorUtil {
    @NonNls
    public static final String INPUT_DIR_PATH = "css3schema/";
    @NonNls
    public static final String BASE_PATH = "/CSS/src/";
    @NonNls
    private static final String[] MODULES = new String[]{"css3-fonts", "css3-box", "css3-borders", "css3-text"};
    @NonNls
    private static final List<String> mySingleTagNames = new ArrayList<String>();
    private final Map<String, Tag> myGrammarTypes = new HashMap<String, Tag>();

    public static void main(String[] args) throws IOException {
        Css3TableGeneratorUtil util = new Css3TableGeneratorUtil();
        for (String module : MODULES) {
            Tag rootTag = Css3TableGeneratorUtil.parse(Css3TableGeneratorUtil.class.getResourceAsStream(INPUT_DIR_PATH + module + ".html"));
            assert (rootTag != null);
            util.buildGrammarTypes(rootTag);
        }
        for (String module : MODULES) {
            util.generate(module);
        }
        for (String type : CssTableLoaderValue.ourUnknownTypes) {
            System.err.println(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(String moduleName) throws IOException {
        Tag rootTag = Css3TableGeneratorUtil.parse(this.getClass().getResourceAsStream(INPUT_DIR_PATH + moduleName + ".html"));
        String packagePath = this.getClass().getCanonicalName().replace('.', '/');
        File output = new File(PathManager.getHomePath() + BASE_PATH + packagePath.substring(0, packagePath.lastIndexOf(47)), INPUT_DIR_PATH + moduleName + ".xml");
        if (output.exists()) {
            output.delete();
        }
        try (OutputStreamWriter osw = null;){
            osw = new OutputStreamWriter(new FileOutputStream(output));
            XmlStringWriter writer = new XmlStringWriter(osw);
            Tag proptableRootTag = Css3TableGeneratorUtil.findFirstChildTag("table", "proptable", rootTag);
            assert (proptableRootTag != null);
            Tag tbody = Css3TableGeneratorUtil.findFirstChildTag("tbody", proptableRootTag);
            assert (tbody != null);
            writer.addAttribute("version", "3");
            writer.addAttribute("generator-version", "10");
            writer.addAttribute("baseHelpRef", "http://www.w3.org/TR/" + moduleName + "/");
            writer.printlnOpeningTag("css-property-table");
            this.generate(tbody, writer);
            writer.printlnClosingTag();
            writer.flush();
            osw.flush();
            osw.close();
        }
    }

    private void generate(@NotNull Tag tbody, final @NotNull XmlStringWriter writer) {
        if (tbody == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(0);
        }
        if (writer == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(1);
        }
        final ArrayList properties = new ArrayList();
        tbody.for_each(new TagFunction(){

            @Override
            public void fun(@NotNull Tag t) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                properties.addAll(Css3TableGeneratorUtil.gatherNames(t.getChildren().get(0)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/css/impl/util/table/Css3TableGeneratorUtil$1", "fun"));
            }
        }, "tr");
        tbody.for_each(new TagFunction(){

            @Override
            public void fun(@NotNull Tag t) {
                if (t == null) {
                    2.$$$reportNull$$$0(0);
                }
                Css3TableGeneratorUtil.this.proceedRow(t, properties, writer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/css/impl/util/table/Css3TableGeneratorUtil$2", "fun"));
            }
        }, "tr");
    }

    private void buildGrammarTypes(@NotNull Tag tag) {
        if (tag == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(2);
        }
        List<Tag> preTags = Css3TableGeneratorUtil.findSubTags("pre", tag, "prod");
        for (Tag preTag : preTags) {
            Tag var = Css3TableGeneratorUtil.findFirstChildTag("var", preTag);
            assert (var != null);
            String typeName = Css3TableGeneratorUtil.stripLtGt(Css3TableGeneratorUtil.escapeTags(var.getChildren().get(0).getValue()));
            this.myGrammarTypes.put(typeName, preTag);
        }
    }

    private void proceedRow(@NotNull Tag row, @NotNull List<String> properties, @NotNull XmlStringWriter writer) {
        if (row == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(4);
        }
        if (writer == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(5);
        }
        List<Tag> children = row.getChildren();
        List<String> propertyNames = Css3TableGeneratorUtil.gatherNames(children.get(0));
        for (String propertyName : propertyNames) {
            writer.addAttribute("name", propertyName);
            writer.addAttribute("helpRef", Css3TableGeneratorUtil.gatherHelpRef(children.get(0)));
            writer.addAttribute("initialValue", Css3TableGeneratorUtil.gatherTdValue(children.get(2), null));
            writer.addAttribute("appliesTo", Css3TableGeneratorUtil.gatherTdValue(children.get(3), "all"));
            writer.addAttribute("inherited", Css3TableGeneratorUtil.gatherTdValue(children.get(4), null));
            writer.addAttribute("percentage", Css3TableGeneratorUtil.gatherTdValue(children.get(5), "n/a"));
            writer.addAttribute("mediaGroup", Css3TableGeneratorUtil.gatherMediaGroup(children.get(6)));
            writer.printlnOpeningTag("property");
            this.gatherAndWriteValues(propertyName, children.get(1), properties, writer);
            writer.printlnClosingTag();
        }
    }

    private void gatherAndWriteValues(@NotNull String propertyName, @NotNull Tag td, @NotNull List<String> properties, @NotNull XmlStringWriter writer) {
        if (propertyName == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(6);
        }
        if (td == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(7);
        }
        if (properties == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(8);
        }
        if (writer == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(9);
        }
        CssTableLoaderValue value = this.gatherValues(td, properties, false);
        value.write(propertyName, writer);
    }

    private CssTableLoaderValue gatherValues(Tag td, List<String> properties, boolean assignment) {
        final StringBuffer sb = new StringBuffer();
        td.for_each(new TagFunction(){

            @Override
            public void fun(@NotNull Tag t) {
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                Css3TableGeneratorUtil.accumulateValue(t, sb);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/css/impl/util/table/Css3TableGeneratorUtil$3", "fun"));
            }
        }, null);
        String s = sb.toString();
        if (assignment) {
            int eqNds = s.indexOf(61);
            assert (eqNds >= 0);
            s = s.substring(eqNds + 1).trim();
        }
        s = s.replace("&amp;", "&");
        CssTableLoaderValue value = this.doProcessValueList(s, properties);
        assert (value != null);
        Css3TableGeneratorUtil.collapseEmptyGroups(value);
        return value;
    }

    private static void simplifyGroups(@NotNull CssTableLoaderValue value) {
        if (value == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(10);
        }
        value.accept((CssTableValueVisitor)new CssTableValueVisitor<CssTableLoaderValue>(){

            public void visit(@NotNull CssTableLoaderValue value) {
                if (value == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!value.isGroup()) {
                    return;
                }
                for (CssTableLoaderValue each : value.getChildren()) {
                    each.accept(this);
                }
                ArrayList<Object> newChildren = new ArrayList<Object>();
                for (CssTableLoaderValue cssTableLoaderValue : value.getChildren()) {
                    if (cssTableLoaderValue.getType() == value.getType() && cssTableLoaderValue.isGroup() && cssTableLoaderValue.getPrefix() == null && cssTableLoaderValue.getMinCount() == -1 && cssTableLoaderValue.getMaxCount() == -1) {
                        newChildren.addAll(cssTableLoaderValue.getChildren());
                        continue;
                    }
                    newChildren.add(cssTableLoaderValue);
                }
                value.removeAllChildren();
                for (CssTableLoaderValue cssTableLoaderValue : newChildren) {
                    value.addChild(cssTableLoaderValue);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/Css3TableGeneratorUtil$4", "visit"));
            }
        });
    }

    private static void collapseEmptyGroups(@NotNull CssTableLoaderValue value) {
        if (value == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(11);
        }
        value.accept((CssTableValueVisitor)new CssTableValueVisitor<CssTableLoaderValue>(){

            public void visit(@NotNull CssTableLoaderValue value) {
                if (value == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (value.isGroup()) {
                    List children = value.getChildren();
                    if (children.size() == 1) {
                        CssTableLoaderValue value1 = (CssTableLoaderValue)children.get(0);
                        if (value1.isGroup()) {
                            value.setType(value1.getType());
                            if (value.getMinCount() == -1) {
                                value.setMaxCount(value1.getMaxCount());
                                value.setMinCount(value1.getMinCount());
                            }
                            value.removeChild(value1);
                            List children1 = value1.getChildren();
                            for (CssTableLoaderValue each : children1.toArray(new CssTableLoaderValue[children1.size()])) {
                                value1.removeChild(each);
                                value.addChild(each);
                            }
                            value.accept(this);
                        }
                    } else {
                        for (CssTableLoaderValue each : value.getChildren()) {
                            each.accept(this);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/Css3TableGeneratorUtil$5", "visit"));
            }
        });
    }

    @NotNull
    private static List<MyToken> lex(@NotNull String values) {
        if (values == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(12);
        }
        ArrayList<MyToken> tokens = new ArrayList<MyToken>();
        StringBuilder builder = new StringBuilder();
        values = values + '$';
        MyState state = MyState.DEFAULT;
        int n = values.length();
        for (int i = 0; i < n; ++i) {
            char c = values.charAt(i);
            if ("{}()[]+*?".indexOf(c) >= 0) {
                if (state == MyState.ANY) {
                    Css3TableGeneratorUtil.addToken(tokens, "|", true);
                    state = MyState.DEFAULT;
                }
                assert (state == MyState.DEFAULT);
                if (builder.length() > 0) {
                    Css3TableGeneratorUtil.addToken(tokens, builder, false);
                    builder = new StringBuilder();
                }
                Css3TableGeneratorUtil.addToken(tokens, Character.toString(c), true);
                continue;
            }
            if (c == '&') {
                if (state == MyState.AND) {
                    Css3TableGeneratorUtil.addToken(tokens, "&&", true);
                    builder = new StringBuilder();
                    state = MyState.DEFAULT;
                    continue;
                }
                if (state == MyState.DEFAULT) {
                    state = MyState.AND;
                    continue;
                }
                assert (false);
                continue;
            }
            if (c == '|') {
                if (state == MyState.ANY) {
                    Css3TableGeneratorUtil.addToken(tokens, "||", true);
                    builder = new StringBuilder();
                    state = MyState.DEFAULT;
                    continue;
                }
                if (state == MyState.DEFAULT) {
                    state = MyState.ANY;
                    if (builder.length() <= 0) continue;
                    Css3TableGeneratorUtil.addToken(tokens, builder, false);
                    builder = new StringBuilder();
                    continue;
                }
                assert (false);
                continue;
            }
            if (Character.isWhitespace(c) || c == ',' || i == n - 1) {
                if (state == MyState.ANY) {
                    Css3TableGeneratorUtil.addToken(tokens, "|", true);
                    assert (builder.length() == 0);
                } else if (state == MyState.AND) {
                    builder.append('&');
                }
                if (builder.length() > 0) {
                    Css3TableGeneratorUtil.addToken(tokens, builder, false);
                    builder = new StringBuilder();
                }
                state = MyState.DEFAULT;
                continue;
            }
            if (state == MyState.ANY) {
                Css3TableGeneratorUtil.addToken(tokens, "|", true);
                assert (builder.length() == 0);
            } else if (state == MyState.AND) {
                builder.append('&');
            }
            builder.append(c);
            state = MyState.DEFAULT;
        }
        ArrayList<MyToken> arrayList = tokens;
        if (arrayList == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static void addToken(List<MyToken> tokens, CharSequence sequence, boolean operator) {
        String s = sequence.toString();
        tokens.add(operator ? new MyOperatorToken(s) : new MyIdToken(s));
    }

    @Nullable
    private CssTableLoaderValue doProcessValueList(@NotNull String values, List<String> properties) {
        List<MyToken> tokens;
        MyValueParser parser;
        List cssTableLoaderValues;
        if (values == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(14);
        }
        return (cssTableLoaderValues = (parser = new MyValueParser(tokens = Css3TableGeneratorUtil.lex(values), properties)).parseOr()) != null ? Css3TableGeneratorUtil.toGroup(cssTableLoaderValues, CssTableValue.Type.OR) : null;
    }

    private static CssTableLoaderValue toGroup(List<CssTableLoaderValue> values, CssTableValue.Type type) {
        assert (!values.isEmpty());
        if (values.size() == 1) {
            return values.get(0);
        }
        CssTableLoaderValue result = new CssTableLoaderValue(type);
        for (CssTableLoaderValue value : values) {
            result.addChild(value);
        }
        return result;
    }

    @Nullable
    private CssTableLoaderValue createValue(String value, List<String> properties) {
        return this.createValue(value, properties, null);
    }

    @Nullable
    private CssTableLoaderValue createValue(String value, List<String> properties, @Nullable FunctionType functionType) {
        String typeName;
        Tag description;
        if ((value = this.normalize(value, functionType, properties)).isEmpty()) {
            return null;
        }
        if (value.endsWith("#typeref") && (description = this.myGrammarTypes.get(typeName = value.substring(0, value.indexOf(35)))) != null) {
            return this.gatherValues(description, properties, true);
        }
        return new CssTableLoaderValue(this.normalize(value, functionType, properties));
    }

    private String normalize(String name, FunctionType functionType, List<String> properties) {
        if ((name = Css3TableGeneratorUtil.normalizeTagsAndQuotes(name)).isEmpty()) {
            return name;
        }
        if (functionType == FunctionType.DEFAULT) {
            name = name + "#func";
        } else if (functionType == FunctionType.OPTINAL) {
            name = name + "#optfunc";
        }
        if (name.length() >= 4 && (name.charAt(0) == '\u2018' && name.charAt(name.length() - 1) == '\u2019' || name.charAt(0) == '\'' && name.charAt(name.length() - 1) == '\'') && name.charAt(1) == '<' && name.charAt(name.length() - 2) == '>') {
            String refName = name.substring(2, name.length() - 2);
            return refName + "#propref";
        }
        if (name.length() >= 2 && name.charAt(0) == '<' && name.charAt(name.length() - 1) == '>') {
            if (name.length() >= 4 && (name.charAt(1) == '\u2018' && name.charAt(name.length() - 2) == '\u2019' || name.charAt(1) == '\'' && name.charAt(name.length() - 2) == '\'')) {
                String refName = name.substring(2, name.length() - 2);
                return refName + "#propref";
            }
            String vtypeName = name.substring(1, name.length() - 1);
            if (!this.myGrammarTypes.containsKey(vtypeName) && properties.contains(vtypeName)) {
                return vtypeName + "#propref";
            }
            return vtypeName + "#typeref";
        }
        return name;
    }

    private static String normalizeTagsAndQuotes(String s) {
        return s.replace("&lt;", "<").replace("&gt;", ">").replace("&lsquo;", "\u2018").replace("&rsquo;", "\u2019");
    }

    private static String escapeTags(String s) {
        return s.replace("<", "&lt;").replace(">", "&gt;");
    }

    private static void accumulateValue(@NotNull Tag tag, final @NotNull StringBuffer sb) {
        if (tag == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(15);
        }
        if (sb == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(16);
        }
        if (tag.isValueTag()) {
            Tag parent;
            for (parent = tag.getParent(); parent != null && !"td".equals(parent.getName()) && !"a".equals(parent.getName()); parent = parent.getParent()) {
            }
            String value = Css3TableGeneratorUtil.stripLtGt(StringUtil.stripQuotesAroundValue((String)tag.getValue().trim()));
            if (parent != null && "a".equals(parent.getName())) {
                String href = parent.getAttributeValue("href");
                if (href != null) {
                    if (href.contains("value-def")) {
                        sb.append(' ').append(value).append("#helpref=").append(href.substring(href.lastIndexOf(47) + 1));
                    } else if (href.contains("propdef")) {
                        sb.append(' ').append(value).append("#propref");
                    } else {
                        sb.append(' ').append(tag.getValue());
                    }
                }
            } else {
                sb.append(' ').append(tag.getValue());
            }
        }
        tag.for_each(new TagFunction(){

            @Override
            public void fun(@NotNull Tag t) {
                if (t == null) {
                    6.$$$reportNull$$$0(0);
                }
                Css3TableGeneratorUtil.accumulateValue(t, sb);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/css/impl/util/table/Css3TableGeneratorUtil$6", "fun"));
            }
        }, null);
    }

    @NotNull
    private static String stripLtGt(@NotNull String s) {
        if (s == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(17);
        }
        String string = s.replaceAll("&lt;([^&]+)&gt;", "$1");
        if (string == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static String gatherMediaGroup(@NotNull Tag td) {
        Tag a;
        if (td == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(19);
        }
        if ((a = Css3TableGeneratorUtil.findFirstChildTag("a", td)) == null) {
            return Css3TableGeneratorUtil.gatherTdValue(td, null);
        }
        return a.getChildren().get(0).getValue();
    }

    private static String gatherTdValue(@NotNull Tag td, @NonNls @Nullable String defValue) {
        List<Tag> children;
        if (td == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(20);
        }
        if ((children = td.getChildren()).isEmpty() && defValue != null) {
            return defValue;
        }
        String value = td.getChildren().get(0).getValue();
        if ("&nbsp;".equals(value) && defValue != null) {
            return defValue;
        }
        return value.replace("&lsquo;", "'").replace("&rsquo;", "'");
    }

    private static String gatherHelpRef(@NotNull Tag td) {
        if (td == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(21);
        }
        Tag a = Css3TableGeneratorUtil.findFirstChildTag("a", td);
        assert (a != null);
        String href = a.getAttributeValue("href");
        assert (href != null);
        int index = href.lastIndexOf("/");
        return href.substring(index + 1);
    }

    private static List<String> gatherNames(@NotNull Tag td) {
        if (td == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(22);
        }
        List<Tag> spanList = Css3TableGeneratorUtil.findSubTags("a", td, null);
        ArrayList<String> result = new ArrayList<String>();
        for (Tag span : spanList) {
            result.add(StringUtil.stripQuotesAroundValue((String)span.getChildren().get(0).getValue()));
        }
        return result;
    }

    @Nullable
    private static Tag findFirstChildTag(@NotNull @NonNls String name, @NotNull Tag root) {
        if (name == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(23);
        }
        if (root == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(24);
        }
        return Css3TableGeneratorUtil.findFirstChildTag(name, null, root);
    }

    @Nullable
    private static Tag findFirstChildTag(@NotNull @NonNls String name, @Nullable @NonNls String aClass, @NotNull Tag root) {
        if (name == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(25);
        }
        if (root == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(26);
        }
        if (name.equals(root.getName()) && (aClass == null || aClass.equals(root.getAttributeValue("class")))) {
            return root;
        }
        for (Tag child : root.getChildren()) {
            Tag tag = Css3TableGeneratorUtil.findFirstChildTag(name, aClass, child);
            if (tag == null) continue;
            return tag;
        }
        return null;
    }

    @NotNull
    private static List<Tag> findSubTags(@NotNull @NonNls String name, @NotNull Tag root, @Nullable String aClass) {
        if (name == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(27);
        }
        if (root == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(28);
        }
        if (name.equals(root.getName()) && (aClass == null || aClass.equals(root.getAttributeValue("class")))) {
            ArrayList<Tag> result = new ArrayList<Tag>();
            result.add(root);
            ArrayList<Tag> arrayList = result;
            if (arrayList == null) {
                Css3TableGeneratorUtil.$$$reportNull$$$0(29);
            }
            return arrayList;
        }
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (Tag child : root.getChildren()) {
            List<Tag> tempList = Css3TableGeneratorUtil.findSubTags(name, child, aClass);
            result.addAll(tempList);
        }
        ArrayList<Tag> arrayList = result;
        if (arrayList == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @Nullable
    private static Tag parse(@NotNull InputStream is) throws IOException {
        int c;
        if (is == null) {
            Css3TableGeneratorUtil.$$$reportNull$$$0(31);
        }
        boolean tagStart = false;
        StringBuffer startNameBuffer = null;
        StringBuffer endNameBuffer = null;
        StringBuffer valueBuffer = null;
        StringBuffer currentBuffer = null;
        Tag current = null;
        InputStreamReader r = new InputStreamReader(is, CharsetToolkit.UTF8_CHARSET);
        block6: while ((c = ((Reader)r).read()) != -1) {
            switch ((char)c) {
                case '<': {
                    if (valueBuffer != null && current != null) {
                        String value = valueBuffer.toString().trim();
                        if (!value.isEmpty()) {
                            current.addChild(Tag.createValueTag(value));
                        }
                        valueBuffer = null;
                    }
                    tagStart = true;
                    currentBuffer = startNameBuffer = new StringBuffer();
                    continue block6;
                }
                case '>': {
                    if (startNameBuffer != null) {
                        String startTagName = startNameBuffer.toString();
                        Tag childTag = Tag.parseTag(startTagName);
                        if (current != null && childTag != null) {
                            String childTagName = childTag.getName();
                            if ("td".equals(childTagName)) {
                                if ("td".equals(current.getName()) || "th".equals(current.getName())) {
                                    current = current.getParent();
                                }
                            } else if ("tr".equals(childTagName)) {
                                if ("td".equals(current.getName())) {
                                    current = current.getParent().getParent();
                                }
                            } else if ("th".equals(childTagName) && "th".equals(current.getName())) {
                                current = current.getParent();
                            }
                        }
                        if (current != null) {
                            assert (childTag != null);
                            current.addChild(childTag);
                        }
                        if (!mySingleTagNames.contains(childTag.getName())) {
                            current = childTag;
                        }
                        startNameBuffer = null;
                    } else if (endNameBuffer != null) {
                        if (current != null) {
                            String closeName = endNameBuffer.toString();
                            while (current != null && !closeName.equalsIgnoreCase(current.getName())) {
                                current = current.getParent();
                            }
                            if (current != null) {
                                current = current.getParent();
                            }
                        }
                        endNameBuffer = null;
                    }
                    if (valueBuffer != null) break;
                    currentBuffer = valueBuffer = new StringBuffer();
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\u00a0': {
                    continue block6;
                }
                case '/': {
                    if (!tagStart) break;
                    startNameBuffer = null;
                    currentBuffer = endNameBuffer = new StringBuffer();
                    continue block6;
                }
            }
            tagStart = false;
            if (currentBuffer == null) continue;
            currentBuffer.append((char)c);
        }
        return current;
    }

    static {
        mySingleTagNames.add("hr");
        mySingleTagNames.add("link");
        mySingleTagNames.add("meta");
        mySingleTagNames.add("br");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 18: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 18: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tbody";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 7: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "td";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 13: 
            case 18: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/Css3TableGeneratorUtil";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "is";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/Css3TableGeneratorUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "lex";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "stripLtGt";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findSubTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildGrammarTypes";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "proceedRow";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "gatherAndWriteValues";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "simplifyGroups";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collapseEmptyGroups";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lex";
                break;
            }
            case 13: 
            case 18: 
            case 29: 
            case 30: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doProcessValueList";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "accumulateValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "stripLtGt";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "gatherMediaGroup";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "gatherTdValue";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "gatherHelpRef";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "gatherNames";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findFirstChildTag";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findSubTags";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 18: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface TagFunction {
        public void fun(@NotNull Tag var1);
    }

    private static class Tag {
        private Tag myParent;
        private final Map<String, String> myAttributes;
        private final List<Tag> myChildren;
        private String myValue;
        private String myName;

        private Tag(@NotNull String name) {
            if (name == null) {
                Tag.$$$reportNull$$$0(0);
            }
            this.myAttributes = new THashMap();
            this.myChildren = new ArrayList<Tag>();
            this.myName = name;
        }

        private Tag() {
            this.myAttributes = new THashMap();
            this.myChildren = new ArrayList<Tag>();
        }

        public static Tag createValueTag(@NotNull String s) {
            if (s == null) {
                Tag.$$$reportNull$$$0(1);
            }
            Tag tag = new Tag();
            tag.setValue(s);
            return tag;
        }

        public static Tag parseTag(@NotNull String s) {
            if (s == null) {
                Tag.$$$reportNull$$$0(2);
            }
            StringTokenizer tokenizer = new StringTokenizer(s);
            Tag result = new Tag(tokenizer.nextToken());
            while (tokenizer.hasMoreTokens()) {
                String pair = tokenizer.nextToken();
                int eqNdx = pair.indexOf(61);
                if (eqNdx != -1) {
                    result.addAttribute(pair.substring(0, eqNdx), StringUtil.stripQuotesAroundValue((String)pair.substring(eqNdx + 1)));
                    continue;
                }
                result.addAttribute(pair, null);
            }
            return result;
        }

        public void for_each(@NotNull TagFunction func, @NonNls @Nullable String nameFilter) {
            if (func == null) {
                Tag.$$$reportNull$$$0(3);
            }
            for (Tag tag : this.getChildren()) {
                if ((nameFilter == null || !nameFilter.equals(tag.getName())) && nameFilter != null) continue;
                func.fun(tag);
            }
        }

        @NonNls
        public String getName() {
            return this.myName;
        }

        public void addAttribute(@NotNull String name, @Nullable String value) {
            if (name == null) {
                Tag.$$$reportNull$$$0(4);
            }
            this.myAttributes.put(name, value);
        }

        public void setParent(Tag parent) {
            this.myParent = parent;
        }

        public void addChild(@NotNull Tag child) {
            if (child == null) {
                Tag.$$$reportNull$$$0(5);
            }
            this.myChildren.add(child);
            child.setParent(this);
        }

        public void setValue(String value) {
            this.myValue = value;
        }

        @NotNull
        public List<Tag> getChildren() {
            List<Tag> list = this.myChildren;
            if (list == null) {
                Tag.$$$reportNull$$$0(6);
            }
            return list;
        }

        public String getValue() {
            return this.myValue;
        }

        public Tag getParent() {
            return this.myParent;
        }

        public boolean isValueTag() {
            return this.myValue != null;
        }

        @Nullable
        public String getAttributeValue(@NonNls @NotNull String name) {
            if (name == null) {
                Tag.$$$reportNull$$$0(7);
            }
            return this.myAttributes.get(name);
        }

        public String toString() {
            if (this.myName == null) {
                return this.myValue;
            }
            StringBuilder result = new StringBuilder(this.getName());
            if (!this.myAttributes.isEmpty()) {
                result.append(" [");
                for (String key : this.myAttributes.keySet()) {
                    result.append(" ").append(key).append("=").append(this.myAttributes.get(key));
                }
                result.append("]");
            }
            return result.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "func";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/impl/util/table/Css3TableGeneratorUtil$Tag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/impl/util/table/Css3TableGeneratorUtil$Tag";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createValueTag";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "parseTag";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "for_each";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addAttribute";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addChild";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttributeValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum FunctionType {
        DEFAULT,
        OPTINAL;

    }

    private class MyValueParser {
        private int myIndex;
        private final List<String> myProperties;
        private final List<MyToken> myTokens;

        private MyValueParser(@NotNull List<MyToken> tokens, List<String> properties) {
            if (tokens == null) {
                MyValueParser.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                MyValueParser.$$$reportNull$$$0(1);
            }
            this.myIndex = 0;
            this.myTokens = tokens;
            this.myProperties = properties;
        }

        @Nullable
        private List<CssTableLoaderValue> parseOr() {
            List<CssTableLoaderValue> val1 = this.parseAny();
            if (val1 == null) {
                return null;
            }
            CssTableLoaderValue val1group = Css3TableGeneratorUtil.toGroup(val1, CssTableValue.Type.ANY);
            if (this.myIndex == this.myTokens.size()) {
                return Collections.singletonList(val1group);
            }
            MyToken operator = this.myTokens.get(this.myIndex);
            if (!(operator instanceof MyOperatorToken) || !operator.myText.equals("|")) {
                return Collections.singletonList(val1group);
            }
            ++this.myIndex;
            List<CssTableLoaderValue> val2 = this.parseOr();
            if (val2 == null) {
                return null;
            }
            ArrayList<CssTableLoaderValue> result = new ArrayList<CssTableLoaderValue>();
            result.add(val1group);
            result.addAll(val2);
            return result;
        }

        @Nullable
        private List<CssTableLoaderValue> parseAny() {
            List<CssTableLoaderValue> val1 = this.parseFullAny();
            if (val1 == null) {
                return null;
            }
            CssTableLoaderValue val1Group = Css3TableGeneratorUtil.toGroup(val1, CssTableValue.Type.FULL_ANY);
            if (this.myIndex == this.myTokens.size()) {
                return Collections.singletonList(val1Group);
            }
            MyToken operator = this.myTokens.get(this.myIndex);
            if (!(operator instanceof MyOperatorToken) || !operator.myText.equals("||")) {
                return Collections.singletonList(val1Group);
            }
            ++this.myIndex;
            List<CssTableLoaderValue> val2 = this.parseAny();
            if (val2 == null) {
                return null;
            }
            ArrayList<CssTableLoaderValue> result = new ArrayList<CssTableLoaderValue>();
            result.add(val1Group);
            result.addAll(val2);
            return result;
        }

        @Nullable
        private List<CssTableLoaderValue> parseFullAny() {
            List<CssTableLoaderValue> val1 = this.parseSequence();
            if (val1 == null) {
                return null;
            }
            CssTableLoaderValue val1group = Css3TableGeneratorUtil.toGroup(val1, CssTableValue.Type.DEFAULT);
            if (this.myIndex == this.myTokens.size()) {
                return Collections.singletonList(val1group);
            }
            MyToken operator = this.myTokens.get(this.myIndex);
            if (!(operator instanceof MyOperatorToken) || !operator.myText.equals("&&")) {
                return Collections.singletonList(val1group);
            }
            ++this.myIndex;
            List<CssTableLoaderValue> val2 = this.parseFullAny();
            if (val2 == null) {
                return null;
            }
            ArrayList<CssTableLoaderValue> result = new ArrayList<CssTableLoaderValue>();
            result.add(val1group);
            result.addAll(val2);
            return result;
        }

        @Nullable
        private List<CssTableLoaderValue> parseSequence() {
            CssTableLoaderValue val1 = this.parseExp();
            if (val1 == null) {
                return null;
            }
            if (!val1.isGroup() && ((String)val1.getValue()).equals("/")) {
                List<CssTableLoaderValue> tail = this.parseSequence();
                if (tail == null) {
                    return null;
                }
                CssTableLoaderValue result = new CssTableLoaderValue(CssTableValue.Type.DEFAULT);
                for (CssTableLoaderValue value : tail) {
                    result.addChild(value);
                }
                result.setPrefix("/");
                return Collections.singletonList(result);
            }
            if (this.myIndex == this.myTokens.size()) {
                return Collections.singletonList(val1);
            }
            List<CssTableLoaderValue> val2 = this.parseSequence();
            if (val2 == null) {
                return Collections.singletonList(val1);
            }
            ArrayList<CssTableLoaderValue> result = new ArrayList<CssTableLoaderValue>();
            result.add(val1);
            result.addAll(val2);
            return result;
        }

        @Nullable
        private CssTableLoaderValue parseExp() {
            CssTableLoaderValue val = this.parseGroupOrValue();
            if (val == null) {
                return null;
            }
            if (this.myIndex == this.myTokens.size()) {
                return val;
            }
            MyToken t = this.myTokens.get(this.myIndex);
            if (!(t instanceof MyOperatorToken)) {
                return val;
            }
            if (t.myText.equals("{")) {
                ++this.myIndex;
                int[] numbers = this.parseNumberList();
                t = this.myTokens.get(this.myIndex);
                assert (t instanceof MyOperatorToken && t.myText.equals("}"));
                assert (numbers.length == 2);
                ++this.myIndex;
                val.setMinCount(numbers[0]);
                val.setMaxCount(numbers[1]);
            } else if (t.myText.equals("+")) {
                ++this.myIndex;
                val.setMinCount(1);
            } else if (t.myText.equals("*")) {
                ++this.myIndex;
                val.setMinCount(0);
            } else if (t.myText.equals("?")) {
                ++this.myIndex;
                val.setMinCount(0);
                val.setMaxCount(1);
            }
            return val;
        }

        @Nullable
        private CssTableLoaderValue parseGroupOrValue() {
            FunctionType functionType;
            MyToken t = this.myTokens.get(this.myIndex);
            if (t instanceof MyOperatorToken) {
                if (t.myText.equals("[")) {
                    ++this.myIndex;
                    List<CssTableLoaderValue> values = this.parseOr();
                    t = this.myTokens.get(this.myIndex);
                    assert (t instanceof MyOperatorToken && t.myText.equals("]"));
                    ++this.myIndex;
                    return Css3TableGeneratorUtil.toGroup(values, CssTableValue.Type.OR);
                }
                return null;
            }
            String name = t.myText;
            ++this.myIndex;
            if (this.myIndex < this.myTokens.size() && (functionType = this.parseFunctionSuffix()) != null) {
                return Css3TableGeneratorUtil.this.createValue(name, this.myProperties, functionType);
            }
            return Css3TableGeneratorUtil.this.createValue(name, this.myProperties);
        }

        @Nullable
        private FunctionType parseFunctionSuffix() {
            MyToken t = this.myTokens.get(this.myIndex);
            if (!(t instanceof MyOperatorToken)) {
                return null;
            }
            if (t.myText.equals("[")) {
                if (this.myIndex + 1 == this.myTokens.size()) {
                    return null;
                }
                t = this.myTokens.get(this.myIndex + 1);
                if (!(t instanceof MyOperatorToken) || !t.myText.equals("(")) {
                    return null;
                }
                int openedBrackets = 1;
                while (openedBrackets != 0) {
                    ++this.myIndex;
                    t = this.myTokens.get(this.myIndex);
                    if (!(t instanceof MyOperatorToken)) continue;
                    if (t.myText.equals("[")) {
                        ++openedBrackets;
                        continue;
                    }
                    if (!t.myText.equals("]")) continue;
                    --openedBrackets;
                }
                ++this.myIndex;
                t = this.myTokens.get(this.myIndex);
                assert (t instanceof MyOperatorToken && t.myText.equals("?"));
                ++this.myIndex;
                return FunctionType.OPTINAL;
            }
            if (t.myText.equals("(")) {
                int openedParens = 1;
                while (openedParens != 0) {
                    ++this.myIndex;
                    t = this.myTokens.get(this.myIndex);
                    if (!(t instanceof MyOperatorToken)) continue;
                    if (t.myText.equals("(")) {
                        ++openedParens;
                        continue;
                    }
                    if (!t.myText.equals(")")) continue;
                    --openedParens;
                }
                ++this.myIndex;
                return FunctionType.DEFAULT;
            }
            return null;
        }

        @NotNull
        private int[] parseNumberList() {
            TIntArrayList result = new TIntArrayList();
            while (true) {
                block5: {
                    MyToken t;
                    if ((t = this.myTokens.get(this.myIndex)) instanceof MyIdToken) {
                        try {
                            result.add(Integer.parseInt(t.myText));
                            break block5;
                        }
                        catch (NumberFormatException e) {
                            break;
                        }
                    }
                    if (!t.myText.equals(",")) break;
                }
                ++this.myIndex;
            }
            int[] nArray = result.toNativeArray();
            if (nArray == null) {
                MyValueParser.$$$reportNull$$$0(2);
            }
            return nArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokens";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/impl/util/table/Css3TableGeneratorUtil$MyValueParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/impl/util/table/Css3TableGeneratorUtil$MyValueParser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseNumberList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyOperatorToken
    extends MyToken {
        protected MyOperatorToken(@NotNull String text) {
            if (text == null) {
                MyOperatorToken.$$$reportNull$$$0(0);
            }
            super(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/impl/util/table/Css3TableGeneratorUtil$MyOperatorToken", "<init>"));
        }
    }

    private static class MyIdToken
    extends MyToken {
        protected MyIdToken(@NotNull String text) {
            if (text == null) {
                MyIdToken.$$$reportNull$$$0(0);
            }
            super(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/impl/util/table/Css3TableGeneratorUtil$MyIdToken", "<init>"));
        }
    }

    private static abstract class MyToken {
        final String myText;

        protected MyToken(@NotNull String text) {
            if (text == null) {
                MyToken.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        public String toString() {
            return this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/impl/util/table/Css3TableGeneratorUtil$MyToken", "<init>"));
        }
    }

    private static enum MyState {
        DEFAULT,
        AND,
        ANY;

    }
}

