/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.references;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.css.resolve.UrlReference;
import com.intellij.psi.css.resolve.impl.CssResolverImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.ultimate.UltimateVerifier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssResolveManagerImpl
extends CssResolveManager {
    public CssResolveManagerImpl(UltimateVerifier verifier) {
        PluginVerifier.verifyUltimatePlugin(verifier);
    }

    public CssResolver getNewResolver() {
        return new CssResolverImpl();
    }

    public CssDeclaration[] resolve(XmlTag tag, XmlFile[] xhtmlFiles, CssStylesheet defaultStylesheet) {
        CssResolverImpl resolver = new CssResolverImpl();
        if (defaultStylesheet != null) {
            resolver.setDefaultStylesheet(defaultStylesheet);
        }
        return resolver.resolve(tag, (PsiFile[])xhtmlFiles, null);
    }

    @NotNull
    public PsiFile[] resolveFiles(@Nullable PsiElement uriElement, @NotNull PsiFile base) {
        if (base == null) {
            CssResolveManagerImpl.$$$reportNull$$$0(0);
        }
        if (uriElement instanceof CssUri) {
            uriElement = ((CssUri)uriElement).getValueElement();
        }
        if (uriElement == null) {
            if (PsiFile.EMPTY_ARRAY == null) {
                CssResolveManagerImpl.$$$reportNull$$$0(1);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        ArrayList result = ContainerUtil.newArrayList();
        PsiReference[] references = uriElement.getReferences();
        if (references.length == 0) {
            references = CssResolveManagerImpl.getJspHackReferences(uriElement);
        }
        for (PsiReference reference : references) {
            if (reference instanceof FileReference) {
                if (!((FileReference)reference).isLast()) continue;
                for (ResolveResult resolveResult : ((FileReference)reference).multiResolve(false)) {
                    CssResolveManagerImpl.addStylesheetFile(result, resolveResult.getElement());
                }
                continue;
            }
            if (reference instanceof PsiDynaReference) {
                PsiFileReference fileReference = ((PsiDynaReference)reference).getLastFileReference();
                if (fileReference == null) continue;
                for (ResolveResult resolveResult : fileReference.multiResolve(false)) {
                    CssResolveManagerImpl.addStylesheetFile(result, resolveResult.getElement());
                }
                continue;
            }
            if (!(reference instanceof UrlReference)) continue;
            CssResolveManagerImpl.addStylesheetFile(result, reference.resolve());
        }
        PsiFile[] psiFileArray = !result.isEmpty() ? result.toArray(new PsiFile[result.size()]) : PsiFile.EMPTY_ARRAY;
        if (psiFileArray == null) {
            CssResolveManagerImpl.$$$reportNull$$$0(2);
        }
        return psiFileArray;
    }

    private static void addStylesheetFile(@NotNull Collection<PsiFile> result, @Nullable PsiElement element) {
        PsiFile stylesheetFile;
        if (result == null) {
            CssResolveManagerImpl.$$$reportNull$$$0(3);
        }
        if (element == null || !(element instanceof PsiFile)) {
            return;
        }
        if (!(element instanceof StylesheetFile) && (stylesheetFile = ((PsiFile)element).getViewProvider().getPsi((Language)CSSLanguage.INSTANCE)) instanceof StylesheetFile) {
            result.add(stylesheetFile);
            return;
        }
        result.add((PsiFile)element);
    }

    @NotNull
    private static PsiReference[] getJspHackReferences(@NotNull PsiElement element) {
        XmlAttributeValue valueElement;
        XmlAttribute[] attributes;
        PsiElement elementAt;
        XmlTag tag;
        String value;
        if (element == null) {
            CssResolveManagerImpl.$$$reportNull$$$0(4);
        }
        OuterLanguageElement childOfType = null;
        for (PsiElement sibling = element.getFirstChild(); sibling != null; sibling = sibling.getNextSibling()) {
            if (!(sibling instanceof OuterLanguageElement)) continue;
            childOfType = (OuterLanguageElement)sibling;
            break;
        }
        if (childOfType != null && (value = ElementManipulators.getValueText((PsiElement)element)).equals(childOfType.getText()) && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(elementAt = element.getContainingFile().findElementAt(childOfType.getTextOffset())), XmlTag.class)) != null && (attributes = tag.getAttributes()).length == 1 && !"http://java.sun.com/JSP/Page".equals(tag.getNamespace()) && CssResolveManagerImpl.isUrlDecoratingCustomTag(tag) && tag.getTextRange().equals((Object)childOfType.getTextRange()) && (valueElement = attributes[0].getValueElement()) != null) {
            PsiReference[] psiReferenceArray = valueElement.getReferences();
            if (psiReferenceArray == null) {
                CssResolveManagerImpl.$$$reportNull$$$0(5);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            CssResolveManagerImpl.$$$reportNull$$$0(6);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean isUrlDecoratingCustomTag(@NotNull XmlTag tag) {
        String localName;
        if (tag == null) {
            CssResolveManagerImpl.$$$reportNull$$$0(7);
        }
        if ("url".equals(localName = tag.getLocalName())) {
            return Arrays.binarySearch(XmlUtil.JSTL_CORE_URIS, tag.getNamespace()) >= 0;
        }
        return "rewrite".equals(localName) && "http://struts.apache.org/tags-html".equals(tag.getNamespace());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/references/CssResolveManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/references/CssResolveManagerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getJspHackReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveFiles";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addStylesheetFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getJspHackReferences";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUrlDecoratingCustomTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

