/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.handler;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.descriptor.value.CssFunctionInvocationValue;
import com.intellij.psi.css.impl.util.CssColorUtil;
import com.intellij.psi.css.impl.util.table.CssCompletionContext;
import com.intellij.psi.css.impl.util.table.CssPropertyDescriptorImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CssPropertyValueInsertHandler
implements InsertHandler<LookupElement> {
    public static final InsertHandler<LookupElement> INSTANCE = new CssPropertyValueInsertHandler();

    public void handleInsert(InsertionContext context, LookupElement item) {
        CssPropertyDescriptor propertyValueDescriptor;
        PsiElement elementAtCaret = context.getFile().findElementAt(context.getStartOffset());
        CssTerm cssTerm = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, CssTerm.class, (boolean)false);
        if (cssTerm != null && cssTerm.getTermType() == CssTermTypes.COLOR) {
            CssPropertyValueInsertHandler.completeCssColor(cssTerm, context.getProject(), context.getDocument());
        }
        Editor editor = context.getEditor();
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, CssDeclaration.class);
        CssPropertyDescriptor cssPropertyDescriptor = propertyValueDescriptor = declaration != null ? declaration.getDescriptor() : null;
        if (declaration != null && propertyValueDescriptor == null) {
            propertyValueDescriptor = (CssPropertyDescriptor)ContainerUtil.getFirstItem((Collection)declaration.getDescriptors());
        }
        if (propertyValueDescriptor != null) {
            CssCompletionContext cssCompletionContext = CssPropertyDescriptorImpl.buildFullContext(declaration);
            String declarationsTerminator = CssPsiUtil.getDeclarationsTerminatorFromContext((PsiElement)elementAtCaret);
            String elementTerminator = null;
            CssPropertyValue value = propertyValueDescriptor.getValue();
            boolean statementIsCompleted = PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, CssFunction.class) == null && PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, CssUri.class) == null && cssCompletionContext != null && value != null && value.isCompleted(cssCompletionContext);
            String afterDeclarationText = null;
            int lineEndOffset = document.getLineEndOffset(document.getLineNumber(offset));
            if (document.getTextLength() >= offset) {
                afterDeclarationText = document.getText(TextRange.create((int)offset, (int)lineEndOffset)).trim();
            }
            if (StringUtil.startsWithChar((CharSequence)declarationsTerminator, (char)context.getCompletionChar())) {
                return;
            }
            if (StringUtil.isEmpty((String)afterDeclarationText)) {
                elementTerminator = declarationsTerminator;
            } else if (statementIsCompleted && declarationsTerminator.equals(afterDeclarationText)) {
                if (declarationsTerminator.isEmpty()) {
                    offset = lineEndOffset;
                } else {
                    CharSequence sequence = document.getCharsSequence();
                    while (offset < lineEndOffset && sequence.charAt(offset) != declarationsTerminator.charAt(0)) {
                        ++offset;
                    }
                    ++offset;
                }
                elementTerminator = "";
            }
            if (offset <= document.getTextLength() && elementTerminator != null) {
                document.insertString(offset, (CharSequence)elementTerminator);
                context.setTailOffset(offset);
                if (statementIsCompleted) {
                    editor.getCaretModel().moveToOffset(offset + elementTerminator.length());
                    context.setTailOffset(offset + elementTerminator.length());
                }
            }
        }
        if (item.getObject() instanceof CssFunctionInvocationValue) {
            if ("()".equals(document.getText(TextRange.create((int)(offset - 2), (int)offset)))) {
                editor.getCaretModel().moveToOffset(offset - 1);
                AutoPopupController.getInstance((Project)context.getProject()).autoPopupParameterInfo(editor, elementAtCaret);
            } else if ("(\"\")".equals(document.getText(TextRange.create((int)(offset - 4), (int)offset)))) {
                editor.getCaretModel().moveToOffset(offset - 2);
                AutoPopupController.getInstance((Project)context.getProject()).autoPopupParameterInfo(editor, elementAtCaret);
            }
        }
    }

    private static int completeCssColor(@NotNull CssTerm cssTerm, @NotNull Project project, @NotNull Document document) {
        String text;
        if (cssTerm == null) {
            CssPropertyValueInsertHandler.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CssPropertyValueInsertHandler.$$$reportNull$$$0(1);
        }
        if (document == null) {
            CssPropertyValueInsertHandler.$$$reportNull$$$0(2);
        }
        if (StringUtil.startsWithChar((CharSequence)(text = cssTerm.getText()), (char)'#')) {
            String newColorText = CssColorUtil.formatHexColorAccordingToCodeStyle(text, project);
            TextRange range = cssTerm.getTextRange();
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)newColorText);
            return newColorText.length() - text.length();
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "cssTerm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "document";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/css/impl/util/completion/handler/CssPropertyValueInsertHandler";
        objectArray[2] = "completeCssColor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

