/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;

public class CssImportantInsertHandler
implements InsertHandler<LookupElement> {
    public static final InsertHandler<LookupElement> INSTANCE = new CssImportantInsertHandler();

    private CssImportantInsertHandler() {
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        Project project;
        Editor editor = context.getEditor();
        String declarationTerminator = CssPsiUtil.getDeclarationsTerminatorFromContext((PsiElement)context.getFile().findElementAt(context.getStartOffset()));
        if (StringUtil.isEmpty((String)declarationTerminator)) {
            return;
        }
        if (declarationTerminator.length() == 1 && context.getCompletionChar() == declarationTerminator.charAt(0)) {
            context.setAddCompletionChar(false);
        }
        if ((project = editor.getProject()) != null) {
            if (!CssImportantInsertHandler.isStringAtCaret(editor, declarationTerminator)) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)declarationTerminator);
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            } else {
                editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + declarationTerminator.length());
            }
        }
    }

    private static boolean isStringAtCaret(Editor editor, String s) {
        int startOffset = editor.getCaretModel().getOffset();
        int endOffset = startOffset + s.length();
        Document document = editor.getDocument();
        return document.getTextLength() > endOffset && s.equals(document.getCharsSequence().subSequence(startOffset, endOffset).toString());
    }
}

