/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssDescriptorOwner;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssMediaFeatureDescriptor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.descriptor.CssCompositeElementDescriptor;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoClassDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoElementDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.ColorSampleLookupValue;
import com.intellij.xml.util.documentation.HtmlDocumentationProvider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssDocumentationProvider
extends DocumentationProviderEx {
    @NotNull
    private final DocumentationProvider myHtmlProvider;

    public CssDocumentationProvider() {
        DocumentationProvider htmlProvider = LanguageDocumentation.INSTANCE.forLanguage((Language)HTMLLanguage.INSTANCE);
        if (htmlProvider instanceof HtmlDocumentationProvider) {
            htmlProvider = new HtmlDocumentationProvider(false);
        } else if (htmlProvider instanceof CompositeDocumentationProvider) {
            ArrayList providers = ContainerUtil.newArrayList();
            for (DocumentationProvider provider : ((CompositeDocumentationProvider)htmlProvider).getProviders()) {
                if (provider instanceof HtmlDocumentationProvider) {
                    providers.add(new HtmlDocumentationProvider(false));
                    continue;
                }
                providers.add(provider);
            }
            htmlProvider = CompositeDocumentationProvider.wrapProviders((Collection)providers);
        }
        this.myHtmlProvider = htmlProvider;
    }

    @NotNull
    public static String[] getUrlsFor(@NotNull String descriptorText, PsiElement context) {
        Collection descriptors;
        if (descriptorText == null) {
            CssDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (!(descriptors = CssDescriptorsUtil.sortDescriptors((Collection)CssDescriptorsUtil.getPropertyDescriptors((String)descriptorText, (PsiElement)context))).isEmpty()) {
            LinkedHashSet urls = ContainerUtil.newLinkedHashSet();
            for (CssElementDescriptor descriptor : descriptors) {
                ContainerUtil.addIfNotNull((Collection)urls, (Object)descriptor.getSpecificationUrl());
            }
            String[] stringArray = ArrayUtil.toStringArray((Collection)urls);
            if (stringArray == null) {
                CssDocumentationProvider.$$$reportNull$$$0(1);
            }
            return stringArray;
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            CssDocumentationProvider.$$$reportNull$$$0(2);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        ItemPresentation presentation;
        CssSelectorSuffixType suffixType;
        if (element instanceof CssSelectorSuffix && (suffixType = ((CssSelectorSuffix)element).getType()) != CssSelectorSuffixType.UNKNOWN && (presentation = ((NavigationItem)element).getPresentation()) != null) {
            String fileName = null;
            if (element.getContainingFile() != null) {
                fileName = element.getContainingFile().getName();
            }
            if (suffixType == CssSelectorSuffixType.CLASS) {
                return CssBundle.message((String)(fileName == null ? "css.class.term" : "css.class.term.with.file"), (Object[])new Object[]{presentation.getPresentableText(), fileName});
            }
            return CssBundle.message((String)(fileName == null ? "css.id.term" : "css.id.term.with.file"), (Object[])new Object[]{presentation.getPresentableText(), fileName});
        }
        return null;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String urlForHtml;
        PsiElement docElement = CssDocumentationProvider.findDocumentationElement(element);
        if (docElement instanceof CssDescriptorOwner) {
            ArrayList result = Lists.newArrayList();
            PsiElement context = originalElement != null ? originalElement : docElement;
            for (CssElementDescriptor cssElementDescriptor : CssDocumentationProvider.getFilteredAndSortedDescriptors((CssDescriptorOwner)docElement, context)) {
                String specificationUrl = cssElementDescriptor.getSpecificationUrl();
                if (specificationUrl == null) continue;
                result.add(specificationUrl);
            }
            return result;
        }
        PsiElement tagElement = CssDocumentationProvider.findTagElement(element);
        if (tagElement != null && (urlForHtml = HtmlDocumentationProvider.getUrlForHtml((PsiElement)tagElement, null)) != null) {
            return Collections.singletonList(urlForHtml);
        }
        return null;
    }

    @Nullable
    private static PsiElement findDocumentationElement(PsiElement element) {
        PsiElement docElement = element;
        if (!CssUtil.isCssDeclaration(element) || CssPsiUtil.isInFunction((PsiElement)element)) {
            docElement = CssDocumentationProvider.getDocumentationElement(element);
        }
        return docElement;
    }

    @Nullable
    public static PsiElement getDocumentationElement(@Nullable PsiElement element) {
        PsiElement context;
        if (element == null) {
            return null;
        }
        CssDescriptorOwner descriptorOwner = CssDocumentationProvider.findDescriptorOwner(element);
        if (descriptorOwner != null) {
            return descriptorOwner;
        }
        PsiElement prevContext = element;
        if (context instanceof PsiFile) {
            while (prevContext.getPrevSibling() != null) {
                prevContext = prevContext.getPrevSibling();
            }
            return CssUtil.isIdent(prevContext) ? prevContext : null;
        }
        if (!(context instanceof CssElement)) {
            return null;
        }
        for (context = element.getContext(); context != null; context = context.getContext()) {
            PsiElement prevSibling = prevContext.getPrevSibling();
            if (context instanceof XmlAttributeValue && prevSibling instanceof CssBlock) {
                return prevSibling.findElementAt(prevSibling.getTextLength() - 2);
            }
            if (context instanceof CssSimpleSelector) {
                return ((CssSimpleSelector)context).getNameIdentifier();
            }
            if (context instanceof CssStylesheet || context instanceof CssDeclaration) {
                return CssDocumentationProvider.getIdent(context);
            }
            prevContext = context;
        }
        return null;
    }

    @Nullable
    private static PsiElement getIdent(@NotNull PsiElement declaration) {
        PsiElement firstChild;
        if (declaration == null) {
            CssDocumentationProvider.$$$reportNull$$$0(3);
        }
        return CssUtil.isIdent(firstChild = PsiTreeUtil.getDeepestFirst((PsiElement)declaration)) ? firstChild : null;
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String doc;
        PsiElement docElement = CssDocumentationProvider.findDocumentationElement(element);
        if (docElement != null && (doc = CssDocumentationProvider.generateDoc(docElement.getText(), docElement, originalElement)) != null) {
            return doc;
        }
        PsiElement tagElement = CssDocumentationProvider.findTagElement(element);
        if (tagElement != null) {
            return this.myHtmlProvider.generateDoc(tagElement, null);
        }
        return null;
    }

    @Nullable
    private static PsiElement findTagElement(PsiElement element) {
        CssSimpleSelector simpleSelector = (CssSimpleSelector)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssSimpleSelector.class});
        if (simpleSelector != null && (simpleSelector == element || simpleSelector.getFirstChild() == element)) {
            return simpleSelector.getNameIdentifier();
        }
        return null;
    }

    @Nullable
    public static String generateDoc(@Nullable String descriptorText, @NotNull PsiElement documentationElement, @Nullable PsiElement context) {
        CssElementDescriptorProvider descriptorProvider;
        if (documentationElement == null) {
            CssDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (descriptorText == null) {
            return null;
        }
        if (documentationElement instanceof CssDescriptorOwner) {
            String documentation;
            PsiElement child;
            Color color;
            PsiElement descriptorProviderContext = context != null ? context : documentationElement;
            Collection<? extends CssElementDescriptor> descriptors = CssDocumentationProvider.getFilteredAndSortedDescriptors((CssDescriptorOwner)documentationElement, descriptorProviderContext);
            if (descriptors.isEmpty()) {
                return null;
            }
            StringBuilder colorText = new StringBuilder();
            if (context != null && (color = CssPsiColorUtil.getColor((child = context.getLastChild()) != null ? child : context)) != null) {
                ColorSampleLookupValue.addColorPreviewAndCodeToLookup((Color)color, (StringBuilder)colorText);
            }
            if (!(documentation = StringUtil.join((Collection)CssDescriptorsUtil.extractDocumentations(descriptors, (PsiElement)context), (String)"<hr/>")).isEmpty()) {
                return colorText.length() > 0 ? colorText + "<br/><hr/>" + documentation : documentation;
            }
        }
        if ((descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)context)) != null) {
            return descriptorProvider.generateDocForSelector(descriptorText, context);
        }
        return null;
    }

    @Nullable
    private static CssDescriptorOwner createNavigationElementForDescriptorOwner(@NotNull CssElementDescriptor descriptor, @Nullable PsiElement context, @NotNull Project project) {
        if (descriptor == null) {
            CssDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (project == null) {
            CssDocumentationProvider.$$$reportNull$$$0(6);
        }
        Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)context);
        String id = descriptor.getId();
        if (descriptor instanceof CssPseudoSelectorDescriptor) {
            return CssElementFactory.getInstance((Project)project).createPseudoSelector(descriptor.getPresentableName(), language);
        }
        if (descriptor instanceof CssFunctionDescriptor) {
            return CssElementFactory.getInstance((Project)project).createFunction(id, language);
        }
        if (descriptor instanceof CssPropertyDescriptor) {
            return CssElementFactory.getInstance((Project)project).createProperty(id, "value", language);
        }
        if (descriptor instanceof CssMediaFeatureDescriptor) {
            return CssElementFactory.getInstance((Project)project).createMediaFeature(id, "value", language);
        }
        if (descriptor instanceof CssCompositeElementDescriptor) {
            return CssDocumentationProvider.createNavigationElementForDescriptorOwner(((CssCompositeElementDescriptor)descriptor).getDescriptorFromLatestSpec(), context, project);
        }
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, @Nullable Object object, PsiElement element) {
        if (object == null || object instanceof LiveTemplateLookupElement) {
            return null;
        }
        return CssDocumentationProvider.createNavigationElement(psiManager, object, element);
    }

    @Nullable
    private static PsiElement createNavigationElement(PsiManager psiManager, @NotNull Object lookupObject, @Nullable PsiElement _context) {
        boolean isTag;
        PsiElement docElement;
        CssElementDescriptorProvider provider;
        CssDescriptorOwner descriptorOwner;
        if (lookupObject == null) {
            CssDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (lookupObject instanceof CssElementDescriptor && (descriptorOwner = CssDocumentationProvider.createNavigationElementForDescriptorOwner((CssElementDescriptor)lookupObject, _context, psiManager.getProject())) != null) {
            return descriptorOwner;
        }
        String _text = lookupObject.toString();
        Object text = _text;
        Collection propertyDescriptors = CssDescriptorsUtil.getPropertyDescriptors((String)text, (PsiElement)_context);
        PsiElement context = CssDocumentationProvider.findDocumentationElement(_context);
        if (context == null) {
            context = _context;
        }
        if ((provider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)context)) == null) {
            return null;
        }
        if (propertyDescriptors.isEmpty()) {
            String textFromContext = context != null ? StringUtil.notNullize((String)context.getText()).trim() : "";
            propertyDescriptors = provider.findPropertyDescriptors(textFromContext, context);
            text = textFromContext;
        }
        if (!propertyDescriptors.isEmpty()) {
            for (CssPropertyDescriptor propertyDescriptor : propertyDescriptors) {
                PsiElement[] navElements = propertyDescriptor.getDeclarations(_context);
                if (navElements.length != 1) continue;
                return navElements[0];
            }
        }
        if ((docElement = provider.getDocumentationElementForSelector(_text, context)) != null) {
            return docElement;
        }
        if (!propertyDescriptors.isEmpty() || context != null && !provider.providesClassicCss() && provider.isPossibleSelector((String)text, context)) {
            return CssDocumentationProvider.createDummyElement((String)text, context);
        }
        if (context != null && (isTag = CssDescriptorsUtil.isPossibleSelector((String)_text, (PsiElement)context)) && ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)CSSLanguage.INSTANCE)).isIdentifier(_text, psiManager.getProject())) {
            Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)context);
            return CssElementFactory.getInstance((Project)psiManager.getProject()).createSimpleSelector(_text, language);
        }
        return null;
    }

    @Nullable
    static PsiElement createDummyElement(@NotNull String text, @Nullable PsiElement context) {
        if (text == null) {
            CssDocumentationProvider.$$$reportNull$$$0(8);
        }
        if (context == null) {
            return null;
        }
        PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)context, PsiFile.class);
        if (file == null) {
            return null;
        }
        FileElement fileElement = DummyHolderFactory.createHolder((PsiManager)context.getManager(), null).getTreeElement();
        CssTokenImpl cssToken = new CssTokenImpl(CssElementTypes.CSS_IDENT, fileElement.getCharTable().intern((CharSequence)text));
        fileElement.rawAddChildren((TreeElement)cssToken);
        cssToken.putUserData(DocumentationManager.ORIGINAL_ELEMENT_KEY, SmartPointerManager.getInstance((Project)context.getProject()).createSmartPsiElementPointer(context));
        return (PsiElement)cssToken;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, @NotNull String link, PsiElement context) {
        if (link == null) {
            CssDocumentationProvider.$$$reportNull$$$0(9);
        }
        Collection descriptors = Collections.emptyList();
        if (link.startsWith("PC:")) {
            descriptors = ContainerUtil.filter((Collection)CssDescriptorsUtil.getPseudoSelectorDescriptors((String)StringUtil.trimStart((String)link, (String)"PC:"), (PsiElement)context), (Condition)Conditions.instanceOf(CssPseudoClassDescriptor.class));
        } else if (link.startsWith("PE:")) {
            descriptors = ContainerUtil.filter((Collection)CssDescriptorsUtil.getPseudoSelectorDescriptors((String)StringUtil.trimStart((String)link, (String)"PE:"), (PsiElement)context), (Condition)Conditions.instanceOf(CssPseudoElementDescriptor.class));
        } else if (link.startsWith("MF:")) {
            descriptors = CssDescriptorsUtil.getMediaFeatureDescriptors((String)StringUtil.trimStart((String)link, (String)"MF:"), (PsiElement)context);
        } else if (link.startsWith("P:")) {
            descriptors = CssDescriptorsUtil.getPropertyDescriptors((String)StringUtil.trimStart((String)link, (String)"P:"), (PsiElement)context);
        } else if (link.startsWith("F:")) {
            descriptors = CssDescriptorsUtil.getFunctionDescriptors((String)StringUtil.trimStart((String)link, (String)"F:"), (PsiElement)context);
        }
        CssElementDescriptor firstDescriptor = (CssElementDescriptor)ContainerUtil.getFirstItem((Collection)CssDescriptorsUtil.sortDescriptors((Collection)descriptors));
        if (firstDescriptor != null) {
            return CssDocumentationProvider.createNavigationElement(psiManager, firstDescriptor, context);
        }
        return CssDocumentationProvider.createNavigationElement(psiManager, link, context);
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement) {
        CssDescriptorOwner descriptorOwner;
        if (editor == null) {
            CssDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (file == null) {
            CssDocumentationProvider.$$$reportNull$$$0(11);
        }
        if ((descriptorOwner = CssDocumentationProvider.findDescriptorOwner(contextElement)) != null) {
            return descriptorOwner;
        }
        CssSimpleSelector simpleSelector = (CssSimpleSelector)PsiTreeUtil.getParentOfType((PsiElement)contextElement, CssSimpleSelector.class, (boolean)false);
        if (simpleSelector != null) {
            return simpleSelector.getNameIdentifier();
        }
        return super.getCustomDocumentationElement(editor, file, contextElement);
    }

    @Nullable
    private static CssDescriptorOwner findDescriptorOwner(PsiElement context) {
        CssDescriptorOwner descriptorOwner = (CssDescriptorOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssDescriptorOwner.class});
        return descriptorOwner != null && descriptorOwner.getParent() instanceof CssPseudoSelector ? (CssDescriptorOwner)descriptorOwner.getParent() : descriptorOwner;
    }

    @NotNull
    private static Collection<? extends CssElementDescriptor> getFilteredAndSortedDescriptors(@NotNull CssDescriptorOwner descriptorOwner, @NotNull PsiElement descriptorProviderContext) {
        Collection descriptors;
        Collection filteredByContext;
        if (descriptorOwner == null) {
            CssDocumentationProvider.$$$reportNull$$$0(12);
        }
        if (descriptorProviderContext == null) {
            CssDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (!(filteredByContext = CssDescriptorsUtil.filterDescriptorsByContext((Collection)(descriptors = descriptorOwner.getDescriptors(descriptorProviderContext)), (PsiElement)descriptorProviderContext)).isEmpty()) {
            descriptors = filteredByContext;
        }
        Collection collection = descriptors = CssDescriptorsUtil.sortDescriptors((Collection)descriptors);
        if (collection == null) {
            CssDocumentationProvider.$$$reportNull$$$0(14);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorText";
                break;
            }
            case 1: 
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/CssDocumentationProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentationElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupObject";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorOwner";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorProviderContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/CssDocumentationProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlsFor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredAndSortedDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUrlsFor";
                break;
            }
            case 1: 
            case 2: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIdent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateDoc";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNavigationElementForDescriptorOwner";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNavigationElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDummyElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationElementForLink";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredAndSortedDescriptors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

