/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.colors;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.actions.colors.CssColorIntentionBase;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorPickerListenerFactory;
import com.intellij.util.IncorrectOperationException;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssChooseColorIntention
extends CssColorIntentionBase
implements Iconable,
HighPriorityAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Color color;
        PsiElement colorTerm;
        if (project == null) {
            CssChooseColorIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            CssChooseColorIntention.$$$reportNull$$$0(1);
        }
        if ((colorTerm = CssChooseColorIntention.getPossibleColorTerm(element)) != null && (color = CssPsiColorUtil.getColor(colorTerm)) != null) {
            CssChooseColorIntention.changeColorWithPicker(editor, color, ColorDeclarationType.fromColorTerm(colorTerm), colorTerm);
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            CssChooseColorIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            CssChooseColorIntention.$$$reportNull$$$0(3);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        PsiElement colorTerm = CssChooseColorIntention.getPossibleColorTerm(element);
        if (colorTerm != null) {
            return CssPsiColorUtil.getColor(colorTerm) != null;
        }
        return false;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            CssChooseColorIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"css.intentions.color.change", (Object[])new Object[0]);
        if (string == null) {
            CssChooseColorIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void changeColorWithPicker(@Nullable Editor editor, @NotNull Color color, @NotNull ColorDeclarationType type, @Nullable PsiElement element) {
        if (color == null) {
            CssChooseColorIntention.$$$reportNull$$$0(6);
        }
        if (type == null) {
            CssChooseColorIntention.$$$reportNull$$$0(7);
        }
        if (editor != null) {
            if (element == null || !element.isValid()) {
                return;
            }
            List listeners = ColorPickerListenerFactory.createListenersFor((PsiElement)element);
            Color newColor = ColorChooser.chooseColor((Component)editor.getComponent(), (String)CssBundle.message((String)"css.choose.color.dialog.title", (Object[])new Object[0]), (Color)color, (boolean)true, (List)listeners, (boolean)true);
            if (newColor != null) {
                CssChooseColorIntention.changeColor(editor, CssPsiColorUtil.convertTo(type, newColor), element);
            }
        }
    }

    private static void changeColor(@NotNull Editor editor, @NotNull String hexColor, @Nullable PsiElement element) {
        if (editor == null) {
            CssChooseColorIntention.$$$reportNull$$$0(8);
        }
        if (hexColor == null) {
            CssChooseColorIntention.$$$reportNull$$$0(9);
        }
        if (element != null && element.isValid()) {
            Project project = element.getProject();
            WriteCommandAction.runWriteCommandAction((Project)project, (String)"Update CSS color", null, () -> {
                if (editor == null) {
                    CssChooseColorIntention.$$$reportNull$$$0(10);
                }
                if (hexColor == null) {
                    CssChooseColorIntention.$$$reportNull$$$0(11);
                }
                if (project.isDisposed() || editor.isDisposed()) {
                    return;
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                if (!element.isValid()) {
                    return;
                }
                CssElementFactory elementFactory = CssElementFactory.getInstance((Project)project);
                CssTermList termList = elementFactory.createPropertyValue(hexColor, CssPsiUtil.getStylesheetLanguage((PsiElement)element));
                if (element instanceof CssTermList) {
                    element.replace((PsiElement)termList);
                } else if (element instanceof CssTerm) {
                    element.replace(termList.getFirstChild());
                } else {
                    PsiElement term = termList.getFirstChild();
                    element.replace(term.getFirstChild());
                }
            }, (PsiFile[])new PsiFile[]{element.getContainingFile()});
        }
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return AllIcons.Gutter.Colors;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/colors/CssChooseColorIntention";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hexColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/colors/CssChooseColorIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "changeColorWithPicker";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "changeColor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$changeColor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

