/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.javaee.model.xml.web.converters;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.javaee.web.CommonFilter;
import com.intellij.javaee.web.WebModel;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Collections;

/**
 * @author peter
 */
public class FilterNameConverter extends ResolvingConverter<CommonFilter> {

  @NotNull
  @Override
  public Collection<? extends CommonFilter> getVariants(ConvertContext context) {
    WebModel webModel = ServletNameConverter.getModel(context);
    return webModel == null ? Collections.<CommonFilter>emptyList() : webModel.getFilters();
  }

  @Nullable
  @Override
  public CommonFilter fromString(@Nullable @NonNls String s, ConvertContext context) {
    if (s == null) return null;
    WebModel webModel = ServletNameConverter.getModel(context);
    return webModel != null ? webModel.findFilter(s) : null;
  }

  @Nullable
  @Override
  public String toString(@Nullable CommonFilter filter, ConvertContext context) {
    return filter != null ? filter.getFilterName().getStringValue() : null;
  }

  @Override
  public String getErrorMessage(@Nullable String s, ConvertContext context) {
    return CodeInsightBundle.message("error.cannot.resolve.0.1", "Filter", s);
  }
}
