package com.intellij.javaee.customDeployment;

import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.openapi.project.Project;

import javax.swing.*;
import java.util.Collection;

public abstract class CustomDeploymentActionHandler {

  private final String myName;
  private final Icon myIcon;
  private final Project myProject;
  private final DeploymentSourcesCollection mySources;

  public CustomDeploymentActionHandler(String name, Icon icon, Project project, DeploymentSourcesCollection sources) {
    myName = name;
    myIcon = icon;
    myProject = project;
    mySources = sources;
  }

  public String getName() {
    return myName;
  }

  public Icon getIcon() {
    return myIcon;
  }

  protected Project getProject() {
    return myProject;
  }

  protected void addSource(DeploymentSource source) {
    mySources.addItem(source);
  }

  protected Collection<DeploymentSource> getChosenSources() {
    return mySources.getItems();
  }

  public abstract boolean isAvailable();

  public abstract void run();
}
