package com.intellij.javaee.appServerIntegrations;

import com.intellij.framework.FrameworkType;
import org.jetbrains.annotations.NotNull;

import java.io.File;
import java.util.List;
import java.util.Map;

/**
 * @author nik
 */
public abstract class AppServerLibrariesProvider {
  /**
   * This operation may be time consuming so it must not be called from the Event Dispatch Thread
   * @return jars providing framework implementation from the application server installation
   */
  @NotNull
  public abstract Map<FrameworkType, List<File>> getFrameworkLibraries();
}
