/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.spring.model.xml.beans;

import com.intellij.spring.model.xml.util.SpringConstant;
import com.intellij.util.xml.SubTag;
import org.jetbrains.annotations.NotNull;

/**
 * @author Dmitry Avdeev
 */
public interface SpringInjection extends SpringValueHolder, SpringValueHolderDefinition, Description {

  /**
   * Returns the value of the meta child.
   * <pre>
   * <h3>Element http://www.springframework.org/schema/beans:meta documentation</h3>
   * 	Arbitrary metadata attached to a bean definition.
   * <p/>
   * </pre>
   *
   * @return the value of the meta child.
   */
  @NotNull
  Meta getMeta();

  @SubTag("constant")
  SpringConstant getConstant();
}
