/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated on Thu Nov 09 17:15:14 MSK 2006
// DTD/Schema  :    http://www.springframework.org/schema/beans

package com.intellij.spring.model.xml.beans;

import com.intellij.psi.PsiMethod;
import com.intellij.spring.model.converters.SpringBeanDestroyMethodConverter;
import com.intellij.spring.model.converters.SpringBeanInitMethodConverter;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Stubbed;
import org.jetbrains.annotations.NotNull;

public interface LifecycleBean extends DomElement {

  /**
   * Returns the value of the init-method child.
   * <pre>
   * <h3>Attribute null:init-method documentation</h3>
   * 	The name of the custom initialization method to invoke after setting
   * 	bean properties. The method must have no arguments, but may throw any
   * 	exception.
   * <p/>
   * </pre>
   *
   * @return the value of the init-method child.
   */
  @NotNull
  @Convert(value = SpringBeanInitMethodConverter.class)
  @Stubbed
  GenericAttributeValue<PsiMethod> getInitMethod();


  /**
   * Returns the value of the destroy-method child.
   * <pre>
   * <h3>Attribute null:destroy-method documentation</h3>
   * 	The name of the custom destroy method to invoke on bean factory
   * 	shutdown. The method must have no arguments, but may throw any
   * 	exception.
   * 	Note: Only invoked on beans whose lifecycle is under the full
   * 	control of the factory - which is always the case for singletons,
   * 	but not guaranteed for any other scope.
   * <p/>
   * </pre>
   *
   * @return the value of the destroy-method child.
   */
  @NotNull
  @Convert(value = SpringBeanDestroyMethodConverter.class)
  @Stubbed
  GenericAttributeValue<PsiMethod> getDestroyMethod();

}
