/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated on Thu Nov 09 17:15:14 MSK 2006
// DTD/Schema  :    http://www.springframework.org/schema/beans

package com.intellij.spring.model.xml.beans;

import com.intellij.spring.model.values.ListOrSetValueConverter;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.util.xml.*;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * http://www.springframework.org/schema/beans:collectionElements model group interface.
 */
public interface CollectionElements extends DomElement, Description {

  @NotNull
  @Stubbed
  List<SpringBean> getBeans();

  SpringBean addBean();

  @CustomChildren
  List<CustomBeanWrapper> getCustomBeans();


  @NotNull
  @Stubbed
  List<SpringRef> getRefs();

  SpringRef addRef();


  @NotNull
  @Stubbed
  List<Idref> getIdrefs();

  Idref addIdref();


  /**
   * Returns the list of value children.
   * <pre>
   * <h3>Element http://www.springframework.org/schema/beans:value documentation</h3>
   * 	Contains a string representation of a property value.
   * 	The property may be a string, or may be converted to the required
   * 	type using the JavaBeans PropertyEditor machinery. This makes it
   * 	possible for application developers to write custom PropertyEditor
   * 	implementations that can convert strings to arbitrary target objects.
   * 	Note that this is recommended for simple objects only. Configure
   * 	more complex objects by populating JavaBean properties with
   * 	references to other beans.
   *
   * </pre>
   *
   * @return the list of value children.
   */
  @Convert(ListOrSetValueConverter.class)
  @NotNull
  @Stubbed
  List<SpringValue> getValues();

  SpringValue addValue();


  @NotNull
  SpringNull getNull();


  @NotNull
  @Stubbed
  List<ListOrSet> getLists();

  @NotNull
  @Stubbed
  List<ListOrSet> getArrays();

  @NotNull
  @Stubbed
  List<ListOrSet> getSets();

  @NotNull
  @Stubbed
  List<SpringMap> getMaps();

  @NotNull
  @SubTagList("props")
  List<Props> getProps();

  @SubTagList("props")
  Props addProps();
}