/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.actions.patterns.frameworks.ui;

import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.module.Module;

public class LibrariesInfo {
    private LibraryInfo[] myLibs;
  private Module myModule;
  private String myName;

  public LibrariesInfo(final LibraryInfo[] libs, final Module module, final String name) {
    myLibs = libs;
    myModule = module;
    myName = name;
  }

  public LibraryInfo[] getLibs() {
    return myLibs;
  }

  public void setLibs(final LibraryInfo[] libs) {
    myLibs = libs;
  }

  public Module getModule() {
    return myModule;
  }

  public void setModule(final Module module) {
    myModule = module;
  }

  public String getName() {
    return myName;
  }

  public void setName(final String name) {
    myName = name;
  }
}
