/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.el.contextProviders;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.annotations.NotNull;

/**
 * @since 2016.2
 */
public abstract class SpringElInjectionContext {

  private static final ExtensionPointName<SpringElInjectionContext> EP_NAME =
    new ExtensionPointName<>("com.intellij.spring.el.injection.context");

  public static SpringElInjectionContext[] getProviders() {
    return Extensions.getExtensions(EP_NAME);
  }

  public abstract boolean isSpringElCompatibleHost(@NotNull PsiLiteralExpression host);
}
